/*
 * Decompiled with CFR 0.152.
 */
package org.openid4java.discovery.xri;

import com.google.inject.Inject;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openid4java.discovery.DiscoveryException;
import org.openid4java.discovery.DiscoveryInformation;
import org.openid4java.discovery.XriIdentifier;
import org.openid4java.discovery.xrds.XrdsParser;
import org.openid4java.discovery.xrds.XrdsServiceEndpoint;
import org.openid4java.discovery.xri.XriResolver;
import org.openid4java.util.HttpFetcher;
import org.openid4java.util.HttpFetcherFactory;
import org.openid4java.util.HttpRequestOptions;
import org.openid4java.util.HttpResponse;
import org.openid4java.util.OpenID4JavaUtils;

public class XriDotNetProxyResolver
implements XriResolver {
    private static Log _log = LogFactory.getLog(XriDotNetProxyResolver.class);
    private static final boolean DEBUG = _log.isDebugEnabled();
    private final HttpFetcher _httpFetcher;
    private static final String PROXY_URL = "https://xri.net/";
    private static final String XRDS_QUERY = "_xrd_r=application/xrds+xml";
    private static final String XRDS_PARSER_CLASS_NAME_KEY = "discovery.xrds.parser";
    private static final XrdsParser XRDS_PARSER;

    @Inject
    public XriDotNetProxyResolver(HttpFetcherFactory httpFetcherfactory) {
        this._httpFetcher = httpFetcherfactory.createFetcher(HttpRequestOptions.getDefaultOptionsForDiscovery());
    }

    public XriDotNetProxyResolver() {
        this(new HttpFetcherFactory());
    }

    public List discover(XriIdentifier xri) throws DiscoveryException {
        String hxri = PROXY_URL + xri.getIdentifier() + "?" + XRDS_QUERY;
        _log.info((Object)("Performing discovery on HXRI: " + hxri));
        try {
            HttpResponse resp = this._httpFetcher.get(hxri);
            if (resp == null || 200 != resp.getStatusCode()) {
                throw new DiscoveryException("Error retrieving HXRI: " + hxri);
            }
            Set targetTypes = DiscoveryInformation.OPENID_OP_TYPES;
            List endpoints = XRDS_PARSER.parseXrds(resp.getBody(), targetTypes);
            ArrayList<DiscoveryInformation> results = new ArrayList<DiscoveryInformation>();
            for (XrdsServiceEndpoint endpoint : endpoints) {
                for (String type : endpoint.getTypes()) {
                    if (!targetTypes.contains(type)) continue;
                    try {
                        results.add(new DiscoveryInformation(new URL(endpoint.getUri()), this.parseIdentifier(endpoint.getCanonicalId()), "http://specs.openid.net/auth/2.0/signon".equals(type) ? endpoint.getLocalId() : (DiscoveryInformation.OPENID1_SIGNON_TYPES.contains(type) ? endpoint.getDelegate() : null), type));
                    }
                    catch (MalformedURLException e) {
                        throw new DiscoveryException("Invalid endpoint URL discovered: " + endpoint.getUri());
                    }
                }
            }
            return results;
        }
        catch (IOException e) {
            throw new DiscoveryException("Error performing discovery on HXRI: " + hxri);
        }
    }

    public XriIdentifier parseIdentifier(String identifier) throws DiscoveryException {
        _log.warn((Object)"Creating XRI identifier with the friendly XRI identifier as the IRI/URI normal forms.");
        return new XriIdentifier(identifier, identifier, identifier);
    }

    static {
        String className = OpenID4JavaUtils.getProperty(XRDS_PARSER_CLASS_NAME_KEY);
        if (DEBUG) {
            _log.debug((Object)("discovery.xrds.parser:" + className));
        }
        try {
            XRDS_PARSER = (XrdsParser)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

