/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir.operands;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jruby.RubyString;
import org.jruby.compiler.ir.operands.Operand;
import org.jruby.compiler.ir.operands.Variable;
import org.jruby.compiler.ir.representations.InlinerInfo;
import org.jruby.interpreter.InterpreterContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BacktickString
extends Operand {
    public final List<Operand> pieces;

    public BacktickString(Operand val) {
        this.pieces = new ArrayList<Operand>();
        this.pieces.add(val);
    }

    public BacktickString(List<Operand> pieces) {
        this.pieces = pieces;
    }

    @Override
    public boolean isConstant() {
        for (Operand o : this.pieces) {
            if (o.isConstant()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isNonAtomicValue() {
        return true;
    }

    @Override
    public Operand getSimplifiedOperand(Map<Operand, Operand> valueMap) {
        int i2 = 0;
        for (Operand p2 : this.pieces) {
            this.pieces.set(i2, p2.getSimplifiedOperand(valueMap));
            ++i2;
        }
        return this;
    }

    @Override
    public void addUsedVariables(List<Variable> l) {
        for (Operand o : this.pieces) {
            o.addUsedVariables(l);
        }
    }

    @Override
    public Operand cloneForInlining(InlinerInfo ii) {
        if (this.isConstant()) {
            return this;
        }
        ArrayList<Operand> newPieces = new ArrayList<Operand>();
        for (Operand p2 : this.pieces) {
            newPieces.add(p2.cloneForInlining(ii));
        }
        return new BacktickString(newPieces);
    }

    @Override
    public Object retrieve(InterpreterContext interp) {
        RubyString newString = interp.getRuntime().newString();
        for (Operand p2 : this.pieces) {
            newString.append((IRubyObject)p2.retrieve(interp));
        }
        return ((IRubyObject)interp.getSelf()).callMethod(interp.getContext(), "`", newString);
    }
}

