/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.engines.mediawiki.matchers;

import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.util.CallbackMatcher;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.wiki.model.WikiPage;
import java.util.regex.MatchResult;

public class DirectURLMatcher
extends CallbackMatcher {
    private static final String _URL_REGEX = "<a href=\"[^\"]*?Special:Edit[^\"]*?topic=[^\"]*?\".*?title=\"([^\"]*?)\".*?>(.*?)</a>";
    private String _attachmentURLPrefix;
    private CallbackMatcher.Callback _callBack = new CallbackMatcher.Callback(){

        public String foundMatch(MatchResult matchResult) {
            String fileName = StringUtil.replace((String)matchResult.group(1), (String)"%5F", (String)"_");
            String title = StringUtil.replace((String)matchResult.group(2), (String)"%5F", (String)"_");
            if (Validator.isNull((String)title)) {
                title = fileName;
            }
            String url = String.valueOf(DirectURLMatcher.this._attachmentURLPrefix) + HttpUtil.encodeURL((String)fileName);
            try {
                for (FileEntry fileEntry : DirectURLMatcher.this._page.getAttachmentsFileEntries()) {
                    if (!fileName.equals(fileEntry.getTitle())) continue;
                    StringBundler sb = new StringBundler(5);
                    sb.append("<a href=\"");
                    sb.append(url);
                    sb.append("\">");
                    sb.append(title);
                    sb.append("</a>");
                    return sb.toString();
                }
            }
            catch (Exception exception) {}
            return null;
        }
    };
    private WikiPage _page;

    public DirectURLMatcher(WikiPage page, String attachmentURLPrefix) {
        this._page = page;
        this._attachmentURLPrefix = attachmentURLPrefix;
        this.setRegex(_URL_REGEX);
    }

    public String replaceMatches(CharSequence charSequence) {
        return this.replaceMatches(charSequence, this._callBack);
    }
}

