/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.action;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.struts.PortletAction;
import com.liferay.portlet.messageboards.NoSuchMessageException;
import com.liferay.portlet.messageboards.action.ActionUtil;
import com.liferay.portlet.messageboards.service.MBMessageLocalServiceUtil;
import com.liferay.portlet.messageboards.service.MBMessageServiceUtil;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class EditMessageAttachmentsAction
extends PortletAction {
    @Override
    public void processAction(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("delete")) {
                this.deleteAttachment(actionRequest);
            } else if (cmd.equals("empty_trash")) {
                this.emptyTrash(actionRequest);
            } else if (cmd.equals("move_from_trash")) {
                this.restoreAttachmentFromTrash(actionRequest);
            }
            if (Validator.isNotNull((String)cmd)) {
                String redirect = ParamUtil.getString((PortletRequest)actionRequest, (String)"redirect");
                this.sendRedirect(actionRequest, actionResponse, redirect);
            }
        }
        catch (Exception e2) {
            if (e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e2.getClass());
                this.setForward((PortletRequest)actionRequest, "portlet.message_boards.error");
            }
            throw e2;
        }
    }

    @Override
    public ActionForward render(ActionMapping actionMapping, ActionForm actionForm, PortletConfig portletConfig, RenderRequest renderRequest, RenderResponse renderResponse) throws Exception {
        try {
            ActionUtil.getMessage((PortletRequest)renderRequest);
        }
        catch (Exception e2) {
            if (e2 instanceof NoSuchMessageException || e2 instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e2.getClass());
                return actionMapping.findForward("portlet.message_boards.error");
            }
            throw e2;
        }
        return actionMapping.findForward(this.getForward((PortletRequest)renderRequest, "portlet.message_boards.view_deleted_message_attachments"));
    }

    protected void deleteAttachment(ActionRequest actionRequest) throws PortalException, SystemException {
        long messageId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"messageId");
        String fileName = ParamUtil.getString((PortletRequest)actionRequest, (String)"fileName");
        MBMessageLocalServiceUtil.deleteMessageAttachment((long)messageId, (String)fileName);
    }

    protected void emptyTrash(ActionRequest actionRequest) throws Exception {
        long messageId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"messageId");
        MBMessageServiceUtil.deleteMessageAttachments((long)messageId);
    }

    protected void restoreAttachmentFromTrash(ActionRequest actionRequest) throws PortalException, SystemException {
        long messageId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"messageId");
        String fileName = ParamUtil.getString((PortletRequest)actionRequest, (String)"fileName");
        MBMessageServiceUtil.restoreMessageAttachmentFromTrash((long)messageId, (String)fileName);
    }
}

