/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.portal.kernel.portlet.LiferayPortletConfig;
import com.liferay.portal.kernel.portlet.PortletBag;
import com.liferay.portal.kernel.portlet.PortletBagPool;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.PortletApp;
import com.liferay.portal.model.PublicRenderParameter;
import com.liferay.portlet.PortletResourceBundle;
import com.liferay.portlet.StrutsResourceBundle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.portlet.PortletContext;
import javax.xml.namespace.QName;

public class PortletConfigImpl
implements LiferayPortletConfig {
    private boolean _copyRequestParameters;
    private Portlet _portlet;
    private PortletApp _portletApp;
    private PortletContext _portletContext;
    private String _portletName;
    private Map<String, ResourceBundle> _resourceBundles;

    public PortletConfigImpl(Portlet portlet, PortletContext portletContext) {
        this._portletApp = portlet.getPortletApp();
        this._portlet = portlet;
        this._portletName = portlet.getRootPortletId();
        int pos = this._portletName.indexOf("_WAR_");
        if (pos != -1) {
            this._portletName = this._portletName.substring(0, pos);
        }
        this._portletContext = portletContext;
        this._resourceBundles = new ConcurrentHashMap<String, ResourceBundle>();
        this._copyRequestParameters = GetterUtil.getBoolean((String)this.getInitParameter("copy-request-parameters"));
    }

    public Map<String, String[]> getContainerRuntimeOptions() {
        return this._portletApp.getContainerRuntimeOptions();
    }

    public String getDefaultNamespace() {
        return this._portletApp.getDefaultNamespace();
    }

    public String getInitParameter(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        return (String)this._portlet.getInitParams().get(name);
    }

    public Enumeration<String> getInitParameterNames() {
        return Collections.enumeration(this._portlet.getInitParams().keySet());
    }

    public Portlet getPortlet() {
        return this._portlet;
    }

    public PortletContext getPortletContext() {
        return this._portletContext;
    }

    public String getPortletId() {
        return this._portlet.getPortletId();
    }

    public String getPortletName() {
        return this._portletName;
    }

    public Enumeration<QName> getProcessingEventQNames() {
        return Collections.enumeration(this.toJavaxQNames(this._portlet.getProcessingEvents()));
    }

    public Enumeration<String> getPublicRenderParameterNames() {
        ArrayList<String> publicRenderParameterNames = new ArrayList<String>();
        for (PublicRenderParameter publicRenderParameter : this._portlet.getPublicRenderParameters()) {
            publicRenderParameterNames.add(publicRenderParameter.getIdentifier());
        }
        return Collections.enumeration(publicRenderParameterNames);
    }

    public Enumeration<QName> getPublishingEventQNames() {
        return Collections.enumeration(this.toJavaxQNames(this._portlet.getPublishingEvents()));
    }

    public ResourceBundle getResourceBundle(Locale locale) {
        String resourceBundleClassName = this._portlet.getResourceBundle();
        ResourceBundle resourceBundle = null;
        if (Validator.isNull((String)resourceBundleClassName)) {
            String resourceBundleId = this._portlet.getPortletId();
            resourceBundle = this._resourceBundles.get(resourceBundleId);
            if (resourceBundle == null) {
                resourceBundle = new PortletResourceBundle(this._portlet.getPortletInfo());
                this._resourceBundles.put(resourceBundleId, resourceBundle);
            }
            return resourceBundle;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(this._portlet.getPortletId());
        sb.append(locale.getLanguage());
        sb.append(locale.getCountry());
        sb.append(locale.getVariant());
        String resourceBundleId = sb.toString();
        resourceBundle = this._resourceBundles.get(resourceBundleId);
        if (resourceBundle == null) {
            if (!this._portletApp.isWARFile() && resourceBundleClassName.equals(StrutsResourceBundle.class.getName())) {
                resourceBundle = new StrutsResourceBundle(this._portletName, locale);
            } else {
                PortletBag portletBag = PortletBagPool.get((String)this._portlet.getRootPortletId());
                resourceBundle = portletBag.getResourceBundle(locale);
            }
            resourceBundle = new PortletResourceBundle(resourceBundle, this._portlet.getPortletInfo());
            this._resourceBundles.put(resourceBundleId, resourceBundle);
        }
        return resourceBundle;
    }

    public Enumeration<Locale> getSupportedLocales() {
        ArrayList<Locale> supportedLocales = new ArrayList<Locale>();
        for (String languageId : this._portlet.getSupportedLocales()) {
            supportedLocales.add(LocaleUtil.fromLanguageId((String)languageId));
        }
        return Collections.enumeration(supportedLocales);
    }

    public boolean isCopyRequestParameters() {
        return this._copyRequestParameters;
    }

    public boolean isWARFile() {
        return this._portletApp.isWARFile();
    }

    protected Set<QName> toJavaxQNames(Set<com.liferay.portal.kernel.xml.QName> liferayQNames) {
        HashSet<QName> javaxQNames = new HashSet<QName>(liferayQNames.size());
        for (com.liferay.portal.kernel.xml.QName liferayQName : liferayQNames) {
            QName javaxQName = new QName(liferayQName.getNamespaceURI(), liferayQName.getLocalPart(), liferayQName.getNamespacePrefix());
            javaxQNames.add(javaxQName);
        }
        return javaxQNames;
    }
}

