/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.template;

import com.liferay.portal.kernel.security.pacl.NotPrivileged;
import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.template.TemplateManager;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.template.PrivilegedTemplateWrapper;
import com.liferay.portal.template.TemplateContextHelper;
import com.liferay.portal.template.TemplateControlContext;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;

public abstract class BaseTemplateManager
implements TemplateManager {
    protected TemplateContextHelper templateContextHelper;

    @NotPrivileged
    public Template getTemplate(TemplateResource templateResource, boolean restricted) {
        return this.getTemplate(templateResource, null, restricted);
    }

    @NotPrivileged
    public Template getTemplate(TemplateResource templateResource, TemplateResource errorTemplateResource, boolean restricted) {
        TemplateControlContext templateControlContext = this.templateContextHelper.getTemplateControlContext();
        AccessControlContext accessControlContext = templateControlContext.getAccessControlContext();
        ClassLoader classLoader = templateControlContext.getClassLoader();
        if (accessControlContext == null) {
            Map<String, Object> helperUtilities = this.templateContextHelper.getHelperUtilities(classLoader, restricted);
            return this.doGetTemplate(templateResource, errorTemplateResource, restricted, helperUtilities, false);
        }
        Map<String, Object> helperUtilities = AccessController.doPrivileged(new DoGetHelperUtilitiesPrivilegedAction(this.templateContextHelper, classLoader, restricted), accessControlContext);
        Template template = AccessController.doPrivileged(new DoGetTemplatePrivilegedAction(templateResource, errorTemplateResource, restricted, helperUtilities));
        return new PrivilegedTemplateWrapper(accessControlContext, template);
    }

    public void setTemplateContextHelper(TemplateContextHelper templateContextHelper) {
        this.templateContextHelper = templateContextHelper;
    }

    protected abstract Template doGetTemplate(TemplateResource var1, TemplateResource var2, boolean var3, Map<String, Object> var4, boolean var5);

    private class DoGetHelperUtilitiesPrivilegedAction
    implements PrivilegedAction<Map<String, Object>> {
        private ClassLoader _classLoader;
        private boolean _restricted;
        private TemplateContextHelper _templateContextHelper;

        public DoGetHelperUtilitiesPrivilegedAction(TemplateContextHelper templateContextHelper, ClassLoader classLoader, boolean restricted) {
            this._templateContextHelper = templateContextHelper;
            this._classLoader = classLoader;
            this._restricted = restricted;
        }

        @Override
        public Map<String, Object> run() {
            return this._templateContextHelper.getHelperUtilities(this._classLoader, this._restricted);
        }
    }

    private class DoGetTemplatePrivilegedAction
    implements PrivilegedAction<Template> {
        private TemplateResource _errorTemplateResource;
        private Map<String, Object> _helperUtilities;
        private boolean _restricted;
        private TemplateResource _templateResource;

        public DoGetTemplatePrivilegedAction(TemplateResource templateResource, TemplateResource errorTemplateResource, boolean restricted, Map<String, Object> helperUtilities) {
            this._templateResource = templateResource;
            this._errorTemplateResource = errorTemplateResource;
            this._restricted = restricted;
            this._helperUtilities = helperUtilities;
        }

        @Override
        public Template run() {
            return BaseTemplateManager.this.doGetTemplate(this._templateResource, this._errorTemplateResource, this._restricted, this._helperUtilities, true);
        }
    }
}

