/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.LayoutBranch;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.base.LayoutBranchServiceBaseImpl;
import com.liferay.portal.service.permission.GroupPermissionUtil;
import com.liferay.portal.service.permission.LayoutBranchPermissionUtil;

public class LayoutBranchServiceImpl
extends LayoutBranchServiceBaseImpl {
    public LayoutBranch addLayoutBranch(long layoutRevisionId, String name, String description, boolean master, ServiceContext serviceContext) throws PortalException, SystemException {
        long groupId = serviceContext.getScopeGroupId();
        GroupPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"ADD_LAYOUT_BRANCH");
        return this.layoutBranchLocalService.addLayoutBranch(layoutRevisionId, name, description, false, serviceContext);
    }

    public void deleteLayoutBranch(long layoutBranchId) throws PortalException, SystemException {
        LayoutBranchPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)layoutBranchId, (String)"DELETE");
        this.layoutBranchLocalService.deleteLayoutBranch(layoutBranchId);
    }

    public LayoutBranch updateLayoutBranch(long layoutBranchId, String name, String description, ServiceContext serviceContext) throws PortalException, SystemException {
        LayoutBranchPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)layoutBranchId, (String)"UPDATE");
        return this.layoutBranchLocalService.updateLayoutBranch(layoutBranchId, name, description, serviceContext);
    }
}

