/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search;

import com.liferay.portal.kernel.lar.ExportImportThreadLocal;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.spring.aop.AnnotationChainableMethodAdvice;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInvocation;

public class IndexableAdvice
extends AnnotationChainableMethodAdvice<Indexable> {
    private static Log _log = LogFactoryUtil.getLog(IndexableAdvice.class);
    private static Indexable _nullIndexable = new Indexable(){

        public Class<? extends Annotation> annotationType() {
            return Indexable.class;
        }

        public IndexableType type() {
            return null;
        }
    };

    @Override
    public void afterReturning(MethodInvocation methodInvocation, Object result) throws Throwable {
        if (result == null) {
            return;
        }
        Indexable indexable = (Indexable)this.findAnnotation(methodInvocation);
        if (indexable == _nullIndexable) {
            return;
        }
        Method method = methodInvocation.getMethod();
        Class<?> returnType = method.getReturnType();
        if (!BaseModel.class.isAssignableFrom(returnType)) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)(methodInvocation + " does not have a valid return type"));
            }
            return;
        }
        if (StagedModel.class.isAssignableFrom(returnType) && ExportImportThreadLocal.isImportInProcess()) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Skipping indexing until the import is finished");
            }
            return;
        }
        Indexer indexer = IndexerRegistryUtil.getIndexer((String)returnType.getName());
        if (indexer == null) {
            this.serviceBeanAopCacheManager.removeMethodInterceptor(methodInvocation, this);
            return;
        }
        Object[] arguments = methodInvocation.getArguments();
        int i2 = arguments.length - 1;
        while (i2 >= 0) {
            if (arguments[i2] instanceof ServiceContext) {
                ServiceContext serviceContext = (ServiceContext)arguments[i2];
                if (serviceContext.isIndexingEnabled()) break;
                return;
            }
            --i2;
        }
        if (indexable.type() == IndexableType.DELETE) {
            indexer.delete(result);
        } else {
            indexer.reindex(result);
        }
    }

    @Override
    public Indexable getNullAnnotation() {
        return _nullIndexable;
    }
}

