/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.service.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.staging.permission.StagingPermissionUtil;
import com.liferay.portal.kernel.workflow.permission.WorkflowPermissionUtil;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.messageboards.NoSuchCategoryException;
import com.liferay.portlet.messageboards.model.MBCategory;
import com.liferay.portlet.messageboards.model.MBMessage;
import com.liferay.portlet.messageboards.service.MBBanLocalServiceUtil;
import com.liferay.portlet.messageboards.service.MBCategoryLocalServiceUtil;
import com.liferay.portlet.messageboards.service.MBMessageLocalServiceUtil;
import com.liferay.portlet.messageboards.service.permission.MBCategoryPermission;
import com.liferay.portlet.messageboards.service.permission.MBPermission;

public class MBMessagePermission {
    public static void check(PermissionChecker permissionChecker, long messageId, String actionId) throws PortalException, SystemException {
        if (!MBMessagePermission.contains(permissionChecker, messageId, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, MBMessage message, String actionId) throws PortalException, SystemException {
        if (!MBMessagePermission.contains(permissionChecker, message, actionId)) {
            throw new PrincipalException();
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, long messageId, String actionId) throws PortalException, SystemException {
        MBMessage message = MBMessageLocalServiceUtil.getMessage((long)messageId);
        return MBMessagePermission.contains(permissionChecker, message, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, MBMessage message, String actionId) throws PortalException, SystemException {
        block14: {
            if (MBBanLocalServiceUtil.hasBan((long)message.getGroupId(), (long)permissionChecker.getUserId())) {
                return false;
            }
            Boolean hasPermission = StagingPermissionUtil.hasPermission((PermissionChecker)permissionChecker, (long)message.getGroupId(), (String)MBMessage.class.getName(), (long)message.getMessageId(), (String)"19", (String)actionId);
            if (hasPermission != null) {
                return hasPermission;
            }
            if (message.isDraft() || message.isScheduled()) {
                if (actionId.equals("VIEW") && !MBMessagePermission.contains(permissionChecker, message, "UPDATE")) {
                    return false;
                }
            } else if (message.isPending() && (hasPermission = WorkflowPermissionUtil.hasPermission((PermissionChecker)permissionChecker, (long)message.getGroupId(), (String)message.getWorkflowClassName(), (long)message.getMessageId(), (String)actionId)) != null) {
                return hasPermission;
            }
            if (actionId.equals("VIEW") && PropsValues.PERMISSIONS_VIEW_DYNAMIC_INHERITANCE) {
                long categoryId = message.getCategoryId();
                if (categoryId == 0L || categoryId == -1L) {
                    if (!MBPermission.contains(permissionChecker, message.getGroupId(), actionId)) {
                        return false;
                    }
                } else {
                    try {
                        MBCategory category = MBCategoryLocalServiceUtil.getCategory((long)categoryId);
                        if (!MBCategoryPermission.contains(permissionChecker, category, actionId)) {
                            return false;
                        }
                    }
                    catch (NoSuchCategoryException nsce) {
                        if (message.isInTrash()) break block14;
                        throw nsce;
                    }
                }
            }
        }
        if (permissionChecker.hasOwnerPermission(message.getCompanyId(), MBMessage.class.getName(), message.getRootMessageId(), message.getUserId(), actionId)) {
            return true;
        }
        return permissionChecker.hasPermission(message.getGroupId(), MBMessage.class.getName(), message.getMessageId(), actionId);
    }
}

