/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.NoSuchWorkflowDefinitionLinkException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.spring.aop.Skip;
import com.liferay.portal.kernel.staging.StagingUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowEngineManagerUtil;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.User;
import com.liferay.portal.model.WorkflowDefinitionLink;
import com.liferay.portal.service.base.WorkflowDefinitionLinkLocalServiceBaseImpl;
import com.liferay.portal.util.PortalUtil;
import java.util.Date;
import java.util.List;

public class WorkflowDefinitionLinkLocalServiceImpl
extends WorkflowDefinitionLinkLocalServiceBaseImpl {
    public WorkflowDefinitionLink addWorkflowDefinitionLink(long userId, long companyId, long groupId, String className, long classPK, long typePK, String workflowDefinitionName, int workflowDefinitionVersion) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        groupId = StagingUtil.getLiveGroupId((long)groupId);
        long classNameId = PortalUtil.getClassNameId((String)className);
        Date now = new Date();
        long workflowDefinitionLinkId = this.counterLocalService.increment();
        WorkflowDefinitionLink workflowDefinitionLink = this.workflowDefinitionLinkPersistence.create(workflowDefinitionLinkId);
        workflowDefinitionLink.setCreateDate(now);
        workflowDefinitionLink.setModifiedDate(now);
        workflowDefinitionLink.setUserId(userId);
        workflowDefinitionLink.setUserName(user.getFullName());
        workflowDefinitionLink.setGroupId(groupId);
        workflowDefinitionLink.setCompanyId(companyId);
        workflowDefinitionLink.setClassNameId(classNameId);
        workflowDefinitionLink.setClassPK(classPK);
        workflowDefinitionLink.setTypePK(typePK);
        workflowDefinitionLink.setWorkflowDefinitionName(workflowDefinitionName);
        workflowDefinitionLink.setWorkflowDefinitionVersion(workflowDefinitionVersion);
        this.workflowDefinitionLinkPersistence.update((BaseModel)workflowDefinitionLink);
        return workflowDefinitionLink;
    }

    public void deleteWorkflowDefinitionLink(long companyId, long groupId, String className, long classPK, long typePK) throws PortalException, SystemException {
        WorkflowDefinitionLink workflowDefinitionLink = this.fetchWorkflowDefinitionLink(companyId, groupId, className, classPK, typePK, true);
        if (workflowDefinitionLink != null) {
            this.deleteWorkflowDefinitionLink(workflowDefinitionLink);
        }
    }

    public WorkflowDefinitionLink fetchDefaultWorkflowDefinitionLink(long companyId, String className, long classPK, long typePK) throws SystemException {
        if (!WorkflowEngineManagerUtil.isDeployed()) {
            return null;
        }
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.workflowDefinitionLinkPersistence.fetchByG_C_C_C_T(0L, companyId, classNameId, classPK, typePK);
    }

    public WorkflowDefinitionLink fetchWorkflowDefinitionLink(long companyId, long groupId, String className, long classPK, long typePK) throws PortalException, SystemException {
        return this.fetchWorkflowDefinitionLink(companyId, groupId, className, classPK, typePK, false);
    }

    public WorkflowDefinitionLink fetchWorkflowDefinitionLink(long companyId, long groupId, String className, long classPK, long typePK, boolean strict) throws PortalException, SystemException {
        if (!WorkflowEngineManagerUtil.isDeployed()) {
            return null;
        }
        groupId = StagingUtil.getLiveGroupId((long)groupId);
        long classNameId = PortalUtil.getClassNameId((String)className);
        WorkflowDefinitionLink workflowDefinitionLink = null;
        workflowDefinitionLink = this.workflowDefinitionLinkPersistence.fetchByG_C_C_C_T(groupId, companyId, classNameId, classPK, typePK);
        if (!strict && workflowDefinitionLink == null) {
            workflowDefinitionLink = this.workflowDefinitionLinkPersistence.fetchByG_C_C_C_T(0L, companyId, classNameId, classPK, typePK);
        }
        return workflowDefinitionLink;
    }

    public WorkflowDefinitionLink getDefaultWorkflowDefinitionLink(long companyId, String className, long classPK, long typePK) throws PortalException, SystemException {
        if (!WorkflowEngineManagerUtil.isDeployed()) {
            throw new NoSuchWorkflowDefinitionLinkException();
        }
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.workflowDefinitionLinkPersistence.findByG_C_C_C_T(0L, companyId, classNameId, classPK, typePK);
    }

    public WorkflowDefinitionLink getWorkflowDefinitionLink(long companyId, long groupId, String className, long classPK, long typePK) throws PortalException, SystemException {
        return this.getWorkflowDefinitionLink(companyId, groupId, className, classPK, typePK, false);
    }

    public WorkflowDefinitionLink getWorkflowDefinitionLink(long companyId, long groupId, String className, long classPK, long typePK, boolean strict) throws PortalException, SystemException {
        if (!WorkflowEngineManagerUtil.isDeployed()) {
            throw new NoSuchWorkflowDefinitionLinkException();
        }
        WorkflowDefinitionLink workflowDefinitionLink = this.fetchWorkflowDefinitionLink(companyId, groupId, className, classPK, typePK, strict);
        if (workflowDefinitionLink == null) {
            throw new NoSuchWorkflowDefinitionLinkException("No workflow for groupId=" + groupId + ", companyId=" + companyId + " and className=" + className);
        }
        return workflowDefinitionLink;
    }

    public int getWorkflowDefinitionLinksCount(long companyId, String workflowDefinitionName, int workflowDefinitionVersion) throws SystemException {
        if (!WorkflowEngineManagerUtil.isDeployed()) {
            return 0;
        }
        return this.workflowDefinitionLinkPersistence.countByC_W_W(companyId, workflowDefinitionName, workflowDefinitionVersion);
    }

    @Skip
    public boolean hasWorkflowDefinitionLink(long companyId, long groupId, String className) throws PortalException, SystemException {
        return this.hasWorkflowDefinitionLink(companyId, groupId, className, 0L);
    }

    @Skip
    public boolean hasWorkflowDefinitionLink(long companyId, long groupId, String className, long classPK) throws PortalException, SystemException {
        return this.hasWorkflowDefinitionLink(companyId, groupId, className, classPK, 0L);
    }

    @Skip
    public boolean hasWorkflowDefinitionLink(long companyId, long groupId, String className, long classPK, long typePK) throws PortalException, SystemException {
        if (!WorkflowEngineManagerUtil.isDeployed()) {
            return false;
        }
        WorkflowDefinitionLink workflowDefinitionLink = this.workflowDefinitionLinkLocalService.fetchWorkflowDefinitionLink(companyId, groupId, className, classPK, typePK);
        return workflowDefinitionLink != null;
    }

    public void updateWorkflowDefinitionLink(long userId, long companyId, long groupId, String className, long classPK, long typePK, String workflowDefinition) throws PortalException, SystemException {
        if (Validator.isNull((String)workflowDefinition)) {
            this.deleteWorkflowDefinitionLink(companyId, groupId, className, classPK, typePK);
        } else {
            String[] workflowDefinitionParts = StringUtil.split((String)workflowDefinition, (char)'@');
            String workflowDefinitionName = workflowDefinitionParts[0];
            int workflowDefinitionVersion = GetterUtil.getInteger((String)workflowDefinitionParts[1]);
            this.updateWorkflowDefinitionLink(userId, companyId, groupId, className, classPK, typePK, workflowDefinitionName, workflowDefinitionVersion);
        }
    }

    public WorkflowDefinitionLink updateWorkflowDefinitionLink(long userId, long companyId, long groupId, String className, long classPK, long typePK, String workflowDefinitionName, int workflowDefinitionVersion) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        groupId = StagingUtil.getLiveGroupId((long)groupId);
        long classNameId = PortalUtil.getClassNameId((String)className);
        Date now = new Date();
        WorkflowDefinitionLink workflowDefinitionLink = this.workflowDefinitionLinkPersistence.fetchByG_C_C_C_T(groupId, companyId, classNameId, classPK, typePK);
        if (workflowDefinitionLink == null) {
            workflowDefinitionLink = this.addWorkflowDefinitionLink(userId, companyId, groupId, className, classPK, typePK, workflowDefinitionName, workflowDefinitionVersion);
        }
        workflowDefinitionLink.setModifiedDate(now);
        workflowDefinitionLink.setUserId(userId);
        workflowDefinitionLink.setUserName(user.getFullName());
        workflowDefinitionLink.setGroupId(groupId);
        workflowDefinitionLink.setCompanyId(companyId);
        workflowDefinitionLink.setClassNameId(classNameId);
        workflowDefinitionLink.setClassPK(classPK);
        workflowDefinitionLink.setTypePK(typePK);
        workflowDefinitionLink.setWorkflowDefinitionName(workflowDefinitionName);
        workflowDefinitionLink.setWorkflowDefinitionVersion(workflowDefinitionVersion);
        this.workflowDefinitionLinkPersistence.update((BaseModel)workflowDefinitionLink);
        return workflowDefinitionLink;
    }

    public void updateWorkflowDefinitionLinks(long userId, long companyId, long groupId, String className, long classPK, List<ObjectValuePair<Long, String>> workflowDefinitionOVPs) throws PortalException, SystemException {
        for (ObjectValuePair<Long, String> workflowDefinitionOVP : workflowDefinitionOVPs) {
            long typePK = (Long)workflowDefinitionOVP.getKey();
            String workflowDefinitionName = (String)workflowDefinitionOVP.getValue();
            if (Validator.isNull((String)workflowDefinitionName)) {
                this.deleteWorkflowDefinitionLink(companyId, groupId, className, classPK, typePK);
                continue;
            }
            this.updateWorkflowDefinitionLink(userId, companyId, groupId, className, classPK, typePK, workflowDefinitionName);
        }
    }
}

