/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.pwd;

import com.liferay.portal.UserPasswordException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.model.PasswordPolicy;
import com.liferay.portal.security.ldap.LDAPSettingsUtil;
import com.liferay.portal.security.pwd.PwdToolkitUtilThreadLocal;
import com.liferay.portal.security.pwd.Toolkit;

public class PwdToolkitUtil {
    private static Toolkit _toolkit;

    public static String generate(PasswordPolicy passwordPolicy) {
        return _toolkit.generate(passwordPolicy);
    }

    public static Toolkit getToolkit() {
        return _toolkit;
    }

    public static void validate(long companyId, long userId, String password1, String password2, PasswordPolicy passwordPolicy) throws PortalException, SystemException {
        if (!password1.equals(password2)) {
            throw new UserPasswordException(10);
        }
        if (!LDAPSettingsUtil.isPasswordPolicyEnabled(companyId) && PwdToolkitUtilThreadLocal.isValidate()) {
            _toolkit.validate(userId, password1, password2, passwordPolicy);
        }
    }

    public void setToolkit(Toolkit toolkit) {
        _toolkit = toolkit;
    }
}

