/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.webservices;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.xml.ws.Holder;
import org.apache.chemistry.opencmis.client.bindings.spi.BindingSession;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.AbstractPortProvider;
import org.apache.chemistry.opencmis.client.bindings.spi.webservices.AbstractWebServicesService;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.AllowableActions;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.FailedToDeleteData;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.RenditionData;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.enums.UnfileObject;
import org.apache.chemistry.opencmis.commons.enums.VersioningState;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.Converter;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisAllowableActionsType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisContentStreamType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisException;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisObjectType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisPropertiesType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.CmisRenditionType;
import org.apache.chemistry.opencmis.commons.impl.jaxb.DeleteTreeResponse;
import org.apache.chemistry.opencmis.commons.impl.jaxb.EnumIncludeRelationships;
import org.apache.chemistry.opencmis.commons.impl.jaxb.EnumUnfileObject;
import org.apache.chemistry.opencmis.commons.impl.jaxb.EnumVersioningState;
import org.apache.chemistry.opencmis.commons.impl.jaxb.ObjectServicePort;
import org.apache.chemistry.opencmis.commons.spi.ObjectService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectServiceImpl
extends AbstractWebServicesService
implements ObjectService {
    private final AbstractPortProvider portProvider;

    public ObjectServiceImpl(BindingSession session, AbstractPortProvider portProvider) {
        this.setSession(session);
        this.portProvider = portProvider;
    }

    public String createDocument(String repositoryId, Properties properties, String folderId, ContentStream contentStream, VersioningState versioningState, List<String> policies, Acl addACEs, Acl removeACEs, ExtensionsData extension) {
        ObjectServicePort port = this.portProvider.getObjectServicePort();
        try {
            Holder objectId = new Holder();
            Holder portExtension = Converter.convertExtensionHolder((ExtensionsData)extension);
            port.createDocument(repositoryId, Converter.convert((Properties)properties), folderId, Converter.convert((ContentStream)contentStream), (EnumVersioningState)Converter.convert(EnumVersioningState.class, (Enum)versioningState), policies, Converter.convert((Acl)addACEs), Converter.convert((Acl)removeACEs), portExtension, objectId);
            Converter.setExtensionValues((Holder)portExtension, (ExtensionsData)extension);
            String string = (String)objectId.value;
            return string;
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    public String createDocumentFromSource(String repositoryId, String sourceId, Properties properties, String folderId, VersioningState versioningState, List<String> policies, Acl addACEs, Acl removeACEs, ExtensionsData extension) {
        ObjectServicePort port = this.portProvider.getObjectServicePort();
        try {
            Holder objectId = new Holder();
            Holder portExtension = Converter.convertExtensionHolder((ExtensionsData)extension);
            port.createDocumentFromSource(repositoryId, sourceId, Converter.convert((Properties)properties), folderId, (EnumVersioningState)Converter.convert(EnumVersioningState.class, (Enum)versioningState), policies, Converter.convert((Acl)addACEs), Converter.convert((Acl)removeACEs), portExtension, objectId);
            Converter.setExtensionValues((Holder)portExtension, (ExtensionsData)extension);
            String string = (String)objectId.value;
            return string;
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    public String createFolder(String repositoryId, Properties properties, String folderId, List<String> policies, Acl addACEs, Acl removeACEs, ExtensionsData extension) {
        ObjectServicePort port = this.portProvider.getObjectServicePort();
        try {
            Holder objectId = new Holder();
            Holder portExtension = Converter.convertExtensionHolder((ExtensionsData)extension);
            port.createFolder(repositoryId, Converter.convert((Properties)properties), folderId, policies, Converter.convert((Acl)addACEs), Converter.convert((Acl)removeACEs), portExtension, objectId);
            Converter.setExtensionValues((Holder)portExtension, (ExtensionsData)extension);
            String string = (String)objectId.value;
            return string;
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    public String createPolicy(String repositoryId, Properties properties, String folderId, List<String> policies, Acl addACEs, Acl removeACEs, ExtensionsData extension) {
        ObjectServicePort port = this.portProvider.getObjectServicePort();
        try {
            Holder objectId = new Holder();
            Holder portExtension = Converter.convertExtensionHolder((ExtensionsData)extension);
            port.createPolicy(repositoryId, Converter.convert((Properties)properties), folderId, policies, Converter.convert((Acl)addACEs), Converter.convert((Acl)removeACEs), portExtension, objectId);
            Converter.setExtensionValues((Holder)portExtension, (ExtensionsData)extension);
            String string = (String)objectId.value;
            return string;
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    public String createRelationship(String repositoryId, Properties properties, List<String> policies, Acl addACEs, Acl removeACEs, ExtensionsData extension) {
        ObjectServicePort port = this.portProvider.getObjectServicePort();
        try {
            Holder objectId = new Holder();
            Holder portExtension = Converter.convertExtensionHolder((ExtensionsData)extension);
            port.createRelationship(repositoryId, Converter.convert((Properties)properties), policies, Converter.convert((Acl)addACEs), Converter.convert((Acl)removeACEs), portExtension, objectId);
            Converter.setExtensionValues((Holder)portExtension, (ExtensionsData)extension);
            String string = (String)objectId.value;
            return string;
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    public void updateProperties(String repositoryId, org.apache.chemistry.opencmis.commons.spi.Holder<String> objectId, org.apache.chemistry.opencmis.commons.spi.Holder<String> changeToken, Properties properties, ExtensionsData extension) {
        ObjectServicePort port = this.portProvider.getObjectServicePort();
        try {
            Holder portObjectId = Converter.convertHolder(objectId);
            Holder portChangeToken = Converter.convertHolder(changeToken);
            Holder portExtension = Converter.convertExtensionHolder((ExtensionsData)extension);
            port.updateProperties(repositoryId, portObjectId, portChangeToken, Converter.convert((Properties)properties), portExtension);
            Converter.setHolderValue((Holder)portObjectId, objectId);
            Converter.setHolderValue((Holder)portChangeToken, changeToken);
            Converter.setExtensionValues((Holder)portExtension, (ExtensionsData)extension);
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    public void deleteObject(String repositoryId, String objectId, Boolean allVersions, ExtensionsData extension) {
        ObjectServicePort port = this.portProvider.getObjectServicePort();
        try {
            Holder portExtension = Converter.convertExtensionHolder((ExtensionsData)extension);
            port.deleteObject(repositoryId, objectId, allVersions, portExtension);
            Converter.setExtensionValues((Holder)portExtension, (ExtensionsData)extension);
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    public FailedToDeleteData deleteTree(String repositoryId, String folderId, Boolean allVersions, UnfileObject unfileObjects, Boolean continueOnFailure, ExtensionsData extension) {
        ObjectServicePort port = this.portProvider.getObjectServicePort();
        try {
            FailedToDeleteData failedToDeleteData = Converter.convert((DeleteTreeResponse.FailedToDelete)port.deleteTree(repositoryId, folderId, allVersions, (EnumUnfileObject)Converter.convert(EnumUnfileObject.class, (Enum)unfileObjects), continueOnFailure, Converter.convert((ExtensionsData)extension)));
            return failedToDeleteData;
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    public AllowableActions getAllowableActions(String repositoryId, String objectId, ExtensionsData extension) {
        ObjectServicePort port = this.portProvider.getObjectServicePort();
        try {
            AllowableActions allowableActions = Converter.convert((CmisAllowableActionsType)port.getAllowableActions(repositoryId, objectId, Converter.convert((ExtensionsData)extension)));
            return allowableActions;
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    public ContentStream getContentStream(String repositoryId, String objectId, String streamId, BigInteger offset, BigInteger length, ExtensionsData extension) {
        ObjectServicePort port = this.portProvider.getObjectServicePort();
        try {
            ContentStream contentStream = Converter.convert((CmisContentStreamType)port.getContentStream(repositoryId, objectId, streamId, offset, length, Converter.convert((ExtensionsData)extension)));
            return contentStream;
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    public ObjectData getObject(String repositoryId, String objectId, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeACL, ExtensionsData extension) {
        ObjectServicePort port = this.portProvider.getObjectServicePort();
        try {
            ObjectData objectData = Converter.convert((CmisObjectType)port.getObject(repositoryId, objectId, filter, includeAllowableActions, (EnumIncludeRelationships)Converter.convert(EnumIncludeRelationships.class, (Enum)includeRelationships), renditionFilter, includePolicyIds, includeACL, Converter.convert((ExtensionsData)extension)));
            return objectData;
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    public ObjectData getObjectByPath(String repositoryId, String path, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeACL, ExtensionsData extension) {
        ObjectServicePort port = this.portProvider.getObjectServicePort();
        try {
            ObjectData objectData = Converter.convert((CmisObjectType)port.getObjectByPath(repositoryId, path, filter, includeAllowableActions, (EnumIncludeRelationships)Converter.convert(EnumIncludeRelationships.class, (Enum)includeRelationships), renditionFilter, includePolicyIds, includeACL, Converter.convert((ExtensionsData)extension)));
            return objectData;
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    public Properties getProperties(String repositoryId, String objectId, String filter, ExtensionsData extension) {
        ObjectServicePort port = this.portProvider.getObjectServicePort();
        try {
            Properties properties = Converter.convert((CmisPropertiesType)port.getProperties(repositoryId, objectId, filter, Converter.convert((ExtensionsData)extension)));
            return properties;
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    public List<RenditionData> getRenditions(String repositoryId, String objectId, String renditionFilter, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        ObjectServicePort port = this.portProvider.getObjectServicePort();
        try {
            List renditionList = port.getRenditions(repositoryId, objectId, renditionFilter, maxItems, skipCount, Converter.convert((ExtensionsData)extension));
            if (renditionList == null) {
                List<RenditionData> list = null;
                return list;
            }
            ArrayList<RenditionData> result = new ArrayList<RenditionData>();
            for (CmisRenditionType rendition : renditionList) {
                result.add(Converter.convert((CmisRenditionType)rendition));
            }
            ArrayList<RenditionData> arrayList = result;
            return arrayList;
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    public void moveObject(String repositoryId, org.apache.chemistry.opencmis.commons.spi.Holder<String> objectId, String targetFolderId, String sourceFolderId, ExtensionsData extension) {
        ObjectServicePort port = this.portProvider.getObjectServicePort();
        try {
            Holder portObjectId = Converter.convertHolder(objectId);
            Holder portExtension = Converter.convertExtensionHolder((ExtensionsData)extension);
            port.moveObject(repositoryId, portObjectId, targetFolderId, sourceFolderId, portExtension);
            Converter.setHolderValue((Holder)portObjectId, objectId);
            Converter.setExtensionValues((Holder)portExtension, (ExtensionsData)extension);
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    public void setContentStream(String repositoryId, org.apache.chemistry.opencmis.commons.spi.Holder<String> objectId, Boolean overwriteFlag, org.apache.chemistry.opencmis.commons.spi.Holder<String> changeToken, ContentStream contentStream, ExtensionsData extension) {
        ObjectServicePort port = this.portProvider.getObjectServicePort();
        try {
            Holder portObjectId = Converter.convertHolder(objectId);
            Holder portChangeToken = Converter.convertHolder(changeToken);
            Holder portExtension = Converter.convertExtensionHolder((ExtensionsData)extension);
            port.setContentStream(repositoryId, portObjectId, overwriteFlag, portChangeToken, Converter.convert((ContentStream)contentStream), portExtension);
            Converter.setHolderValue((Holder)portObjectId, objectId);
            Converter.setHolderValue((Holder)portChangeToken, changeToken);
            Converter.setExtensionValues((Holder)portExtension, (ExtensionsData)extension);
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }

    public void deleteContentStream(String repositoryId, org.apache.chemistry.opencmis.commons.spi.Holder<String> objectId, org.apache.chemistry.opencmis.commons.spi.Holder<String> changeToken, ExtensionsData extension) {
        ObjectServicePort port = this.portProvider.getObjectServicePort();
        try {
            Holder portObjectId = Converter.convertHolder(objectId);
            Holder portChangeToken = Converter.convertHolder(changeToken);
            Holder portExtension = Converter.convertExtensionHolder((ExtensionsData)extension);
            port.deleteContentStream(repositoryId, portObjectId, portChangeToken, portExtension);
            Converter.setHolderValue((Holder)portObjectId, objectId);
            Converter.setHolderValue((Holder)portChangeToken, changeToken);
            Converter.setExtensionValues((Holder)portExtension, (ExtensionsData)extension);
        }
        catch (CmisException e) {
            throw this.convertException(e);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error: " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.portProvider.endCall(port);
        }
    }
}

