/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir.operands;

import java.util.List;
import java.util.Map;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.compiler.ir.operands.Operand;
import org.jruby.compiler.ir.operands.Variable;
import org.jruby.compiler.ir.representations.InlinerInfo;
import org.jruby.interpreter.InterpreterContext;
import org.jruby.util.RegexpOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Regexp
extends Operand {
    public final RegexpOptions options;
    Operand regexp;

    public Regexp(Operand regexp2, RegexpOptions options2) {
        this.regexp = regexp2;
        this.options = options2;
    }

    @Override
    public boolean isConstant() {
        return this.regexp.isConstant();
    }

    public String toString() {
        return "RE:|" + this.regexp + "|" + this.options;
    }

    @Override
    public boolean isNonAtomicValue() {
        return true;
    }

    @Override
    public Operand getSimplifiedOperand(Map<Operand, Operand> valueMap) {
        this.regexp = this.regexp.getSimplifiedOperand(valueMap);
        return this;
    }

    @Override
    public void addUsedVariables(List<Variable> l) {
        this.regexp.addUsedVariables(l);
    }

    @Override
    public Operand cloneForInlining(InlinerInfo ii) {
        return this.isConstant() ? this : new Regexp(this.regexp.cloneForInlining(ii), this.options);
    }

    @Override
    public Object retrieve(InterpreterContext interp) {
        RubyRegexp reg = RubyRegexp.newRegexp(interp.getRuntime(), ((RubyString)this.regexp.retrieve(interp)).getByteList(), this.options);
        reg.setLiteral();
        return reg;
    }
}

