/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.persistence.mem;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.jackrabbit.core.fs.FileSystem;
import org.apache.jackrabbit.core.fs.FileSystemPathUtil;
import org.apache.jackrabbit.core.fs.FileSystemResource;
import org.apache.jackrabbit.core.fs.local.LocalFileSystem;
import org.apache.jackrabbit.core.fs.mem.MemoryFileSystem;
import org.apache.jackrabbit.core.id.ItemId;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.id.PropertyId;
import org.apache.jackrabbit.core.persistence.AbstractPersistenceManager;
import org.apache.jackrabbit.core.persistence.PMContext;
import org.apache.jackrabbit.core.persistence.util.BLOBStore;
import org.apache.jackrabbit.core.persistence.util.FileSystemBLOBStore;
import org.apache.jackrabbit.core.persistence.util.Serializer;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.NoSuchItemStateException;
import org.apache.jackrabbit.core.state.NodeReferences;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.spi.Name;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemPersistenceManager
extends AbstractPersistenceManager {
    private static Logger log = LoggerFactory.getLogger(InMemPersistenceManager.class);
    protected boolean initialized = false;
    protected Map<ItemId, byte[]> stateStore;
    protected Map<NodeId, byte[]> refsStore;
    protected static final int INITIAL_BUFFER_SIZE = 1024;
    protected static final String STATE_FILE_PATH = "/data/.state.bin";
    protected static final String REFS_FILE_PATH = "/data/.refs.bin";
    protected static final byte NODE_ENTRY = 0;
    protected static final byte PROP_ENTRY = 1;
    protected FileSystem blobFS;
    protected BLOBStore blobStore;
    protected FileSystem wspFS;
    protected int initialCapacity = 32768;
    protected float loadFactor = 0.75f;
    protected boolean persistent = true;

    public void setInitialCapacity(int initialCapacity) {
        this.initialCapacity = initialCapacity;
    }

    public void setInitialCapacity(String initialCapacity) {
        this.initialCapacity = Integer.parseInt(initialCapacity);
    }

    public String getInitialCapacity() {
        return Integer.toString(this.initialCapacity);
    }

    public void setLoadFactor(float loadFactor) {
        this.loadFactor = loadFactor;
    }

    public void setLoadFactor(String loadFactor) {
        this.loadFactor = Float.parseFloat(loadFactor);
    }

    public String getLoadFactor() {
        return Float.toString(this.loadFactor);
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    public void setPersistent(String persistent) {
        this.persistent = Boolean.valueOf(persistent);
    }

    protected static String buildBlobFilePath(String parentUUID, Name propName, int index) {
        StringBuffer sb = new StringBuffer();
        char[] chars = parentUUID.toCharArray();
        int cnt = 0;
        for (char ch : chars) {
            if (ch == '-') continue;
            if (cnt == 2 || cnt == 4) {
                sb.append('/');
            }
            sb.append(ch);
            ++cnt;
        }
        sb.append('/');
        sb.append(FileSystemPathUtil.escapeName(propName.toString()));
        sb.append('.');
        sb.append(index);
        sb.append(".bin");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void loadContents() throws Exception {
        byte[] data;
        int length;
        ItemId id;
        int n;
        FileSystemResource fsRes = new FileSystemResource(this.wspFS, STATE_FILE_PATH);
        if (!fsRes.exists()) {
            return;
        }
        BufferedInputStream bis = new BufferedInputStream(fsRes.getInputStream());
        DataInputStream in = new DataInputStream(bis);
        try {
            n = in.readInt();
            while (n-- > 0) {
                String s;
                byte type = in.readByte();
                if (type == 0) {
                    s = in.readUTF();
                    id = NodeId.valueOf(s);
                } else {
                    s = in.readUTF();
                    id = PropertyId.valueOf(s);
                }
                length = in.readInt();
                data = new byte[length];
                in.readFully(data);
                this.stateStore.put(id, data);
            }
        }
        finally {
            in.close();
        }
        fsRes = new FileSystemResource(this.wspFS, REFS_FILE_PATH);
        bis = new BufferedInputStream(fsRes.getInputStream());
        in = new DataInputStream(bis);
        try {
            n = in.readInt();
            while (n-- > 0) {
                String s = in.readUTF();
                id = NodeId.valueOf(s);
                length = in.readInt();
                data = new byte[length];
                in.readFully(data);
                this.refsStore.put((NodeId)id, data);
            }
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void storeContents() throws Exception {
        byte[] data;
        FileSystemResource fsRes = new FileSystemResource(this.wspFS, STATE_FILE_PATH);
        fsRes.makeParentDirs();
        BufferedOutputStream bos = new BufferedOutputStream(fsRes.getOutputStream());
        DataOutputStream out = new DataOutputStream(bos);
        try {
            out.writeInt(this.stateStore.size());
            for (ItemId itemId : this.stateStore.keySet()) {
                if (itemId.denotesNode()) {
                    out.writeByte(0);
                } else {
                    out.writeByte(1);
                }
                out.writeUTF(itemId.toString());
                data = this.stateStore.get(itemId);
                out.writeInt(data.length);
                out.write(data);
            }
        }
        finally {
            out.close();
        }
        fsRes = new FileSystemResource(this.wspFS, REFS_FILE_PATH);
        fsRes.makeParentDirs();
        bos = new BufferedOutputStream(fsRes.getOutputStream());
        out = new DataOutputStream(bos);
        try {
            out.writeInt(this.refsStore.size());
            for (NodeId nodeId : this.refsStore.keySet()) {
                out.writeUTF(nodeId.toString());
                data = this.refsStore.get(nodeId);
                out.writeInt(data.length);
                out.write(data);
            }
        }
        finally {
            out.close();
        }
    }

    public void init(PMContext context) throws Exception {
        if (this.initialized) {
            throw new IllegalStateException("already initialized");
        }
        this.stateStore = new HashMap<ItemId, byte[]>(this.initialCapacity, this.loadFactor);
        this.refsStore = new HashMap<NodeId, byte[]>(this.initialCapacity, this.loadFactor);
        this.wspFS = context.getFileSystem();
        if (this.persistent) {
            this.blobFS = new LocalFileSystem();
            ((LocalFileSystem)this.blobFS).setRoot(new File(context.getHomeDir(), "blobs"));
        } else {
            this.blobFS = new MemoryFileSystem();
        }
        this.blobFS.init();
        this.blobStore = new FileSystemBLOBStore(this.blobFS);
        if (this.persistent) {
            this.loadContents();
        }
        this.initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws Exception {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        try {
            if (this.persistent) {
                this.storeContents();
            } else {
                try {
                    String[] files;
                    String[] folders;
                    for (String folder : folders = this.blobFS.listFolders("/")) {
                        this.blobFS.deleteFolder(folder);
                    }
                    for (String file : files = this.blobFS.listFiles("/")) {
                        this.blobFS.deleteFile(file);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.blobFS.close();
            this.blobFS = null;
            this.blobStore = null;
            this.stateStore.clear();
            this.stateStore = null;
            this.refsStore.clear();
            this.refsStore = null;
        }
        finally {
            this.initialized = false;
        }
    }

    public synchronized NodeState load(NodeId id) throws NoSuchItemStateException, ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        byte[] data = this.stateStore.get(id);
        if (data == null) {
            throw new NoSuchItemStateException(id.toString());
        }
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        try {
            NodeState state = this.createNew(id);
            Serializer.deserialize(state, (InputStream)in);
            return state;
        }
        catch (Exception e) {
            String msg = "failed to read node state: " + id;
            log.debug(msg);
            throw new ItemStateException(msg, e);
        }
    }

    public synchronized PropertyState load(PropertyId id) throws NoSuchItemStateException, ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        byte[] data = this.stateStore.get(id);
        if (data == null) {
            throw new NoSuchItemStateException(id.toString());
        }
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        try {
            PropertyState state = this.createNew(id);
            Serializer.deserialize(state, in, this.blobStore);
            return state;
        }
        catch (Exception e) {
            String msg = "failed to read property state: " + id;
            log.debug(msg);
            throw new ItemStateException(msg, e);
        }
    }

    protected void store(NodeState state) throws ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
            Serializer.serialize(state, (OutputStream)out);
            this.stateStore.put(state.getNodeId(), out.toByteArray());
        }
        catch (Exception e) {
            String msg = "failed to write node state: " + state.getNodeId();
            log.debug(msg);
            throw new ItemStateException(msg, e);
        }
    }

    protected void store(PropertyState state) throws ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
            Serializer.serialize(state, out, this.blobStore);
            this.stateStore.put(state.getPropertyId(), out.toByteArray());
        }
        catch (Exception e) {
            String msg = "failed to store property state: " + state.getPropertyId();
            log.debug(msg);
            throw new ItemStateException(msg, e);
        }
    }

    protected void destroy(NodeState state) throws ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        this.stateStore.remove(state.getNodeId());
    }

    protected void destroy(PropertyState state) throws ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        InternalValue[] values = state.getValues();
        if (values != null) {
            for (InternalValue val : values) {
                if (val == null) continue;
                val.deleteBinaryResource();
            }
        }
        this.stateStore.remove(state.getPropertyId());
    }

    public synchronized NodeReferences loadReferencesTo(NodeId id) throws NoSuchItemStateException, ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        byte[] data = this.refsStore.get(id);
        if (data == null) {
            throw new NoSuchItemStateException(id.toString());
        }
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        try {
            NodeReferences refs = new NodeReferences(id);
            Serializer.deserialize(refs, (InputStream)in);
            return refs;
        }
        catch (Exception e) {
            String msg = "failed to load references: " + id;
            log.debug(msg);
            throw new ItemStateException(msg, e);
        }
    }

    protected void store(NodeReferences refs) throws ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
            Serializer.serialize(refs, (OutputStream)out);
            this.refsStore.put(refs.getTargetId(), out.toByteArray());
        }
        catch (Exception e) {
            String msg = "failed to store " + refs;
            log.debug(msg);
            throw new ItemStateException(msg, e);
        }
    }

    protected void destroy(NodeReferences refs) throws ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        this.refsStore.remove(refs.getTargetId());
    }

    public boolean exists(PropertyId id) throws ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        return this.stateStore.containsKey(id);
    }

    public boolean exists(NodeId id) throws ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        return this.stateStore.containsKey(id);
    }

    public boolean existsReferencesTo(NodeId id) throws ItemStateException {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        return this.refsStore.containsKey(id);
    }
}

