/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.xml.jaxp;

import java.io.OutputStream;
import java.io.Writer;
import java.net.URL;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.persistence.platform.xml.XMLPlatformException;
import org.eclipse.persistence.platform.xml.XMLTransformer;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;

public class JAXPTransformer
implements XMLTransformer {
    private boolean fragment;
    private static final String NO = "no";
    private static final String YES = "yes";
    private Transformer transformer;

    public JAXPTransformer() {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            this.transformer = transformerFactory.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw XMLPlatformException.xmlPlatformTransformException(e);
        }
    }

    public String getEncoding() {
        return this.transformer.getOutputProperty("encoding");
    }

    public void setEncoding(String encoding) {
        this.transformer.setOutputProperty("encoding", encoding);
    }

    public boolean isFormattedOutput() {
        return this.transformer.getOutputProperty("indent").equals(YES);
    }

    public void setFormattedOutput(boolean shouldFormat) {
        if (shouldFormat) {
            this.transformer.setOutputProperty("indent", YES);
        } else {
            this.transformer.setOutputProperty("indent", NO);
        }
    }

    public String getVersion() {
        return this.transformer.getOutputProperty("version");
    }

    public void setVersion(String version) {
        this.transformer.setOutputProperty("version", version);
    }

    public void transform(Node sourceNode, OutputStream resultOutputStream) throws XMLPlatformException {
        DOMSource source = new DOMSource(sourceNode);
        StreamResult result = new StreamResult(resultOutputStream);
        if (this.isFragment()) {
            this.transformer.setOutputProperty("omit-xml-declaration", YES);
        }
        this.transform(source, (Result)result);
    }

    public void transform(Node sourceNode, ContentHandler resultContentHandler) throws XMLPlatformException {
        DOMSource source = new DOMSource(sourceNode);
        SAXResult result = new SAXResult(resultContentHandler);
        this.transform(source, (Result)result);
    }

    public void transform(Node sourceNode, Result result) throws XMLPlatformException {
        DOMSource source = null;
        if (this.isFragment() && result instanceof SAXResult) {
            if (sourceNode instanceof Document) {
                source = new DOMSource(((Document)sourceNode).getDocumentElement());
            }
        } else {
            source = new DOMSource(sourceNode);
        }
        this.transform(source, result);
    }

    public void transform(Node sourceNode, Writer resultWriter) throws XMLPlatformException {
        DOMSource source = new DOMSource(sourceNode);
        StreamResult result = new StreamResult(resultWriter);
        if (this.isFragment()) {
            this.transformer.setOutputProperty("omit-xml-declaration", YES);
        }
        this.transform(source, (Result)result);
    }

    public void transform(Source source, Result result) throws XMLPlatformException {
        try {
            if (result instanceof StreamResult && this.isFragment()) {
                this.transformer.setOutputProperty("omit-xml-declaration", YES);
            }
            this.transformer.transform(source, result);
        }
        catch (TransformerException e) {
            throw XMLPlatformException.xmlPlatformTransformException(e);
        }
    }

    public void transform(Document sourceDocument, Node resultParentNode, URL stylesheet) throws XMLPlatformException {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setErrorListener(new TransformErrorListener());
            StreamSource stylesheetSource = new StreamSource(stylesheet.openStream());
            Transformer transformer = transformerFactory.newTransformer(stylesheetSource);
            DOMSource source = new DOMSource(sourceDocument);
            DOMResult result = new DOMResult(resultParentNode);
            transformer.transform(source, result);
        }
        catch (Exception e) {
            throw XMLPlatformException.xmlPlatformTransformException(e);
        }
    }

    public void setFragment(boolean fragment) {
        this.fragment = fragment;
    }

    public boolean isFragment() {
        return this.fragment;
    }

    private static class TransformErrorListener
    implements ErrorListener {
        private TransformErrorListener() {
        }

        public void error(TransformerException exception) throws TransformerException {
            throw XMLPlatformException.xmlPlatformTransformException(exception);
        }

        public void fatalError(TransformerException exception) throws TransformerException {
            throw XMLPlatformException.xmlPlatformTransformException(exception);
        }

        public void warning(TransformerException exception) throws TransformerException {
            throw XMLPlatformException.xmlPlatformTransformException(exception);
        }
    }
}

