/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search;

import com.liferay.portal.kernel.cluster.messaging.ClusterBridgeMessageListener;
import com.liferay.portal.kernel.concurrent.CallerRunsPolicy;
import com.liferay.portal.kernel.concurrent.ThreadPoolExecutor;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.InvokerMessageListener;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.messaging.ParallelDestination;
import com.liferay.portal.kernel.messaging.SynchronousDestination;
import com.liferay.portal.kernel.search.IndexSearcher;
import com.liferay.portal.kernel.search.IndexWriter;
import com.liferay.portal.kernel.search.SearchEngine;
import com.liferay.portal.kernel.search.SearchEngineProxyWrapper;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.search.messaging.BaseSearchEngineMessageListener;
import com.liferay.portal.kernel.search.messaging.SearchReaderMessageListener;
import com.liferay.portal.kernel.search.messaging.SearchWriterMessageListener;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractSearchEngineConfigurator {
    private static final int _INDEX_SEARCH_WRITER_MAX_QUEUE_SIZE = GetterUtil.getInteger(PropsUtil.get("index.search.writer.max.queue.size"));
    private static Log _log = LogFactoryUtil.getLog(AbstractSearchEngineConfigurator.class);
    private String _originalSearchEngineId;
    private List<SearchEngineRegistration> _searchEngineRegistrations = new ArrayList<SearchEngineRegistration>();
    private Map<String, SearchEngine> _searchEngines;

    public void afterPropertiesSet() {
        Set<Map.Entry<String, SearchEngine>> entrySet = this._searchEngines.entrySet();
        for (Map.Entry<String, SearchEngine> entry : entrySet) {
            this.initSearchEngine(entry.getKey(), entry.getValue());
        }
        String defaultSearchEngineId = this.getDefaultSearchEngineId();
        if (Validator.isNotNull(defaultSearchEngineId)) {
            this._originalSearchEngineId = SearchEngineUtil.getDefaultSearchEngineId();
            SearchEngineUtil.setDefaultSearchEngineId(defaultSearchEngineId);
        }
        this._searchEngines.clear();
    }

    public void destroy() {
        for (SearchEngineRegistration searchEngineRegistration : this._searchEngineRegistrations) {
            this.destroySearchEngine(searchEngineRegistration);
        }
        this._searchEngineRegistrations.clear();
        if (Validator.isNotNull(this._originalSearchEngineId)) {
            SearchEngineUtil.setDefaultSearchEngineId(this._originalSearchEngineId);
            this._originalSearchEngineId = null;
        }
    }

    public void setSearchEngines(Map<String, SearchEngine> searchEngines) {
        this._searchEngines = searchEngines;
    }

    protected void createSearchEngineListeners(String searchEngineId, SearchEngine searchEngine, Destination searchReaderDestination, Destination searchWriterDestination) {
        this.registerSearchEngineMessageListener(searchEngineId, searchEngine, searchReaderDestination, new SearchReaderMessageListener(), searchEngine.getIndexSearcher());
        this.registerSearchEngineMessageListener(searchEngineId, searchEngine, searchWriterDestination, new SearchWriterMessageListener(), searchEngine.getIndexWriter());
        if (searchEngine.isClusteredWrite()) {
            ClusterBridgeMessageListener clusterBridgeMessageListener = new ClusterBridgeMessageListener();
            clusterBridgeMessageListener.setPriority(searchEngine.getClusteredWritePriority());
            searchWriterDestination.register(clusterBridgeMessageListener);
        }
    }

    protected void destroySearchEngine(SearchEngineRegistration searchEngineRegistration) {
        MessageBus messageBus = this.getMessageBus();
        Destination searchReaderDestination = messageBus.removeDestination(searchEngineRegistration.getSearchReaderDestinationName());
        searchReaderDestination.close(true);
        Destination searchWriterDestination = messageBus.removeDestination(searchEngineRegistration.getSearchWriterDestinationName());
        searchWriterDestination.close(true);
        SearchEngineUtil.removeSearchEngine(searchEngineRegistration.getSearchEngineId());
        if (!searchEngineRegistration.isOverride()) {
            return;
        }
        SearchEngineProxyWrapper originalSearchEngineProxy = searchEngineRegistration.getOriginalSearchEngineProxyWrapper();
        SearchEngine originalSearchEngine = originalSearchEngineProxy.getSearchEngine();
        searchReaderDestination = this.getSearchReaderDestination(messageBus, searchEngineRegistration.getSearchEngineId(), originalSearchEngine);
        this.registerInvokerMessageListener(searchReaderDestination, searchEngineRegistration.getOriginalSearchReaderMessageListeners());
        searchWriterDestination = this.getSearchWriterDestination(messageBus, searchEngineRegistration.getSearchEngineId(), originalSearchEngine);
        this.registerInvokerMessageListener(searchWriterDestination, searchEngineRegistration.getOriginalSearchWriterMessageListeners());
        SearchEngineUtil.setSearchEngine(searchEngineRegistration.getSearchEngineId(), originalSearchEngineProxy);
    }

    protected abstract String getDefaultSearchEngineId();

    protected abstract IndexSearcher getIndexSearcher();

    protected abstract IndexWriter getIndexWriter();

    protected abstract MessageBus getMessageBus();

    protected abstract ClassLoader getOperatingClassloader();

    protected Destination getSearchReaderDestination(MessageBus messageBus, String searchEngineId, SearchEngine searchEngine) {
        String searchReaderDestinationName = SearchEngineUtil.getSearchReaderDestinationName(searchEngineId);
        Destination searchReaderDestination = messageBus.getDestination(searchReaderDestinationName);
        if (searchReaderDestination == null) {
            SynchronousDestination synchronousDestination = new SynchronousDestination();
            synchronousDestination.setName(searchReaderDestinationName);
            synchronousDestination.open();
            searchReaderDestination = synchronousDestination;
            messageBus.addDestination(searchReaderDestination);
        }
        return searchReaderDestination;
    }

    protected Destination getSearchWriterDestination(MessageBus messageBus, String searchEngineId, SearchEngine searchEngine) {
        String searchWriterDestinationName = SearchEngineUtil.getSearchWriterDestinationName(searchEngineId);
        Destination searchWriterDestination = messageBus.getDestination(searchWriterDestinationName);
        if (searchWriterDestination == null) {
            ParallelDestination parallelDestination = new ParallelDestination();
            parallelDestination.setName(searchWriterDestinationName);
            if (_INDEX_SEARCH_WRITER_MAX_QUEUE_SIZE > 0) {
                parallelDestination.setMaximumQueueSize(_INDEX_SEARCH_WRITER_MAX_QUEUE_SIZE);
                CallerRunsPolicy rejectedExecutionHandler = new CallerRunsPolicy(){

                    @Override
                    public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
                        if (_log.isWarnEnabled()) {
                            StringBundler sb = new StringBundler(4);
                            sb.append("The search index writer's task queue ");
                            sb.append("is at its maximum capacity. The ");
                            sb.append("current thread will handle the ");
                            sb.append("request.");
                            _log.warn(sb.toString());
                        }
                        super.rejectedExecution(runnable, threadPoolExecutor);
                    }
                };
                parallelDestination.setRejectedExecutionHandler(rejectedExecutionHandler);
            }
            parallelDestination.open();
            searchWriterDestination = parallelDestination;
            messageBus.addDestination(searchWriterDestination);
        }
        return searchWriterDestination;
    }

    protected void initSearchEngine(String searchEngineId, SearchEngine searchEngine) {
        SearchEngineRegistration searchEngineRegistration = new SearchEngineRegistration(searchEngineId);
        this._searchEngineRegistrations.add(searchEngineRegistration);
        MessageBus messageBus = this.getMessageBus();
        Destination searchReaderDestination = this.getSearchReaderDestination(messageBus, searchEngineId, searchEngine);
        searchEngineRegistration.setSearchReaderDestinationName(searchReaderDestination.getName());
        Destination searchWriterDestination = this.getSearchWriterDestination(messageBus, searchEngineId, searchEngine);
        searchEngineRegistration.setSearchWriterDestinationName(searchWriterDestination.getName());
        SearchEngine originalSearchEngine = SearchEngineUtil.getSearchEngineSilent(searchEngineId);
        if (originalSearchEngine != null) {
            searchEngineRegistration.setOverride(true);
            searchEngineRegistration.setOriginalSearchEngineProxyWrapper((SearchEngineProxyWrapper)originalSearchEngine);
            this.savePreviousSearchEngineListeners(searchReaderDestination, searchWriterDestination, searchEngineRegistration);
            messageBus.removeDestination(searchReaderDestination.getName());
            searchReaderDestination = this.getSearchReaderDestination(messageBus, searchEngineId, originalSearchEngine);
            messageBus.removeDestination(searchWriterDestination.getName());
            searchWriterDestination = this.getSearchWriterDestination(messageBus, searchEngineId, originalSearchEngine);
        }
        this.createSearchEngineListeners(searchEngineId, searchEngine, searchReaderDestination, searchWriterDestination);
        SearchEngineProxyWrapper searchEngineProxyWrapper = new SearchEngineProxyWrapper(searchEngine, this.getIndexSearcher(), this.getIndexWriter());
        SearchEngineUtil.setSearchEngine(searchEngineId, searchEngineProxyWrapper);
    }

    protected void registerInvokerMessageListener(Destination destination, List<InvokerMessageListener> invokerMessageListeners) {
        for (InvokerMessageListener invokerMessageListener : invokerMessageListeners) {
            destination.register(invokerMessageListener.getMessageListener(), invokerMessageListener.getClassLoader());
        }
    }

    protected void registerSearchEngineMessageListener(String searchEngineId, SearchEngine searchEngine, Destination destination, BaseSearchEngineMessageListener baseSearchEngineMessageListener, Object manager) {
        baseSearchEngineMessageListener.setManager(manager);
        baseSearchEngineMessageListener.setMessageBus(this.getMessageBus());
        baseSearchEngineMessageListener.setSearchEngine(searchEngine);
        baseSearchEngineMessageListener.setSearchEngineId(searchEngineId);
        destination.register(baseSearchEngineMessageListener, this.getOperatingClassloader());
    }

    protected void savePreviousSearchEngineListeners(Destination searchReaderDestination, Destination searchWriterDestination, SearchEngineRegistration searchEngineRegistration) {
        Set<MessageListener> searchReaderMessageListeners = searchReaderDestination.getMessageListeners();
        for (MessageListener searchReaderMessageListener : searchReaderMessageListeners) {
            InvokerMessageListener invokerMessageListener = (InvokerMessageListener)searchReaderMessageListener;
            searchEngineRegistration.addOriginalSearchReaderMessageListener(invokerMessageListener);
        }
        Set<MessageListener> searchWriterMessageListeners = searchWriterDestination.getMessageListeners();
        for (MessageListener searchWriterMessageListener : searchWriterMessageListeners) {
            InvokerMessageListener invokerMessageListener = (InvokerMessageListener)searchWriterMessageListener;
            searchEngineRegistration.addOriginalSearchWriterMessageListener(invokerMessageListener);
        }
    }

    private class SearchEngineRegistration {
        private SearchEngineProxyWrapper _originalSearchEngineProxyWrapper;
        private List<InvokerMessageListener> _originalSearchReaderMessageListeners = new ArrayList<InvokerMessageListener>();
        private List<InvokerMessageListener> _originalSearchWriterMessageListeners = new ArrayList<InvokerMessageListener>();
        private boolean _override;
        private String _searchEngineId;
        private String _searchReaderDestinationName;
        private String _searchWriterDestinationName;

        private SearchEngineRegistration(String searchEngineId) {
            this._searchEngineId = searchEngineId;
        }

        public void addOriginalSearchReaderMessageListener(InvokerMessageListener messageListener) {
            this._originalSearchReaderMessageListeners.add(messageListener);
        }

        public void addOriginalSearchWriterMessageListener(InvokerMessageListener messageListener) {
            this._originalSearchWriterMessageListeners.add(messageListener);
        }

        public SearchEngineProxyWrapper getOriginalSearchEngineProxyWrapper() {
            return this._originalSearchEngineProxyWrapper;
        }

        public List<InvokerMessageListener> getOriginalSearchReaderMessageListeners() {
            return this._originalSearchReaderMessageListeners;
        }

        public List<InvokerMessageListener> getOriginalSearchWriterMessageListeners() {
            return this._originalSearchWriterMessageListeners;
        }

        public String getSearchEngineId() {
            return this._searchEngineId;
        }

        public String getSearchReaderDestinationName() {
            return this._searchReaderDestinationName;
        }

        public String getSearchWriterDestinationName() {
            return this._searchWriterDestinationName;
        }

        public boolean isOverride() {
            return this._override;
        }

        public void setOriginalSearchEngineProxyWrapper(SearchEngineProxyWrapper searchEngineProxyWrapper) {
            this._originalSearchEngineProxyWrapper = searchEngineProxyWrapper;
        }

        public void setOverride(boolean override) {
            this._override = override;
        }

        public void setSearchReaderDestinationName(String searchReaderDestinationName) {
            this._searchReaderDestinationName = searchReaderDestinationName;
        }

        public void setSearchWriterDestinationName(String searchWriterDestinationName) {
            this._searchWriterDestinationName = searchWriterDestinationName;
        }
    }
}

