/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Expression;
import org.hsqldb.ExpressionValue;
import org.hsqldb.ParserDQL;
import org.hsqldb.Session;
import org.hsqldb.TypeInvariants;
import org.hsqldb.error.Error;
import org.hsqldb.lib.IntValueHashMap;
import org.hsqldb.lib.OrderedIntHashSet;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.BinaryType;
import org.hsqldb.types.BlobData;
import org.hsqldb.types.CharacterType;
import org.hsqldb.types.DTIType;
import org.hsqldb.types.DateTimeType;
import org.hsqldb.types.NumberType;
import org.hsqldb.types.Type;

public class FunctionSQL
extends Expression {
    protected static final int FUNC_POSITION_CHAR = 1;
    private static final int FUNC_POSITION_BINARY = 2;
    private static final int FUNC_OCCURENCES_REGEX = 3;
    private static final int FUNC_POSITION_REGEX = 4;
    protected static final int FUNC_EXTRACT = 5;
    protected static final int FUNC_BIT_LENGTH = 6;
    protected static final int FUNC_CHAR_LENGTH = 7;
    protected static final int FUNC_OCTET_LENGTH = 8;
    private static final int FUNC_CARDINALITY = 9;
    private static final int FUNC_MAX_CARDINALITY = 10;
    private static final int FUNC_TRIM_ARRAY = 11;
    private static final int FUNC_ABS = 12;
    private static final int FUNC_MOD = 13;
    protected static final int FUNC_LN = 14;
    private static final int FUNC_EXP = 15;
    private static final int FUNC_POWER = 16;
    private static final int FUNC_SQRT = 17;
    private static final int FUNC_FLOOR = 20;
    private static final int FUNC_CEILING = 21;
    private static final int FUNC_WIDTH_BUCKET = 22;
    protected static final int FUNC_SUBSTRING_CHAR = 23;
    private static final int FUNC_SUBSTRING_REG_EXPR = 24;
    private static final int FUNC_SUBSTRING_REGEX = 25;
    protected static final int FUNC_FOLD_LOWER = 26;
    protected static final int FUNC_FOLD_UPPER = 27;
    private static final int FUNC_TRANSCODING = 28;
    private static final int FUNC_TRANSLITERATION = 29;
    private static final int FUNC_REGEX_TRANSLITERATION = 30;
    protected static final int FUNC_TRIM_CHAR = 31;
    static final int FUNC_OVERLAY_CHAR = 32;
    private static final int FUNC_CHAR_NORMALIZE = 33;
    private static final int FUNC_SUBSTRING_BINARY = 40;
    private static final int FUNC_TRIM_BINARY = 41;
    private static final int FUNC_OVERLAY_BINARY = 42;
    protected static final int FUNC_CURRENT_DATE = 43;
    protected static final int FUNC_CURRENT_TIME = 44;
    protected static final int FUNC_CURRENT_TIMESTAMP = 50;
    protected static final int FUNC_LOCALTIME = 51;
    protected static final int FUNC_LOCALTIMESTAMP = 52;
    private static final int FUNC_CURRENT_CATALOG = 53;
    private static final int FUNC_CURRENT_DEFAULT_TRANSFORM_GROUP = 54;
    private static final int FUNC_CURRENT_PATH = 55;
    private static final int FUNC_CURRENT_ROLE = 56;
    private static final int FUNC_CURRENT_SCHEMA = 57;
    private static final int FUNC_CURRENT_TRANSFORM_GROUP_FOR_TYPE = 58;
    private static final int FUNC_CURRENT_USER = 59;
    private static final int FUNC_SESSION_USER = 60;
    private static final int FUNC_SYSTEM_USER = 61;
    protected static final int FUNC_USER = 62;
    private static final int FUNC_VALUE = 63;
    static final short[] noParamList = new short[0];
    static final short[] emptyParamList = new short[]{786, 772};
    static final short[] optionalNoParamList = new short[]{842, 2, 786, 772};
    static final short[] optionalSingleParamList = new short[]{786, 842, 1, 788, 772};
    static final short[] singleParamList = new short[]{786, 788, 772};
    static final short[] optionalIntegerParamList = new short[]{842, 3, 786, 844, 772};
    static final short[] doubleParamList = new short[]{786, 788, 774, 788, 772};
    static final short[] tripleParamList = new short[]{786, 788, 774, 788, 774, 788, 772};
    static final short[] quadParamList = new short[]{786, 788, 774, 788, 774, 788, 774, 788, 772};
    static IntValueHashMap valueFuncMap = new IntValueHashMap();
    static IntValueHashMap regularFuncMap = new IntValueHashMap();
    static OrderedIntHashSet nonDeterministicFuncSet = new OrderedIntHashSet();
    int funcType;
    boolean isDeterministic;
    String name;
    short[] parseList;
    short[] parseListAlt;
    boolean isSQLValueFunction;

    public static FunctionSQL newSQLFunction(String token, ParserDQL.CompileContext context) {
        int id = regularFuncMap.get((Object)token, -1);
        boolean isValueFunction = false;
        if (id == -1) {
            id = valueFuncMap.get((Object)token, -1);
            isValueFunction = true;
        }
        if (id == -1) {
            return null;
        }
        FunctionSQL function = new FunctionSQL(id);
        if (id == 63) {
            if (context.currentDomain == null) {
                return null;
            }
            function.dataType = context.currentDomain;
        } else {
            function.isSQLValueFunction = isValueFunction;
        }
        return function;
    }

    protected FunctionSQL() {
        super(28);
        this.nodes = Expression.emptyArray;
    }

    protected FunctionSQL(int id) {
        this();
        this.funcType = id;
        this.isDeterministic = !nonDeterministicFuncSet.contains(id);
        switch (id) {
            case 1: 
            case 2: {
                this.name = "POSITION";
                this.parseList = new short[]{786, 788, 130, 788, 842, 5, 306, 841, 2, 355, 454, 772};
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                this.name = "EXTRACT";
                this.parseList = new short[]{786, 841, 17, 323, 173, 73, 127, 169, 250, 657, 734, 695, 658, 656, 734, 655, 687, 706, 283, 284, 115, 788, 772};
                break;
            }
            case 7: {
                this.name = "CHAR_LENGTH";
                this.parseList = new short[]{786, 788, 842, 5, 306, 841, 2, 355, 454, 772};
                break;
            }
            case 6: {
                this.name = "BIT_LENGTH";
                this.parseList = singleParamList;
                break;
            }
            case 8: {
                this.name = "OCTET_LENGTH";
                this.parseList = singleParamList;
                break;
            }
            case 9: {
                this.name = "CARDINALITY";
                this.parseList = singleParamList;
                break;
            }
            case 10: {
                this.name = "MAX_CARDINALITY";
                this.parseList = singleParamList;
                break;
            }
            case 11: {
                this.name = "TRIM_ARRAY";
                this.parseList = doubleParamList;
                break;
            }
            case 12: {
                this.name = "ABS";
                this.parseList = singleParamList;
                break;
            }
            case 13: {
                this.name = "MOD";
                this.parseList = doubleParamList;
                break;
            }
            case 14: {
                this.name = "LN";
                this.parseList = singleParamList;
                break;
            }
            case 15: {
                this.name = "EXP";
                this.parseList = singleParamList;
                break;
            }
            case 16: {
                this.name = "POWER";
                this.parseList = doubleParamList;
                break;
            }
            case 17: {
                this.name = "SQRT";
                this.parseList = singleParamList;
                break;
            }
            case 20: {
                this.name = "FLOOR";
                this.parseList = singleParamList;
                break;
            }
            case 21: {
                this.name = "CEILING";
                this.parseList = singleParamList;
                break;
            }
            case 22: {
                this.name = "WIDTH_BUCKET";
                this.parseList = quadParamList;
                break;
            }
            case 23: 
            case 40: {
                this.name = "SUBSTRING";
                this.parseList = new short[]{786, 788, 115, 788, 842, 2, 112, 788, 842, 5, 306, 841, 2, 355, 454, 772};
                this.parseListAlt = new short[]{786, 788, 774, 788, 842, 2, 774, 788, 772};
                break;
            }
            case 26: {
                this.name = "LOWER";
                this.parseList = singleParamList;
                break;
            }
            case 27: {
                this.name = "UPPER";
                this.parseList = singleParamList;
                break;
            }
            case 31: 
            case 41: {
                this.name = "TRIM";
                this.parseList = new short[]{786, 842, 11, 842, 5, 841, 3, 151, 286, 23, 842, 1, 788, 115, 788, 772};
                break;
            }
            case 32: 
            case 42: {
                this.name = "OVERLAY";
                this.parseList = new short[]{786, 788, 473, 788, 115, 788, 842, 2, 112, 788, 842, 2, 306, 355, 772};
                break;
            }
            case 53: {
                this.name = "CURRENT_CATALOG";
                this.parseList = noParamList;
                break;
            }
            case 56: {
                this.name = "CURRENT_ROLE";
                this.parseList = noParamList;
                break;
            }
            case 57: {
                this.name = "CURRENT_SCHEMA";
                this.parseList = noParamList;
                break;
            }
            case 59: {
                this.name = "CURRENT_USER";
                this.parseList = noParamList;
                break;
            }
            case 60: {
                this.name = "SESSION_USER";
                this.parseList = noParamList;
                break;
            }
            case 61: {
                this.name = "SYSTEM_USER";
                this.parseList = noParamList;
                break;
            }
            case 62: {
                this.name = "USER";
                this.parseList = optionalNoParamList;
                break;
            }
            case 63: {
                this.name = "VALUE";
                this.parseList = noParamList;
                break;
            }
            case 43: {
                this.name = "CURRENT_DATE";
                this.parseList = noParamList;
                break;
            }
            case 44: {
                this.name = "CURRENT_TIME";
                this.parseList = optionalIntegerParamList;
                break;
            }
            case 50: {
                this.name = "CURRENT_TIMESTAMP";
                this.parseList = optionalIntegerParamList;
                break;
            }
            case 51: {
                this.name = "LOCALTIME";
                this.parseList = optionalIntegerParamList;
                break;
            }
            case 52: {
                this.name = "LOCALTIMESTAMP";
                this.parseList = optionalIntegerParamList;
                break;
            }
            default: {
                throw Error.runtimeError(201, "FunctionSQL");
            }
        }
    }

    public void setArguments(Expression[] newNodes) {
        this.nodes = newNodes;
    }

    public Expression getFunctionExpression() {
        return this;
    }

    public Object getValue(Session session) {
        Object[] data = new Object[this.nodes.length];
        for (int i = 0; i < this.nodes.length; ++i) {
            Expression e = this.nodes[i];
            if (e == null) continue;
            data[i] = e.getValue(session, e.dataType);
        }
        return this.getValue(session, data);
    }

    Object getValue(Session session, Object[] data) {
        switch (this.funcType) {
            case 1: {
                Object value;
                if (data[0] == null || data[1] == null) {
                    return null;
                }
                long offset = 0L;
                if (this.nodes.length > 3 && this.nodes[3] != null && (offset = ((Number)(value = this.nodes[3].getValue(session))).longValue() - 1L) < 0L) {
                    offset = 0L;
                }
                long result = ((CharacterType)this.nodes[1].dataType).position(session, data[1], data[0], this.nodes[0].dataType, offset) + 1L;
                if (this.nodes[2] != null && ((Number)this.nodes[2].valueData).intValue() == 454) {
                    result *= 2L;
                }
                return ValuePool.getLong(result);
            }
            case 2: {
                if (data[0] == null || data[1] == null) {
                    return null;
                }
                long result = ((BinaryType)this.nodes[1].dataType).position(session, (BlobData)data[1], (BlobData)data[0], this.nodes[0].dataType, 0L) + 1L;
                if (this.nodes[2] != null && ((Number)this.nodes[2].valueData).intValue() == 454) {
                    result *= 2L;
                }
                return ValuePool.getLong(result);
            }
            case 5: {
                if (data[1] == null) {
                    return null;
                }
                int part = ((Number)this.nodes[0].valueData).intValue();
                part = DTIType.getFieldNameTypeForToken(part);
                switch (part) {
                    case 106: {
                        return ((DTIType)this.nodes[1].dataType).getSecondPart(data[1]);
                    }
                    case 264: 
                    case 265: {
                        return ((DateTimeType)this.nodes[1].dataType).getPartString(session, data[1], part);
                    }
                }
                int value = ((DTIType)this.nodes[1].dataType).getPart(session, data[1], part);
                return ValuePool.getInt(value);
            }
            case 7: {
                if (data[0] == null) {
                    return null;
                }
                long result = ((CharacterType)this.nodes[0].dataType).size(session, data[0]);
                return ValuePool.getLong(result);
            }
            case 6: {
                if (data[0] == null) {
                    return null;
                }
                long result = this.nodes[0].dataType.isBinaryType() ? ((BlobData)data[0]).bitLength(session) : 16L * ((CharacterType)this.nodes[0].dataType).size(session, data[0]);
                return ValuePool.getLong(result);
            }
            case 8: {
                if (data[0] == null) {
                    return null;
                }
                long result = this.nodes[0].dataType.isBinaryType() ? ((BlobData)data[0]).length(session) : 2L * ((CharacterType)this.nodes[0].dataType).size(session, data[0]);
                return ValuePool.getLong(result);
            }
            case 9: {
                if (data[0] == null) {
                    return null;
                }
                int result = this.nodes[0].dataType.cardinality(session, data[0]);
                return ValuePool.getInt(result);
            }
            case 10: {
                if (data[0] == null) {
                    return null;
                }
                int result = this.nodes[0].dataType.arrayLimitCardinality();
                return ValuePool.getInt(result);
            }
            case 11: {
                if (data[0] == null) {
                    return null;
                }
                if (data[1] == null) {
                    return null;
                }
                Object[] array = (Object[])data[0];
                int length = ((Number)data[1]).intValue();
                if (length < 0 || length > array.length) {
                    throw Error.error(3490);
                }
                Object[] newArray = new Object[array.length - length];
                System.arraycopy(array, 0, newArray, 0, newArray.length);
                return newArray;
            }
            case 12: {
                if (data[0] == null) {
                    return null;
                }
                return this.dataType.absolute(data[0]);
            }
            case 13: {
                if (data[0] == null || data[1] == null) {
                    return null;
                }
                Object value = ((NumberType)this.nodes[0].dataType).modulo(data[0], data[1], this.nodes[0].dataType);
                return this.dataType.convertToType(session, value, this.nodes[0].dataType);
            }
            case 14: {
                if (data[0] == null) {
                    return null;
                }
                double d = ((Number)data[0]).doubleValue();
                if (d <= 0.0) {
                    throw Error.error(3444);
                }
                d = Math.log(d);
                return ValuePool.getDouble(Double.doubleToLongBits(d));
            }
            case 15: {
                if (data[0] == null) {
                    return null;
                }
                double val = Math.exp(((Number)data[0]).doubleValue());
                return ValuePool.getDouble(Double.doubleToLongBits(val));
            }
            case 16: {
                double val;
                if (data[0] == null || data[1] == null) {
                    return null;
                }
                double base = ((Number)data[0]).doubleValue();
                double exponent = ((Number)data[1]).doubleValue();
                if (base == 0.0) {
                    if (exponent < 0.0) {
                        throw Error.error(3445);
                    }
                    val = exponent == 0.0 ? 1.0 : 0.0;
                } else {
                    val = Math.pow(base, exponent);
                }
                return ValuePool.getDouble(Double.doubleToLongBits(val));
            }
            case 17: {
                if (data[0] == null) {
                    return null;
                }
                double val = Math.sqrt(((Number)data[0]).doubleValue());
                return ValuePool.getDouble(Double.doubleToLongBits(val));
            }
            case 20: {
                if (data[0] == null) {
                    return null;
                }
                return ((NumberType)this.dataType).floor(data[0]);
            }
            case 21: {
                if (data[0] == null) {
                    return null;
                }
                return ((NumberType)this.dataType).ceiling(data[0]);
            }
            case 22: {
                return null;
            }
            case 23: {
                if (data[0] == null || data[1] == null) {
                    return null;
                }
                Object value = Type.SQL_BIGINT.convertToType(session, data[1], this.nodes[1].dataType);
                long offset = ((Number)value).longValue() - 1L;
                long length = 0L;
                if (this.nodes[2] != null) {
                    if (data[2] == null) {
                        return null;
                    }
                    value = Type.SQL_BIGINT.convertToType(session, data[2], this.nodes[2].dataType);
                    length = ((Number)value).longValue();
                }
                if (this.nodes.length <= 3 || this.nodes[3] == null || ((Number)this.nodes[2].valueData).intValue() == 454) {
                    // empty if block
                }
                return ((CharacterType)this.dataType).substring(session, data[0], offset, length, this.nodes[2] != null, false);
            }
            case 26: {
                if (data[0] == null) {
                    return null;
                }
                return ((CharacterType)this.dataType).lower(session, data[0]);
            }
            case 27: {
                if (data[0] == null) {
                    return null;
                }
                return ((CharacterType)this.dataType).upper(session, data[0]);
            }
            case 31: {
                if (data[1] == null || data[2] == null) {
                    return null;
                }
                boolean leading = false;
                boolean trailing = false;
                switch (((Number)this.nodes[0].valueData).intValue()) {
                    case 23: {
                        trailing = true;
                        leading = true;
                        break;
                    }
                    case 151: {
                        leading = true;
                        break;
                    }
                    case 286: {
                        trailing = true;
                        break;
                    }
                    default: {
                        throw Error.runtimeError(201, "FunctionSQL");
                    }
                }
                String string = (String)data[1];
                if (string.length() != 1) {
                    throw Error.error(3460);
                }
                char character = string.charAt(0);
                return ((CharacterType)this.dataType).trim(session, data[2], character, leading, trailing);
            }
            case 32: {
                if (data[0] == null || data[1] == null || data[2] == null) {
                    return null;
                }
                Object value = Type.SQL_BIGINT.convertToType(session, data[2], this.nodes[2].dataType);
                long offset = ((Number)value).longValue() - 1L;
                long length = 0L;
                if (this.nodes[3] != null) {
                    if (data[3] == null) {
                        return null;
                    }
                    value = Type.SQL_BIGINT.convertToType(session, data[3], this.nodes[3].dataType);
                    length = ((Number)value).longValue();
                }
                return ((CharacterType)this.dataType).overlay(null, data[0], data[1], offset, length, this.nodes[3] != null);
            }
            case 40: {
                if (data[0] == null || data[1] == null) {
                    return null;
                }
                Object value = Type.SQL_BIGINT.convertToType(session, data[1], this.nodes[1].dataType);
                long offset = ((Number)value).longValue() - 1L;
                long length = 0L;
                if (this.nodes[2] != null) {
                    if (data[2] == null) {
                        return null;
                    }
                    value = Type.SQL_BIGINT.convertToType(session, data[2], this.nodes[2].dataType);
                    length = ((Number)value).intValue();
                }
                return ((BinaryType)this.dataType).substring(session, (BlobData)data[0], offset, length, this.nodes[2] != null);
            }
            case 41: {
                if (data[1] == null || data[2] == null) {
                    return null;
                }
                boolean leading = false;
                boolean trailing = false;
                int spec = ((Number)this.nodes[0].valueData).intValue();
                switch (spec) {
                    case 23: {
                        trailing = true;
                        leading = true;
                        break;
                    }
                    case 151: {
                        leading = true;
                        break;
                    }
                    case 286: {
                        trailing = true;
                        break;
                    }
                    default: {
                        throw Error.runtimeError(201, "FunctionSQL");
                    }
                }
                BlobData string = (BlobData)data[1];
                if (string.length(session) != 1L) {
                    throw Error.error(3460);
                }
                byte[] bytes = string.getBytes();
                return ((BinaryType)this.dataType).trim(session, (BlobData)data[2], bytes[0], leading, trailing);
            }
            case 42: {
                if (data[0] == null || data[1] == null || data[2] == null) {
                    return null;
                }
                Object value = Type.SQL_BIGINT.convertToType(session, data[2], this.nodes[2].dataType);
                long offset = ((Number)value).longValue() - 1L;
                long length = 0L;
                if (this.nodes[3] != null) {
                    if (data[3] == null) {
                        return null;
                    }
                    value = Type.SQL_BIGINT.convertToType(session, data[3], this.nodes[3].dataType);
                    length = ((Number)value).longValue();
                }
                return ((BinaryType)this.dataType).overlay(session, (BlobData)data[0], (BlobData)data[1], offset, length, this.nodes[3] != null);
            }
            case 53: {
                return session.database.getCatalogName().name;
            }
            case 56: {
                return session.getRole() == null ? null : session.getRole().getName().getNameString();
            }
            case 57: {
                return session.getCurrentSchemaHsqlName().name;
            }
            case 59: {
                return session.getUser().getName().getNameString();
            }
            case 60: {
                return session.getUser().getName().getNameString();
            }
            case 61: {
                return session.getUser().getName().getNameString();
            }
            case 62: {
                return session.getUser().getName().getNameString();
            }
            case 63: {
                return session.sessionData.currentValue;
            }
            case 43: {
                return session.getCurrentDate();
            }
            case 44: {
                return this.dataType.convertToTypeLimits(session, session.getCurrentTime(true));
            }
            case 50: {
                return this.dataType.convertToTypeLimits(session, session.getCurrentTimestamp(true));
            }
            case 51: {
                return this.dataType.convertToTypeLimits(session, session.getCurrentTime(false));
            }
            case 52: {
                return this.dataType.convertToTypeLimits(session, session.getCurrentTimestamp(false));
            }
        }
        throw Error.runtimeError(201, "FunctionSQL");
    }

    public void resolveTypes(Session session, Expression parent) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i].resolveTypes(session, this);
        }
        switch (this.funcType) {
            case 1: 
            case 2: {
                if (this.nodes[0].dataType == null) {
                    if (this.nodes[1].dataType == null) {
                        throw Error.error(5567);
                    }
                    this.nodes[0].dataType = this.nodes[1].dataType.typeCode == 40 || this.nodes[1].dataType.isBinaryType() ? this.nodes[1].dataType : Type.SQL_VARCHAR;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = this.nodes[0].dataType.typeCode == 40 || this.nodes[0].dataType.isBinaryType() ? this.nodes[0].dataType : Type.SQL_VARCHAR;
                }
                if (this.nodes[0].dataType.isCharacterType() && this.nodes[1].dataType.isCharacterType()) {
                    this.funcType = 1;
                } else if (this.nodes[0].dataType.isBinaryType() && this.nodes[1].dataType.isBinaryType()) {
                    if (this.nodes[0].dataType.isBitType() || this.nodes[1].dataType.isBitType()) {
                        throw Error.error(5563);
                    }
                    this.funcType = 2;
                } else {
                    throw Error.error(5563);
                }
                if (this.nodes.length > 3 && this.nodes[3] != null) {
                    if (this.nodes[3].isDynamicParam()) {
                        this.nodes[3].dataType = Type.SQL_BIGINT;
                    }
                    if (!this.nodes[3].dataType.isNumberType()) {
                        throw Error.error(5563);
                    }
                }
                this.dataType = Type.SQL_BIGINT;
                break;
            }
            case 5: {
                if (this.nodes[1].dataType == null) {
                    throw Error.error(5567);
                }
                if (!this.nodes[1].dataType.isDateTimeType() && !this.nodes[1].dataType.isIntervalType()) {
                    throw Error.error(5563);
                }
                int part = ((Number)this.nodes[0].valueData).intValue();
                DTIType type = (DTIType)this.nodes[1].dataType;
                part = DTIType.getFieldNameTypeForToken(part);
                this.dataType = type.getExtractType(part);
                break;
            }
            case 6: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_BIT_VARYING_MAX_LENGTH;
                }
                if (!this.nodes[0].dataType.isCharacterType() && !this.nodes[0].dataType.isBinaryType()) {
                    throw Error.error(5563);
                }
                this.dataType = Type.SQL_BIGINT;
                break;
            }
            case 7: {
                if (!this.nodes[0].dataType.isCharacterType()) {
                    throw Error.error(5563);
                }
            }
            case 8: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR;
                }
                if (!this.nodes[0].dataType.isCharacterType() && !this.nodes[0].dataType.isBinaryType()) {
                    throw Error.error(5563);
                }
                this.dataType = Type.SQL_BIGINT;
                break;
            }
            case 9: {
                if (this.nodes[0].dataType == null) {
                    throw Error.error(5567);
                }
                if (!this.nodes[0].dataType.isArrayType()) {
                    throw Error.error(5563);
                }
                this.dataType = Type.SQL_INTEGER;
                break;
            }
            case 10: {
                if (this.nodes[0].dataType == null) {
                    throw Error.error(5567);
                }
                if (!this.nodes[0].dataType.isArrayType()) {
                    throw Error.error(5563);
                }
                this.dataType = Type.SQL_INTEGER;
                break;
            }
            case 11: {
                if (this.nodes[0].dataType == null) {
                    throw Error.error(5567);
                }
                if (!this.nodes[0].dataType.isArrayType()) {
                    throw Error.error(5563);
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_INTEGER;
                }
                if (!this.nodes[1].dataType.isIntegralType()) {
                    throw Error.error(5563);
                }
                this.dataType = this.nodes[0].dataType;
                break;
            }
            case 13: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = this.nodes[1].dataType;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = this.nodes[0].dataType;
                }
                if (this.nodes[0].dataType == null) {
                    throw Error.error(5567);
                }
                if (!this.nodes[0].dataType.isNumberType() || !this.nodes[1].dataType.isNumberType()) {
                    throw Error.error(5563);
                }
                this.nodes[0].dataType = ((NumberType)this.nodes[0].dataType).getIntegralType();
                this.dataType = this.nodes[1].dataType = ((NumberType)this.nodes[1].dataType).getIntegralType();
                break;
            }
            case 16: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = this.nodes[1].dataType;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = this.nodes[0].dataType;
                }
                if (this.nodes[0].dataType == null) {
                    throw Error.error(5567);
                }
                if (!this.nodes[0].dataType.isNumberType() || !this.nodes[1].dataType.isNumberType()) {
                    throw Error.error(5563);
                }
                this.nodes[0].dataType = Type.SQL_DOUBLE;
                this.nodes[1].dataType = Type.SQL_DOUBLE;
                this.dataType = Type.SQL_DOUBLE;
                break;
            }
            case 14: 
            case 15: 
            case 17: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_DOUBLE;
                }
                if (!this.nodes[0].dataType.isNumberType()) {
                    throw Error.error(5563);
                }
                this.nodes[0].dataType = Type.SQL_DOUBLE;
                this.dataType = Type.SQL_DOUBLE;
                break;
            }
            case 12: {
                if (this.nodes[0].dataType != null && this.nodes[0].dataType.isIntervalType()) {
                    this.dataType = this.nodes[0].dataType;
                    break;
                }
            }
            case 20: 
            case 21: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_DOUBLE;
                }
                if (!this.nodes[0].dataType.isNumberType()) {
                    throw Error.error(5563);
                }
                this.dataType = this.nodes[0].dataType;
                if (this.dataType.typeCode != 3 && this.dataType.typeCode != 2 || this.dataType.scale <= 0) break;
                this.dataType = NumberType.getNumberType(this.dataType.typeCode, this.dataType.precision + 1L, 0);
                break;
            }
            case 22: {
                if (this.nodes[0].dataType == null || this.nodes[1].dataType == null || this.nodes[2].dataType == null || this.nodes[3].dataType == null) {
                    throw Error.error(5567);
                }
                if (!(this.nodes[0].dataType.isNumberType() && this.nodes[1].dataType.isNumberType() && this.nodes[2].dataType.isNumberType() && this.nodes[3].dataType.isIntegralType())) {
                    throw Error.error(5563);
                }
                this.dataType = this.nodes[3].dataType;
                break;
            }
            case 23: 
            case 40: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = Type.SQL_NUMERIC;
                }
                if (!this.nodes[1].dataType.isNumberType()) {
                    throw Error.error(5563);
                }
                if (this.nodes[2] != null) {
                    if (this.nodes[2].dataType == null) {
                        this.nodes[2].dataType = Type.SQL_NUMERIC;
                    }
                    if (!this.nodes[2].dataType.isNumberType()) {
                        throw Error.error(5563);
                    }
                    this.nodes[2].dataType = ((NumberType)this.nodes[2].dataType).getIntegralType();
                }
                this.dataType = this.nodes[0].dataType;
                if (this.dataType.isCharacterType()) {
                    this.funcType = 23;
                    if (this.dataType.typeCode == 1) {
                        this.dataType = CharacterType.getCharacterType(12, this.dataType.precision);
                    }
                } else if (this.dataType.isBinaryType()) {
                    this.funcType = 40;
                } else {
                    throw Error.error(5563);
                }
                if (this.nodes.length <= 3 || this.nodes[3] == null) break;
                break;
            }
            case 26: 
            case 27: {
                if (this.nodes[0].dataType == null) {
                    this.nodes[0].dataType = Type.SQL_VARCHAR_DEFAULT;
                }
                this.dataType = this.nodes[0].dataType;
                if (this.dataType.isCharacterType()) break;
                throw Error.error(5563);
            }
            case 31: 
            case 41: {
                if (this.nodes[0] == null) {
                    this.nodes[0] = new ExpressionValue(ValuePool.getInt(23), Type.SQL_INTEGER);
                }
                if (this.nodes[2].dataType == null) {
                    throw Error.error(5567);
                }
                this.dataType = this.nodes[2].dataType;
                if (this.dataType.isCharacterType()) {
                    this.funcType = 31;
                    if (this.dataType.typeCode == 1) {
                        this.dataType = CharacterType.getCharacterType(12, this.dataType.precision);
                    }
                    if (this.nodes[1] != null) break;
                    this.nodes[1] = new ExpressionValue(" ", Type.SQL_CHAR);
                    break;
                }
                if (this.dataType.isBinaryType()) {
                    this.funcType = 41;
                    if (this.nodes[1] != null) break;
                    this.nodes[1] = new ExpressionValue(new BinaryData(new byte[]{0}, false), Type.SQL_BINARY);
                    break;
                }
                throw Error.error(5563);
            }
            case 32: 
            case 42: {
                if (this.nodes[0].dataType == null) {
                    if (this.nodes[1].dataType == null) {
                        this.nodes[0].dataType = this.nodes[1].dataType = Type.SQL_VARCHAR_DEFAULT;
                    }
                    this.nodes[0].dataType = this.nodes[1].dataType.typeCode == 40 || this.nodes[1].dataType.isBinaryType() ? this.nodes[1].dataType : Type.SQL_VARCHAR_DEFAULT;
                }
                if (this.nodes[1].dataType == null) {
                    this.nodes[1].dataType = this.nodes[0].dataType.typeCode == 40 || this.nodes[0].dataType.isBinaryType() ? this.nodes[0].dataType : Type.SQL_VARCHAR_DEFAULT;
                }
                if (this.nodes[0].dataType.isCharacterType() && this.nodes[1].dataType.isCharacterType()) {
                    this.funcType = 32;
                    this.dataType = this.nodes[0].dataType.typeCode == 40 || this.nodes[1].dataType.typeCode == 40 ? CharacterType.getCharacterType(40, this.nodes[0].dataType.precision + this.nodes[1].dataType.precision) : CharacterType.getCharacterType(12, this.nodes[0].dataType.precision + this.nodes[1].dataType.precision);
                } else if (this.nodes[0].dataType.isBinaryType() && this.nodes[1].dataType.isBinaryType()) {
                    this.funcType = 42;
                    this.dataType = this.nodes[0].dataType.typeCode == 30 || this.nodes[1].dataType.typeCode == 30 ? BinaryType.getBinaryType(30, this.nodes[0].dataType.precision + this.nodes[1].dataType.precision) : BinaryType.getBinaryType(61, this.nodes[0].dataType.precision + this.nodes[1].dataType.precision);
                } else {
                    throw Error.error(5563);
                }
                if (this.nodes[2].dataType == null) {
                    this.nodes[2].dataType = Type.SQL_NUMERIC;
                }
                if (!this.nodes[2].dataType.isNumberType()) {
                    throw Error.error(5563);
                }
                this.nodes[2].dataType = ((NumberType)this.nodes[2].dataType).getIntegralType();
                if (this.nodes[3] == null) break;
                if (this.nodes[3].dataType == null) {
                    this.nodes[3].dataType = Type.SQL_NUMERIC;
                }
                if (!this.nodes[3].dataType.isNumberType()) {
                    throw Error.error(5563);
                }
                this.nodes[3].dataType = ((NumberType)this.nodes[3].dataType).getIntegralType();
                break;
            }
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                this.dataType = TypeInvariants.SQL_IDENTIFIER;
                break;
            }
            case 63: {
                break;
            }
            case 43: {
                this.dataType = CharacterType.SQL_DATE;
                break;
            }
            case 44: {
                int precision = 0;
                if (this.nodes[0] != null) {
                    precision = (Integer)this.nodes[0].valueData;
                }
                this.dataType = DateTimeType.getDateTimeType(94, precision);
                break;
            }
            case 50: {
                int precision = 6;
                if (this.nodes.length > 0 && this.nodes[0] != null) {
                    precision = (Integer)this.nodes[0].valueData;
                }
                this.dataType = DateTimeType.getDateTimeType(95, precision);
                break;
            }
            case 51: {
                int precision = 0;
                if (this.nodes.length > 0 && this.nodes[0] != null) {
                    precision = (Integer)this.nodes[0].valueData;
                }
                this.dataType = DateTimeType.getDateTimeType(92, precision);
                break;
            }
            case 52: {
                int precision = 6;
                if (this.nodes.length > 0 && this.nodes[0] != null) {
                    precision = (Integer)this.nodes[0].valueData;
                }
                this.dataType = DateTimeType.getDateTimeType(93, precision);
                break;
            }
            default: {
                throw Error.runtimeError(201, "FunctionSQL");
            }
        }
    }

    public String getSQL() {
        StringBuffer sb = new StringBuffer();
        switch (this.funcType) {
            case 1: 
            case 2: {
                sb.append("POSITION").append('(').append(this.nodes[0].getSQL()).append(' ').append("IN").append(' ').append(this.nodes[1].getSQL());
                if (this.nodes[2] != null && Boolean.TRUE.equals(this.nodes[2].valueData)) {
                    sb.append(' ').append("USING").append(' ').append("OCTETS");
                }
                sb.append(')');
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                int type = (Integer)this.nodes[0].valueData;
                type = DTIType.getFieldNameTypeForToken(type);
                String token = DTIType.getFieldNameTokenForType(type);
                sb.append("EXTRACT").append('(').append(token).append(' ').append("FROM").append(' ').append(this.nodes[1].getSQL()).append(')');
                break;
            }
            case 7: {
                sb.append("CHAR_LENGTH").append('(').append(this.nodes[0].getSQL()).append(')');
                break;
            }
            case 6: {
                sb.append("BIT_LENGTH").append('(').append(this.nodes[0].getSQL()).append(')');
                break;
            }
            case 8: {
                sb.append("OCTET_LENGTH").append('(').append(this.nodes[0].getSQL()).append(')');
                break;
            }
            case 9: {
                sb.append("CARDINALITY").append('(').append(this.nodes[0].getSQL()).append(')');
                break;
            }
            case 10: {
                sb.append("MAX_CARDINALITY").append('(').append(this.nodes[0].getSQL()).append(')');
                break;
            }
            case 11: {
                sb.append("TRIM_ARRAY").append('(').append(this.nodes[0].getSQL()).append(',').append(this.nodes[1].getSQL()).append(')');
                break;
            }
            case 12: {
                sb.append("ABS").append('(').append(this.nodes[0].getSQL()).append(')');
                break;
            }
            case 13: {
                sb.append("MOD").append('(').append(this.nodes[0].getSQL()).append(',').append(this.nodes[1].getSQL()).append(')');
                break;
            }
            case 14: {
                sb.append("LN").append('(').append(this.nodes[0].getSQL()).append(')');
                break;
            }
            case 15: {
                sb.append("EXP").append('(').append(this.nodes[0].getSQL()).append(')');
                break;
            }
            case 16: {
                sb.append("POWER").append('(').append(this.nodes[0].getSQL()).append(',').append(this.nodes[1].getSQL()).append(')');
                break;
            }
            case 17: {
                sb.append("SQRT").append('(').append(this.nodes[0].getSQL()).append(')');
                break;
            }
            case 20: {
                sb.append("FLOOR").append('(').append(this.nodes[0].getSQL()).append(')');
                break;
            }
            case 21: {
                sb.append("CEILING").append('(').append(this.nodes[0].getSQL()).append(')');
                break;
            }
            case 22: {
                sb.append("WIDTH_BUCKET").append('(').append(this.nodes[0].getSQL()).append(',').append(this.nodes[1].getSQL()).append(',').append(this.nodes[2].getSQL()).append(',').append(this.nodes[3].getSQL()).append(')');
                break;
            }
            case 23: 
            case 40: {
                sb.append("SUBSTRING").append('(').append(this.nodes[0].getSQL()).append(' ').append("FROM").append(' ').append(this.nodes[1].getSQL());
                if (this.nodes[2] != null) {
                    sb.append(' ').append("FOR").append(' ').append(this.nodes[2].getSQL());
                }
                if (this.nodes.length > 3 && this.nodes[3] != null && Boolean.TRUE.equals(this.nodes[3].valueData)) {
                    sb.append(' ').append("USING").append(' ').append("OCTETS");
                }
                sb.append(')');
                break;
            }
            case 26: {
                sb.append("LOWER").append('(').append(this.nodes[0].getSQL()).append(')');
                break;
            }
            case 27: {
                sb.append("UPPER").append('(').append(this.nodes[0].getSQL()).append(')');
                break;
            }
            case 32: 
            case 42: {
                sb.append("OVERLAY").append('(').append(this.nodes[0].getSQL()).append(' ').append("PLACING").append(' ').append(this.nodes[1].getSQL()).append(' ').append("FROM").append(' ').append(this.nodes[2].getSQL());
                if (this.nodes[3] != null) {
                    sb.append(' ').append("FOR").append(' ').append(this.nodes[3].getSQL());
                }
                if (this.nodes[4] != null && Boolean.TRUE.equals(this.nodes[4].valueData)) {
                    sb.append(' ').append("USING").append(' ').append("OCTETS");
                }
                sb.append(')');
                break;
            }
            case 31: 
            case 41: {
                String spec = null;
                switch (((Number)this.nodes[0].valueData).intValue()) {
                    case 23: {
                        spec = "BOTH";
                        break;
                    }
                    case 151: {
                        spec = "LEADING";
                        break;
                    }
                    case 286: {
                        spec = "TRAILING";
                    }
                }
                sb.append("TRIM").append('(').append(spec).append(' ').append(this.nodes[1].getSQL()).append(' ').append("FROM").append(' ').append(this.nodes[2].getSQL()).append(')');
                break;
            }
            case 43: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                return this.name;
            }
            case 44: 
            case 51: {
                int precision = 0;
                if (this.nodes.length > 0 && this.nodes[0] != null) {
                    precision = ((Number)this.nodes[0].valueData).intValue();
                }
                if (precision == 0) {
                    return this.name;
                }
                sb.append(this.name).append("(").append(precision);
                sb.append(")");
                return sb.toString();
            }
            case 50: 
            case 52: {
                int precision = 6;
                if (this.nodes.length > 0 && this.nodes[0] != null) {
                    precision = ((Number)this.nodes[0].valueData).intValue();
                }
                if (precision == 6) {
                    return this.name;
                }
                sb.append(this.name).append("(").append(precision);
                sb.append(")");
                return sb.toString();
            }
            default: {
                throw Error.runtimeError(201, "FunctionSQL");
            }
        }
        return sb.toString();
    }

    public boolean equals(Expression other) {
        if (other instanceof FunctionSQL && this.funcType == ((FunctionSQL)other).funcType) {
            return super.equals(other);
        }
        return false;
    }

    public int hashCode() {
        return this.opType + this.funcType;
    }

    public String describe(Session session, int blanks) {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append('\n');
        for (i = 0; i < blanks; ++i) {
            sb.append(' ');
        }
        sb.append("FUNCTION ").append("=[\n");
        sb.append(this.name).append("(");
        for (i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            sb.append("[").append(this.nodes[i].describe(session, blanks)).append("]");
        }
        sb.append(") returns ").append(this.dataType.getNameString());
        sb.append("]\n");
        return sb.toString();
    }

    public boolean isDeterministic() {
        return this.isDeterministic;
    }

    public boolean isValueFunction() {
        return this.isSQLValueFunction;
    }

    static {
        regularFuncMap.put("POSITION", 1);
        regularFuncMap.put("POSITION_REGEX", 4);
        regularFuncMap.put("EXTRACT", 5);
        regularFuncMap.put("BIT_LENGTH", 6);
        regularFuncMap.put("CHAR_LENGTH", 7);
        regularFuncMap.put("CHARACTER_LENGTH", 7);
        regularFuncMap.put("OCTET_LENGTH", 8);
        regularFuncMap.put("CARDINALITY", 9);
        regularFuncMap.put("MAX_CARDINALITY", 10);
        regularFuncMap.put("TRIM_ARRAY", 11);
        regularFuncMap.put("ABS", 12);
        regularFuncMap.put("MOD", 13);
        regularFuncMap.put("LN", 14);
        regularFuncMap.put("EXP", 15);
        regularFuncMap.put("POWER", 16);
        regularFuncMap.put("SQRT", 17);
        regularFuncMap.put("FLOOR", 20);
        regularFuncMap.put("CEILING", 21);
        regularFuncMap.put("CEIL", 21);
        regularFuncMap.put("WIDTH_BUCKET", 22);
        regularFuncMap.put("SUBSTRING", 23);
        regularFuncMap.put("SUBSTRING_REGEX", 25);
        regularFuncMap.put("LOWER", 26);
        regularFuncMap.put("UPPER", 27);
        regularFuncMap.put("TRIM", 31);
        regularFuncMap.put("OVERLAY", 32);
        regularFuncMap.put("TRIM", 41);
        valueFuncMap.put("CURRENT_DATE", 43);
        valueFuncMap.put("CURRENT_TIME", 44);
        valueFuncMap.put("CURRENT_TIMESTAMP", 50);
        valueFuncMap.put("LOCALTIME", 51);
        valueFuncMap.put("LOCALTIMESTAMP", 52);
        valueFuncMap.put("CURRENT_CATALOG", 53);
        valueFuncMap.put("CURRENT_PATH", 55);
        valueFuncMap.put("CURRENT_ROLE", 56);
        valueFuncMap.put("CURRENT_SCHEMA", 57);
        valueFuncMap.put("CURRENT_USER", 59);
        valueFuncMap.put("SESSION_USER", 60);
        valueFuncMap.put("SYSTEM_USER", 61);
        valueFuncMap.put("USER", 62);
        valueFuncMap.put("VALUE", 63);
        nonDeterministicFuncSet.addAll(valueFuncMap.values());
    }
}

