/*
 * Decompiled with CFR 0.152.
 */
package net.oauth.signatures;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import java.net.URI;
import java.security.SignatureException;
import net.oauth.jsontoken.Checker;

public class SignedTokenAudienceChecker
implements Checker {
    private final String serverUri;

    public SignedTokenAudienceChecker(String uri) {
        this.serverUri = uri;
    }

    @Override
    public void check(JsonObject payload) throws SignatureException {
        SignedTokenAudienceChecker.checkUri(this.serverUri, (String)Preconditions.checkNotNull((Object)payload.get("aud").getAsString(), (Object)"Audience cannot be null!"));
    }

    private static void checkUri(String ourUriString, String tokenUriString) throws SignatureException {
        URI ourUri = URI.create(ourUriString);
        URI tokenUri = URI.create(tokenUriString);
        if (!ourUri.getScheme().equalsIgnoreCase(tokenUri.getScheme())) {
            throw new SignatureException("scheme in token URI (" + tokenUri.getScheme() + ") is wrong");
        }
        if (!ourUri.getAuthority().equalsIgnoreCase(tokenUri.getAuthority())) {
            throw new SignatureException("authority in token URI (" + tokenUri.getAuthority() + ") is wrong");
        }
        if (!Objects.equal((Object)ourUri.getPath(), (Object)tokenUri.getPath())) {
            throw new SignatureException("path in token URI (" + tokenUri.getAuthority() + ") is wrong");
        }
        if (!Objects.equal((Object)ourUri.getQuery(), (Object)tokenUri.getQuery())) {
            throw new SignatureException("query string in URI (" + tokenUri.getQuery() + ") is wrong");
        }
    }
}

