/*
 * Decompiled with CFR 0.152.
 */
package org.outerj.daisy.diff.html.dom;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.outerj.daisy.diff.html.ancestor.TextOnlyComparator;
import org.outerj.daisy.diff.html.dom.Node;
import org.outerj.daisy.diff.html.dom.WhiteSpaceNode;
import org.outerj.daisy.diff.html.dom.helper.AttributesMap;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagNode
extends Node
implements Iterable<Node> {
    private List<Node> children = new ArrayList<Node>();
    private String qName;
    private final Attributes attributes;
    private IdentityHashMap<Attributes, Boolean> attributesEqualityTests = new IdentityHashMap();
    private static Set<String> blocks = new HashSet<String>();

    public TagNode(TagNode tagNode, String string, Attributes attributes) {
        super(tagNode);
        this.qName = string;
        this.attributes = new AttributesImpl(attributes);
    }

    public void addChild(Node node) {
        if (node.getParent() != this) {
            throw new IllegalStateException("The new child must have this node as a parent.");
        }
        this.children.add(node);
    }

    @Override
    protected void setRoot(TagNode tagNode) {
        super.setRoot(tagNode);
        for (Node node : this.children) {
            node.setRoot(tagNode);
        }
    }

    public int getIndexOf(Node node) {
        return this.children.indexOf(node);
    }

    public void addChild(int n, Node node) {
        if (node.getParent() != this) {
            throw new IllegalStateException("The new child must have this node as a parent.");
        }
        this.children.add(n, node);
    }

    public Node getChild(int n) {
        return this.children.get(n);
    }

    @Override
    public Iterator<Node> iterator() {
        return this.children.iterator();
    }

    public int getNbChildren() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    public String getQName() {
        return this.qName;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public boolean isSameTag(TagNode tagNode) {
        if (tagNode == null) {
            return false;
        }
        return this.equals(tagNode);
    }

    public boolean equals(Object object) {
        if (!(object instanceof TagNode)) {
            return false;
        }
        return this.equals((TagNode)object);
    }

    private boolean equals(TagNode tagNode) {
        if (tagNode == this) {
            return true;
        }
        if (this.getRoot() == tagNode.getRoot()) {
            return false;
        }
        return this.isSimilarTag(tagNode);
    }

    private boolean hasSameAttributes(Attributes attributes) {
        if (attributes == null) {
            return false;
        }
        if (this.attributesEqualityTests.get(attributes) != null) {
            return this.attributesEqualityTests.get(attributes);
        }
        boolean bl = this.getAttributesMap().hasSameAttributes(attributes);
        this.attributesEqualityTests.put(attributes, bl);
        return bl;
    }

    private AttributesMap getAttributesMap() {
        return new AttributesMap(this.getAttributes());
    }

    protected boolean isSimilarTag(Node node) {
        boolean bl = false;
        if (node instanceof TagNode) {
            TagNode tagNode = (TagNode)node;
            if (this.getQName().equalsIgnoreCase(tagNode.getQName())) {
                bl = this.hasSameAttributes(tagNode.getAttributes());
            }
        }
        return bl;
    }

    public int hashCode() {
        int n = this.getQName().hashCode();
        AttributesMap attributesMap = this.getAttributesMap();
        n = n * 29 + attributesMap.hashCode();
        return n;
    }

    public String getOpeningTag() {
        String string = "<" + this.getQName();
        Attributes attributes = this.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            string = string + " " + attributes.getQName(i) + "=\"" + attributes.getValue(i) + "\"";
        }
        string = string + ">";
        return string;
    }

    public String getEndTag() {
        return "</" + this.getQName() + ">";
    }

    @Override
    public List<Node> getMinimalDeletedSet(long l) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        if (this.children.size() == 0) {
            return arrayList;
        }
        boolean bl = false;
        for (Node node : this) {
            List<Node> list = node.getMinimalDeletedSet(l);
            arrayList.addAll(list);
            if (bl || list.size() == 1 && list.contains(node)) continue;
            bl = true;
        }
        if (!bl) {
            arrayList.clear();
            arrayList.add(this);
        }
        return arrayList;
    }

    public String toString() {
        return this.getOpeningTag();
    }

    public boolean splitUntill(TagNode tagNode, Node node, boolean bl) {
        boolean bl2 = false;
        if (tagNode != this) {
            int n;
            TagNode tagNode2 = new TagNode(null, this.getQName(), this.getAttributes());
            TagNode tagNode3 = new TagNode(null, this.getQName(), this.getAttributes());
            tagNode2.setParent(this.getParent());
            tagNode3.setParent(this.getParent());
            for (n = 0; n < this.children.size() && this.children.get(n) != node; ++n) {
                this.children.get(n).setParent(tagNode2);
                tagNode2.addChild(this.children.get(n));
            }
            if (n < this.children.size()) {
                if (bl) {
                    this.children.get(n).setParent(tagNode2);
                    tagNode2.addChild(this.children.get(n));
                } else {
                    this.children.get(n).setParent(tagNode3);
                    tagNode3.addChild(this.children.get(n));
                }
                ++n;
            }
            while (n < this.children.size()) {
                this.children.get(n).setParent(tagNode3);
                tagNode3.addChild(this.children.get(n));
                ++n;
            }
            if (tagNode2.getNbChildren() > 0) {
                this.getParent().addChild(this.getParent().getIndexOf(this), tagNode2);
            }
            if (tagNode3.getNbChildren() > 0) {
                this.getParent().addChild(this.getParent().getIndexOf(this), tagNode3);
            }
            if (tagNode2.getNbChildren() > 0 && tagNode3.getNbChildren() > 0) {
                bl2 = true;
            }
            this.getParent().removeChild(this);
            if (bl) {
                this.getParent().splitUntill(tagNode, tagNode2, bl);
            } else {
                this.getParent().splitUntill(tagNode, tagNode3, bl);
            }
        }
        return bl2;
    }

    private void removeChild(Node node) {
        this.children.remove(node);
    }

    public static boolean isBlockLevel(String string) {
        return blocks.contains(string.toLowerCase());
    }

    public static boolean isBlockLevel(Node node) {
        try {
            TagNode tagNode = (TagNode)node;
            return TagNode.isBlockLevel(tagNode.getQName());
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public boolean isBlockLevel() {
        return TagNode.isBlockLevel(this);
    }

    public static boolean isInline(String string) {
        return !TagNode.isBlockLevel(string);
    }

    public static boolean isInline(Node node) {
        return !TagNode.isBlockLevel(node);
    }

    public boolean isInline() {
        return TagNode.isInline(this);
    }

    @Override
    public Node copyTree() {
        TagNode tagNode = new TagNode(null, this.getQName(), new AttributesImpl(this.getAttributes()));
        tagNode.setWhiteBefore(this.isWhiteBefore());
        tagNode.setWhiteAfter(this.isWhiteAfter());
        for (Node node : this) {
            Node node2 = node.copyTree();
            node2.setParent(tagNode);
            tagNode.addChild(node2);
        }
        return tagNode;
    }

    public double getMatchRatio(TagNode tagNode) {
        TextOnlyComparator textOnlyComparator = new TextOnlyComparator(tagNode);
        return textOnlyComparator.getMatchRatio(new TextOnlyComparator(this));
    }

    public void expandWhiteSpace() {
        int n = 0;
        boolean bl = false;
        int n2 = this.getNbChildren();
        for (int i = 0; i < n2; ++i) {
            Node node;
            Node node2 = this.getChild(i + n);
            try {
                node = (TagNode)node2;
                if (!((TagNode)node).isPre()) {
                    ((TagNode)node).expandWhiteSpace();
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
            if (!bl && node2.isWhiteBefore()) {
                node = new WhiteSpaceNode(null, " ", node2.getLeftMostChild());
                node.setParent(this);
                this.addChild(i + n++, node);
            }
            if (node2.isWhiteAfter()) {
                node = new WhiteSpaceNode(null, " ", node2.getRightMostChild());
                node.setParent(this);
                this.addChild(i + 1 + n++, node);
                bl = true;
                continue;
            }
            bl = false;
        }
    }

    @Override
    public Node getLeftMostChild() {
        if (this.getNbChildren() < 1) {
            return this;
        }
        Node node = this.getChild(0);
        return node.getLeftMostChild();
    }

    @Override
    public Node getRightMostChild() {
        if (this.getNbChildren() < 1) {
            return this;
        }
        Node node = this.getChild(this.getNbChildren() - 1);
        return node.getRightMostChild();
    }

    public boolean isPre() {
        return this.getQName().equalsIgnoreCase("pre");
    }

    static {
        blocks.add("html");
        blocks.add("body");
        blocks.add("p");
        blocks.add("blockquote");
        blocks.add("h1");
        blocks.add("h2");
        blocks.add("h3");
        blocks.add("h4");
        blocks.add("h5");
        blocks.add("pre");
        blocks.add("div");
        blocks.add("ul");
        blocks.add("ol");
        blocks.add("li");
        blocks.add("table");
        blocks.add("tbody");
        blocks.add("tr");
        blocks.add("td");
        blocks.add("th");
        blocks.add("br");
        blocks.add("thead");
        blocks.add("tfoot");
    }
}

