/*
 * Decompiled with CFR 0.152.
 */
package org.jabsorb;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jabsorb.serializer.MarshallException;
import org.jabsorb.serializer.ObjectMatch;
import org.jabsorb.serializer.ProcessedObject;
import org.jabsorb.serializer.Serializer;
import org.jabsorb.serializer.SerializerState;
import org.jabsorb.serializer.UnmarshallException;
import org.jabsorb.serializer.impl.ArraySerializer;
import org.jabsorb.serializer.impl.BeanSerializer;
import org.jabsorb.serializer.impl.BooleanSerializer;
import org.jabsorb.serializer.impl.DateSerializer;
import org.jabsorb.serializer.impl.DictionarySerializer;
import org.jabsorb.serializer.impl.ListSerializer;
import org.jabsorb.serializer.impl.MapSerializer;
import org.jabsorb.serializer.impl.NumberSerializer;
import org.jabsorb.serializer.impl.PrimitiveSerializer;
import org.jabsorb.serializer.impl.RawJSONArraySerializer;
import org.jabsorb.serializer.impl.RawJSONObjectSerializer;
import org.jabsorb.serializer.impl.SetSerializer;
import org.jabsorb.serializer.impl.StringSerializer;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONSerializer
implements Serializable {
    private static final long serialVersionUID = 2L;
    private static final Logger log = LoggerFactory.getLogger((Class)JSONSerializer.class);
    private Set serializerSet = new HashSet();
    private transient Map serializableMap = null;
    private List serializerList = new ArrayList();
    private boolean marshallClassHints = true;
    private boolean marshallNullAttributes = true;
    private boolean fixupCircRefs = true;
    private boolean fixupDuplicates = true;
    private boolean fixupDuplicatePrimitives = false;
    protected static Class[] duplicatePrimitiveTypes = new Class[]{String.class, Integer.class, Boolean.class, Long.class, Byte.class, Double.class, Float.class, Short.class};
    public static final Object CIRC_REF_OR_DUPLICATE = new Object();

    public boolean isPrimitive(Object o) {
        if (o == null) {
            return true;
        }
        Class<?> c = o.getClass();
        int j = duplicatePrimitiveTypes.length;
        for (int i = 0; i < j; ++i) {
            if (duplicatePrimitiveTypes[i] != c) continue;
            return true;
        }
        return false;
    }

    public boolean getFixupCircRefs() {
        return this.fixupCircRefs;
    }

    public void setFixupCircRefs(boolean fixupCircRefs) {
        this.fixupCircRefs = fixupCircRefs;
    }

    public boolean getFixupDuplicates() {
        return this.fixupDuplicates;
    }

    public void setFixupDuplicates(boolean fixupDuplicates) {
        this.fixupDuplicates = fixupDuplicates;
    }

    public boolean getFixupDuplicatePrimitives() {
        return this.fixupDuplicatePrimitives;
    }

    public void setFixupDuplicatePrimitives(boolean fixupDuplicatePrimitives) {
        this.fixupDuplicatePrimitives = fixupDuplicatePrimitives;
    }

    public Object fromJSON(String jsonString) throws UnmarshallException {
        Object json;
        JSONTokener tok = new JSONTokener(jsonString);
        try {
            json = tok.nextValue();
        }
        catch (JSONException e) {
            throw new UnmarshallException("couldn't parse JSON", e);
        }
        SerializerState state = new SerializerState();
        return this.unmarshall(state, null, json);
    }

    public boolean getMarshallClassHints() {
        return this.marshallClassHints;
    }

    public boolean getMarshallNullAttributes() {
        return this.marshallNullAttributes;
    }

    public Object marshall(SerializerState state, Object parent, Object java, Object ref) throws MarshallException {
        if (java == null) {
            if (log.isDebugEnabled()) {
                log.debug("marshall null");
            }
            return JSONObject.NULL;
        }
        ProcessedObject p = state.getProcessedObject(java);
        if (p == null) {
            state.push(parent, java, ref);
        } else {
            boolean foundCircRef = state.isAncestor(p, parent);
            if (!this.fixupCircRefs && foundCircRef) {
                throw new MarshallException("Circular Reference");
            }
            if (!foundCircRef && (!this.fixupDuplicates || !this.fixupDuplicatePrimitives && this.isPrimitive(java))) {
                state.push(parent, java, ref);
            } else {
                state.addFixUp(p.getLocation(), ref);
                return CIRC_REF_OR_DUPLICATE;
            }
        }
        try {
            Serializer s;
            if (log.isDebugEnabled()) {
                log.debug("marshall class " + java.getClass().getName());
            }
            if ((s = this.getSerializer(java.getClass(), null)) != null) {
                Object object = s.marshall(state, parent, java);
                return object;
            }
            throw new MarshallException("can't marshall " + java.getClass().getName());
        }
        finally {
            state.pop();
        }
    }

    public void registerDefaultSerializers() throws Exception {
        this.registerSerializer(new RawJSONArraySerializer());
        this.registerSerializer(new RawJSONObjectSerializer());
        this.registerSerializer(new BeanSerializer());
        this.registerSerializer(new ArraySerializer());
        this.registerSerializer(new DictionarySerializer());
        this.registerSerializer(new MapSerializer());
        this.registerSerializer(new SetSerializer());
        this.registerSerializer(new ListSerializer());
        this.registerSerializer(new DateSerializer());
        this.registerSerializer(new StringSerializer());
        this.registerSerializer(new NumberSerializer());
        this.registerSerializer(new BooleanSerializer());
        this.registerSerializer(new PrimitiveSerializer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSerializer(Serializer s) throws Exception {
        Class[] classes = s.getSerializableClasses();
        Set set = this.serializerSet;
        synchronized (set) {
            if (this.serializableMap == null) {
                this.serializableMap = new HashMap();
            }
            for (int i = 0; i < classes.length; ++i) {
                Serializer exists = (Serializer)this.serializableMap.get(classes[i]);
                if (exists == null || exists.getClass() == s.getClass()) continue;
                throw new Exception("different serializer already registered for " + classes[i].getName());
            }
            if (!this.serializerSet.contains(s)) {
                if (log.isDebugEnabled()) {
                    log.debug("registered serializer " + s.getClass().getName());
                }
                s.setOwner(this);
                this.serializerSet.add(s);
                this.serializerList.add(0, s);
                for (int j = 0; j < classes.length; ++j) {
                    this.serializableMap.put(classes[j], s);
                }
            }
        }
    }

    public void setMarshallClassHints(boolean marshallClassHints) {
        this.marshallClassHints = marshallClassHints;
    }

    public void setMarshallNullAttributes(boolean marshallNullAttributes) {
        this.marshallNullAttributes = marshallNullAttributes;
    }

    public String toJSON(Object obj) throws MarshallException {
        SerializerState state = new SerializerState();
        Object json = this.marshall(state, null, obj, "result");
        return json.toString();
    }

    public ObjectMatch tryUnmarshall(SerializerState state, Class clazz, Object json) throws UnmarshallException {
        ProcessedObject p = state.getProcessedObject(json);
        if (p != null) {
            return (ObjectMatch)p.getSerialized();
        }
        p = state.store(json);
        if (clazz != null && json instanceof JSONObject && ((JSONObject)json).has("javaClass") && clazz.isAssignableFrom(this.getClassFromHint(json))) {
            clazz = this.getClassFromHint(json);
        }
        if (clazz == null) {
            clazz = this.getClassFromHint(json);
        }
        if (clazz == null) {
            throw new UnmarshallException("no class hint");
        }
        if (json == null || json == JSONObject.NULL) {
            if (!clazz.isPrimitive()) {
                return ObjectMatch.NULL;
            }
            throw new UnmarshallException("can't assign null primitive");
        }
        Serializer s = this.getSerializer(clazz, json.getClass());
        if (s != null) {
            return s.tryUnmarshall(state, clazz, json);
        }
        if (clazz.isInstance(json)) {
            return ObjectMatch.SIMILAR;
        }
        throw new UnmarshallException("no match");
    }

    public Object unmarshall(SerializerState state, Class clazz, Object json) throws UnmarshallException {
        ProcessedObject p = state.getProcessedObject(json);
        if (p != null) {
            return p.getSerialized();
        }
        p = state.store(json);
        if (clazz != null && json instanceof JSONObject && ((JSONObject)json).has("javaClass") && clazz.isAssignableFrom(this.getClassFromHint(json))) {
            clazz = this.getClassFromHint(json);
        }
        if (clazz == null) {
            clazz = this.getClassFromHint(json);
        }
        if (clazz == null) {
            throw new UnmarshallException("no class hint");
        }
        if (json == null || json == JSONObject.NULL) {
            if (!clazz.isPrimitive()) {
                return null;
            }
            throw new UnmarshallException("can't assign null primitive");
        }
        Class<?> jsonClass = json.getClass();
        Serializer s = this.getSerializer(clazz, jsonClass);
        if (s != null) {
            return s.unmarshall(state, clazz, json);
        }
        if (clazz.isInstance(json)) {
            return json;
        }
        throw new UnmarshallException("no serializer found that can unmarshall " + (jsonClass != null ? jsonClass.getName() : "null") + " to " + clazz.getName());
    }

    private Class getClassFromHint(Object o) throws UnmarshallException {
        if (o == null) {
            return null;
        }
        if (o instanceof JSONObject) {
            String className = "(unknown)";
            try {
                className = ((JSONObject)o).getString("javaClass");
                return Class.forName(className);
            }
            catch (Exception e) {
                throw new UnmarshallException("Class specified in javaClass hint not found: " + className, e);
            }
        }
        if (o instanceof JSONArray) {
            Class compClazz;
            JSONArray arr = (JSONArray)o;
            if (arr.length() == 0) {
                throw new UnmarshallException("no type for empty array");
            }
            try {
                compClazz = this.getClassFromHint(arr.get(0));
            }
            catch (JSONException e) {
                throw (NoSuchElementException)new NoSuchElementException(e.getMessage()).initCause(e);
            }
            try {
                if (compClazz.isArray()) {
                    return Class.forName("[" + compClazz.getName());
                }
                return Class.forName("[L" + compClazz.getName() + ";");
            }
            catch (ClassNotFoundException e) {
                throw new UnmarshallException("problem getting array type", e);
            }
        }
        return o.getClass();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Serializer getSerializer(Class clazz, Class jsoClazz) {
        if (log.isDebugEnabled()) {
            log.debug("looking for serializer - java:" + (clazz == null ? "null" : clazz.getName()) + " json:" + (jsoClazz == null ? "null" : jsoClazz.getName()));
        }
        Set set = this.serializerSet;
        synchronized (set) {
            Serializer s = (Serializer)this.serializableMap.get(clazz);
            if (s != null && s.canSerialize(clazz, jsoClazz)) {
                if (log.isDebugEnabled()) {
                    log.debug("direct match serializer " + s.getClass().getName());
                }
                return s;
            }
            Iterator i = this.serializerList.iterator();
            while (i.hasNext()) {
                s = (Serializer)i.next();
                if (!s.canSerialize(clazz, jsoClazz)) continue;
                if (log.isDebugEnabled()) {
                    log.debug("search found serializer " + s.getClass().getName());
                }
                return s;
            }
        }
        return null;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.serializableMap = new HashMap();
        Iterator i = this.serializerList.iterator();
        while (i.hasNext()) {
            Serializer s = (Serializer)i.next();
            Class[] classes = s.getSerializableClasses();
            for (int j = 0; j < classes.length; ++j) {
                this.serializableMap.put(classes[j], s);
            }
        }
    }
}

