/*
 * Decompiled with CFR 0.152.
 */
package com.artofsolving.jodconverter;

import com.artofsolving.jodconverter.DocumentFamily;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DocumentFormat {
    private static final String FILTER_NAME = "FilterName";
    private String name;
    private DocumentFamily family;
    private String mimeType;
    private String fileExtension;
    private Map exportOptions = new HashMap();
    private Map importOptions = new HashMap();

    public DocumentFormat() {
    }

    public DocumentFormat(String name, String mimeType, String extension) {
        this.name = name;
        this.mimeType = mimeType;
        this.fileExtension = extension;
    }

    public DocumentFormat(String name, DocumentFamily family, String mimeType, String extension) {
        this.name = name;
        this.family = family;
        this.mimeType = mimeType;
        this.fileExtension = extension;
    }

    public String getName() {
        return this.name;
    }

    public DocumentFamily getFamily() {
        return this.family;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    private String getExportFilter(DocumentFamily family) {
        return (String)this.getExportOptions(family).get(FILTER_NAME);
    }

    public boolean isImportable() {
        return this.family != null;
    }

    public boolean isExportOnly() {
        return !this.isImportable();
    }

    public boolean isExportableTo(DocumentFormat otherFormat) {
        return otherFormat.isExportableFrom(this.family);
    }

    public boolean isExportableFrom(DocumentFamily family) {
        return this.getExportFilter(family) != null;
    }

    public void setExportFilter(DocumentFamily family, String filter) {
        this.getExportOptions(family).put(FILTER_NAME, filter);
    }

    public void setExportOption(DocumentFamily family, String name, Object value) {
        HashMap<String, Object> options = (HashMap<String, Object>)this.exportOptions.get(family);
        if (options == null) {
            options = new HashMap<String, Object>();
            this.exportOptions.put(family, options);
        }
        options.put(name, value);
    }

    public Map getExportOptions(DocumentFamily family) {
        HashMap options = (HashMap)this.exportOptions.get(family);
        if (options == null) {
            options = new HashMap();
            this.exportOptions.put(family, options);
        }
        return options;
    }

    public void setImportOption(String name, Object value) {
        this.importOptions.put(name, value);
    }

    public Map getImportOptions() {
        if (this.importOptions != null) {
            return this.importOptions;
        }
        return Collections.EMPTY_MAP;
    }
}

