/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ecs;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import org.apache.ecs.Doctype;
import org.apache.ecs.Element;
import org.apache.ecs.html.Body;
import org.apache.ecs.html.FrameSet;
import org.apache.ecs.html.Head;
import org.apache.ecs.html.Html;
import org.apache.ecs.html.NoFrames;
import org.apache.ecs.html.Title;

public class FrameSetDocument
implements Serializable,
Cloneable {
    private Html html = new Html();
    private Head head = new Head();
    private Body body;
    private Title title = new Title();
    private FrameSet frameset = new FrameSet();
    private NoFrames noframes = new NoFrames();
    private Doctype doctype = null;
    private String codeset = null;

    public FrameSetDocument() {
        this.body = new Body();
        this.head.addElement("title", this.title);
        this.html.addElement("head", this.head);
        this.html.addElement("frameset", this.frameset);
        this.html.addElement("noframes", this.noframes);
        this.noframes.addElement("body", this.body);
    }

    public FrameSetDocument(String string) {
        this.body = new Body();
        this.head.addElement("title", this.title);
        this.html.addElement("head", this.head);
        this.html.addElement("frameset", this.frameset);
        this.html.addElement("noframes", this.noframes);
        this.noframes.addElement("body", this.body);
        this.setCodeset(string);
    }

    public FrameSetDocument appendBody(String string) {
        this.body.addElement(string);
        return this;
    }

    public FrameSetDocument appendBody(Element element) {
        this.body.addElement(element);
        return this;
    }

    public FrameSetDocument appendFrameSet(String string) {
        this.frameset.addElement(string);
        return this;
    }

    public FrameSetDocument appendFrameSet(Element element) {
        this.frameset.addElement(element);
        return this;
    }

    public FrameSetDocument appendHead(String string) {
        this.head.addElement(string);
        return this;
    }

    public FrameSetDocument appendHead(Element element) {
        this.head.addElement(element);
        return this;
    }

    public FrameSetDocument appendTitle(String string) {
        this.title.addElement(string);
        return this;
    }

    public FrameSetDocument appendTitle(Element element) {
        this.title.addElement(element);
        return this;
    }

    public Object clone() {
        return this.html.clone();
    }

    public Body getBody() {
        return this.body;
    }

    public String getCodeset() {
        return this.codeset;
    }

    public Doctype getDoctype() {
        return this.doctype;
    }

    public FrameSet getFrameSet() {
        return this.frameset;
    }

    public Head getHead() {
        return this.head;
    }

    public Html getHtml() {
        return this.html;
    }

    public Title getTitle() {
        return this.title;
    }

    public void output(OutputStream outputStream) {
        if (this.doctype != null) {
            this.doctype.output(outputStream);
            try {
                outputStream.write(10);
            }
            catch (Exception exception) {}
        }
        this.html.output(outputStream);
    }

    public void output(PrintWriter printWriter) {
        if (this.doctype != null) {
            this.doctype.output(printWriter);
            try {
                printWriter.write(10);
            }
            catch (Exception exception) {}
        }
        this.html.output(printWriter);
    }

    public FrameSetDocument setBody(Body body2) {
        this.noframes.addElement("body", body2);
        this.body = body2;
        return this;
    }

    public void setCodeset(String string) {
        this.codeset = string;
    }

    public FrameSetDocument setDoctype(Doctype doctype) {
        this.doctype = doctype;
        return this;
    }

    public FrameSetDocument setFrameSet(FrameSet frameSet) {
        this.html.addElement("frameset", frameSet);
        this.frameset = frameSet;
        return this;
    }

    public FrameSetDocument setHead(Head head2) {
        this.html.addElement("head", head2);
        this.head = head2;
        return this;
    }

    public FrameSetDocument setHtml(Html html2) {
        this.html = html2;
        return this;
    }

    public FrameSetDocument setTitle(Title title2) {
        this.head.addElement("title", title2);
        this.title = title2;
        return this;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getCodeset() != null) {
            if (this.doctype != null) {
                stringBuffer.append(this.doctype.toString(this.getCodeset()));
            }
            stringBuffer.append(this.html.toString(this.getCodeset()));
            return stringBuffer.toString();
        }
        if (this.doctype != null) {
            stringBuffer.append(this.doctype.toString());
        }
        stringBuffer.append(this.html.toString());
        return stringBuffer.toString();
    }

    public final String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.doctype != null) {
            stringBuffer.append(this.doctype.toString(this.getCodeset()));
        }
        stringBuffer.append(this.html.toString(this.getCodeset()));
        return stringBuffer.toString();
    }
}

