/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.message;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import org.apache.james.mime4j.dom.SingleBody;
import org.apache.james.mime4j.dom.TextBody;
import org.apache.james.mime4j.message.StringInputStream;

class StringBody
extends TextBody {
    private final String content;
    private final Charset charset;

    StringBody(String content, Charset charset) {
        this.content = content;
        this.charset = charset;
    }

    public String getMimeCharset() {
        return this.charset.name();
    }

    public Reader getReader() throws IOException {
        return new StringReader(this.content);
    }

    public InputStream getInputStream() throws IOException {
        return new StringInputStream(this.content, this.charset, 2048);
    }

    public SingleBody copy() {
        return new StringBody(this.content, this.charset);
    }
}

