/*
 * Decompiled with CFR 0.152.
 */
package org.walluck.oscar.channel.rendezvous;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.walluck.oscar.AIMFrame;
import org.walluck.oscar.AIMInputStream;
import org.walluck.oscar.AIMOutputStream;
import org.walluck.oscar.AIMSession;
import org.walluck.oscar.IncomingIMCH2;
import org.walluck.oscar.SNAC;
import org.walluck.oscar.TLVChain;
import org.walluck.oscar.UserInfo;
import org.walluck.oscar.channel.rendezvous.Rendezvous;
import org.walluck.oscar.handlers.SNACHandler;

public class BuddyIconRendezvous
extends Rendezvous {
    private static final Logger LOG = Logger.getLogger((String)(class$org$walluck$oscar$channel$rendezvous$BuddyIconRendezvous == null ? (class$org$walluck$oscar$channel$rendezvous$BuddyIconRendezvous = BuddyIconRendezvous.class$("org.walluck.oscar.channel.rendezvous.BuddyIconRendezvous")) : class$org$walluck$oscar$channel$rendezvous$BuddyIconRendezvous).getName());
    private String filename;
    static /* synthetic */ Class class$org$walluck$oscar$channel$rendezvous$BuddyIconRendezvous;

    public BuddyIconRendezvous() {
        this.setService(1);
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public static short calculateChecksum(File file) throws IOException {
        DataInputStream dis = new DataInputStream(new FileInputStream(file));
        long sum = 0L;
        while (dis.available() >= 2) {
            sum += (long)(dis.read() + (dis.read() << 8));
        }
        if (dis.available() > 0) {
            sum += (long)dis.read();
        }
        dis.close();
        sum = ((sum & 0xFFFFFFFFFFFF0000L) >> 16) + (sum & 0xFFFFL);
        return (short)sum;
    }

    public void setRequest() throws IOException {
        File file = new File(this.filename);
        DataInputStream dis = new DataInputStream(new FileInputStream(this.filename));
        TLVChain tlvchain = new TLVChain(3);
        tlvchain.addShort(10, 1);
        tlvchain.addNull(15);
        AIMOutputStream buffer = new AIMOutputStream(12 + (int)file.length());
        buffer.writeShort(0);
        buffer.writeShort(BuddyIconRendezvous.calculateChecksum(new File(this.filename)));
        buffer.writeInt((int)file.length());
        buffer.writeInt((int)file.lastModified());
        byte[] b = new byte[1024];
        while (dis.read(b, 0, 1024) != -1) {
            buffer.writeBytes(b);
        }
        buffer.writeString("AVT1picture.id");
        tlvchain.addBytes(10001, buffer.getBytes());
        this.setType(0);
        this.setServiceData(tlvchain);
    }

    public void handleServiceData(AIMSession sess, SNACHandler handler, AIMFrame frame, SNAC snac, UserInfo userinfo, IncomingIMCH2 args, AIMInputStream buffer) throws IOException {
        LOG.debug((Object)(userinfo.getSN() + " has a buddy icon for us"));
        if (buffer != null) {
            args.getInfo().getIcon().setChecksum(buffer.readInt());
            args.getInfo().getIcon().setLength(buffer.readInt());
            args.getInfo().getIcon().setTimestamp(buffer.readInt());
            args.getInfo().getIcon().setIcon(buffer.readBytes(args.getInfo().getIcon().getLength()));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

