/*
 * Decompiled with CFR 0.152.
 */
package ise.antelope.tasks;

import ise.antelope.tasks.Break;
import ise.antelope.tasks.Case;
import ise.antelope.tasks.DefaultCase;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class SwitchTask
extends Task {
    private Vector cases = new Vector();
    private Case defaultCase = null;
    private String name = null;

    public void init() {
        this.getProject().addTaskDefinition("case", Case.class);
        this.getProject().addTaskDefinition("default", DefaultCase.class);
        this.getProject().addTaskDefinition("break", Break.class);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addCase(Case c) {
        this.cases.addElement(c);
    }

    public void addDefault(DefaultCase c) {
        if (this.defaultCase == null) {
            this.defaultCase = c;
            return;
        }
        throw new BuildException("<switch> can have only one <default>");
    }

    public void execute() throws BuildException {
        if (this.name == null) {
            throw new BuildException("'name' attribute cannot be null.");
        }
        String value = this.getProject().getProperty(this.name);
        if (value == null) {
            throw new BuildException("Property " + this.name + " does not exist.");
        }
        boolean disregardValue = false;
        Enumeration en = this.cases.elements();
        while (en.hasMoreElements()) {
            Case c = (Case)en.nextElement();
            if (disregardValue) {
                c.perform();
                if (!c.doBreak()) continue;
                return;
            }
            if (!value.equals(c.getValue())) continue;
            c.perform();
            if (c.doBreak()) {
                return;
            }
            disregardValue = true;
        }
        if (this.defaultCase != null) {
            this.defaultCase.perform();
        }
    }
}

