/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.core.utils.handlers;

import java.util.ArrayList;
import java.util.List;
import org.gcube.common.core.utils.handlers.GCUBEComplexHandler;
import org.gcube.common.core.utils.handlers.GCUBEHandlerConnector;
import org.gcube.common.core.utils.handlers.GCUBEIHandler;
import org.gcube.common.core.utils.handlers.lifetime.Lifetime;
import org.gcube.common.core.utils.handlers.lifetime.State;

public class GCUBESequentialHandler<HANDLED>
extends GCUBEComplexHandler<HANDLED>
implements Lifetime<HANDLED> {
    public GCUBESequentialHandler(GCUBEIHandler<? extends HANDLED> ... components) {
        super(components);
    }

    @Override
    public synchronized void run() throws Exception {
        this.setState(State.Running.INSTANCE);
        final List<GCUBEIHandler<HANDLED>> handlers = this.connectComponents();
        for (final GCUBEIHandler<HANDLED> handler : handlers) {
            try {
                handler.run();
            }
            catch (Exception e) {
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            for (int j = handlers.indexOf(handler) - 1; j >= 0; --j) {
                                ((GCUBEIHandler)handlers.get(j)).undo();
                            }
                        }
                        catch (Exception e) {
                            GCUBESequentialHandler.this.logger.warn("Could not recover from failure of " + handler.getClass());
                        }
                    }
                }.start();
                this.setState(State.Failed.INSTANCE);
                throw e;
            }
        }
        this.setState(State.Done.INSTANCE);
    }

    protected List<GCUBEIHandler<? extends HANDLED>> connectComponents() {
        List components = this.getHandlers();
        components.add(0, this);
        components.add(this);
        ArrayList<GCUBEIHandler<HANDLED>> handlers = new ArrayList<GCUBEIHandler<HANDLED>>();
        for (int i = 0; i < components.size(); ++i) {
            GCUBEHandlerConnector connector;
            GCUBEIHandler prevComponent = i - 1 >= 0 ? components.get(i - 1) : null;
            GCUBEIHandler currentComponent = components.get(i);
            GCUBEIHandler nextComponent = i + 1 < components.size() ? components.get(i + 1) : null;
            handlers.add(currentComponent);
            if (currentComponent instanceof GCUBEHandlerConnector) {
                connector = (GCUBEHandlerConnector)currentComponent;
                connector.previous = prevComponent;
                connector.next = nextComponent;
                continue;
            }
            if (nextComponent == null || nextComponent instanceof GCUBEHandlerConnector) continue;
            connector = new GCUBEHandlerConnector(){

                @Override
                public void connect() {
                }
            };
            connector.previous = currentComponent;
            connector.next = nextComponent;
            handlers.add(connector);
        }
        handlers.remove(handlers.size() - 1);
        handlers.remove(0);
        return handlers;
    }
}

