/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.tools.wsdd;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.axis.deployment.wsdd.WSDDDeployment;
import org.apache.axis.deployment.wsdd.WSDDDocument;
import org.apache.axis.deployment.wsdd.WSDDGlobalConfiguration;
import org.apache.axis.deployment.wsdd.WSDDService;
import org.apache.axis.utils.LockableHashtable;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.common.ChainedException;
import org.globus.util.Util;
import org.w3c.dom.Document;

public class WSDDEditor {
    private static Log logger = LogFactory.getLog((class$org$globus$wsrf$tools$wsdd$WSDDEditor == null ? (class$org$globus$wsrf$tools$wsdd$WSDDEditor = WSDDEditor.class$("org.globus.wsrf.tools.wsdd.WSDDEditor")) : class$org$globus$wsrf$tools$wsdd$WSDDEditor).getName());
    private static final String CONFIG_FILE_NAME = "server-config.wsdd";
    private static File configFile = new File("server-config.wsdd");
    private static final String GLOBUS_LOCATION = "GLOBUS_LOCATION";
    private static final String GLOBAL_CONFIG = "globalConfiguration";
    private WSDDDocument wsddDoc;
    private WSDDDeployment deployment;
    private WSDDGlobalConfiguration globalConfig;
    private String configFileName;
    private static final String editorOptPrompt = "This is an interactive edit mode. Use -help for other options\nMain menu:\nEnter (i) for interactive prompt (or)\n      (p) for use of properties file options (or)\n      (q) to quit editor tool. \n Value: ";
    private static final String propertiesFilePrompt = "\nOptions:\nwrite[w] : Writes to property file \nmerge[m] : Merges properties file entries with server config\nValue: ";
    private static final String filePrompt = "Enter file name to process. If empty, server-config.wsdd in \ncurrent directory is used. If not server-config.wsdd in \nGLOBUS_LOCATION is used.\nValue:  ";
    private static final String optionPrompt = "\nOptions:\nadd[a]: Adds the value of parameter using comma separator if \n        parameter exists. If not a new parameter is added.\nset[s]: Sets the value of parameter, overwrites the old parameter\n        if required. New parameter will be added if not present. \nquery[q]: Returns the value of the parameter \nValue:  ";
    private static final String continuePrompt = "\nOptions:\n Enter (c) to continue (or)\n       (s) to save and quit (or)\n       (q) to just quit.\n Value: ";
    static /* synthetic */ Class class$org$globus$wsrf$tools$wsdd$WSDDEditor;

    public WSDDEditor() throws Exception {
        if (configFile.exists()) {
            logger.debug("Current directory");
            this.getConfigurationDocument(CONFIG_FILE_NAME);
        } else {
            String globusLocation = System.getProperty(GLOBUS_LOCATION);
            if (globusLocation == null || globusLocation.trim().equals("")) {
                String err = "server-config.wsdd does not exist in current dir nor GLOBUS_LOCATION has been set";
                logger.error(err);
                throw new Exception(err);
            }
            if (!globusLocation.endsWith(File.separator)) {
                globusLocation = globusLocation + File.separator;
            }
            this.getConfigurationDocument(globusLocation + CONFIG_FILE_NAME);
        }
    }

    public WSDDEditor(String pathToConfigFile) throws Exception {
        this.getConfigurationDocument(pathToConfigFile);
    }

    public WSDDEditor(Document doc) throws Exception {
        this.setWSDDValues(doc, null);
    }

    private void getConfigurationDocument(String fileName) throws Exception {
        FileInputStream input = null;
        try {
            input = new FileInputStream(fileName);
            Document doc = XMLUtils.newDocument(input);
            this.setWSDDValues(doc, fileName);
        }
        catch (FileNotFoundException fnfe) {
            throw new ChainedException("The configuration file " + fileName + " cannot be found. ", fnfe);
        }
        finally {
            if (input != null) {
                input.close();
            }
        }
    }

    private void setWSDDValues(Document doc, String filename) throws Exception {
        this.wsddDoc = new WSDDDocument(doc);
        this.deployment = this.wsddDoc.getDeployment();
        this.globalConfig = this.deployment.getGlobalConfiguration();
        this.configFileName = filename;
    }

    public String getWSDDFilename() {
        return this.configFileName;
    }

    public WSDDGlobalConfiguration getGlobalConfiguration() {
        return this.globalConfig;
    }

    public void setGlobalParameter(String paramName, String value) throws Exception {
        if (this.globalConfig == null) {
            logger.error("Global configuration is null");
            throw new Exception("Global configuration is null");
        }
        this.globalConfig.setParameter(paramName, value);
    }

    public String getGlobalParameter(String paramName) throws Exception {
        if (this.globalConfig == null) {
            logger.error("Global configuration is null");
            throw new Exception("Global configuration is null");
        }
        return this.globalConfig.getParameter(paramName);
    }

    public void addGlobalParameter(String paramName, String value) throws Exception {
        if (this.globalConfig == null) {
            logger.error("Global configuration is null");
            throw new Exception("Global configuration is null");
        }
        String paramValue = this.globalConfig.getParameter(paramName);
        if (paramValue == null) {
            this.globalConfig.setParameter(paramName, value);
        } else {
            paramValue = paramValue + "," + value;
            this.globalConfig.setParameter(paramName, paramValue);
        }
    }

    public String[] getGlobalProperties() throws Exception {
        if (this.globalConfig == null) {
            logger.error("Global configuration is null");
            throw new Exception("Global configuration is null");
        }
        LockableHashtable props = this.globalConfig.getParametersTable();
        return this.parseAsStrings(props);
    }

    public String getServiceParameter(String serviceName, String paramName) throws Exception {
        WSDDService service = this.getService(serviceName);
        return service.getParameter(paramName);
    }

    public void setServiceParameter(String serviceName, String paramName, String value) throws Exception {
        WSDDService service = this.getService(serviceName);
        this.setServiceParameter(service, paramName, value);
    }

    public void setServiceParameter(WSDDService service, String paramName, String value) throws Exception {
        service.setParameter(paramName, value);
    }

    public void addServiceParameter(String serviceName, String paramName, String value) throws Exception {
        WSDDService service = this.getService(serviceName);
        String paramValue = service.getParameter(paramName);
        if (paramValue == null) {
            service.setParameter(paramName, value);
        } else {
            paramValue = paramValue + "," + value;
            service.setParameter(paramName, paramValue);
        }
    }

    public String[] getServiceProperties(String serviceName) throws Exception {
        WSDDService service = this.getService(serviceName);
        LockableHashtable props = service.getParametersTable();
        return this.parseAsStrings(props);
    }

    private String[] parseAsStrings(LockableHashtable props) {
        Set propSet = props.entrySet();
        if (propSet.size() <= 0) {
            return null;
        }
        String[] properties = new String[propSet.size()];
        Iterator iterator = propSet.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            properties[i] = (String)entry.getKey() + "=" + (String)entry.getValue();
            ++i;
        }
        return properties;
    }

    public WSDDService getService(String serviceName) throws Exception {
        WSDDService service = this.deployment.getWSDDService(new QName(serviceName));
        if (service == null) {
            String err = "Service " + serviceName + " does not exist";
            logger.error(err);
            throw new Exception(err);
        }
        return service;
    }

    public void writeChanges() throws Exception {
        this.writeChanges(this.configFileName);
    }

    public void writeChanges(String pathToOutputFile) throws Exception {
        if (pathToOutputFile == null) {
            logger.error("Output file name is null");
            throw new Exception("Output file name is null");
        }
        String newDeploymentDesc = XMLUtils.DocumentToString(this.wsddDoc.getDOMDocument());
        this.writeStringToFile(pathToOutputFile, newDeploymentDesc);
    }

    public void fixEolError(String pathToFile) throws Exception {
        if (pathToFile == null) {
            logger.error("File name is null");
            throw new Exception("File name is null");
        }
        String outputString = "";
        BufferedReader bufReader = null;
        try {
            bufReader = new BufferedReader(new FileReader(pathToFile));
            String line = null;
            while ((line = bufReader.readLine()) != null) {
                outputString = outputString + line + "\n";
            }
        }
        catch (IOException ioe) {
            logger.error("Could not read " + pathToFile + " file", ioe);
            throw new ChainedException("Could not read " + pathToFile, ioe);
        }
        finally {
            if (bufReader != null) {
                bufReader.close();
            }
        }
        this.writeStringToFile(pathToFile, outputString);
    }

    private void writeStringToFile(String pathToFile, String stringToWrite) throws Exception {
        FileWriter output = null;
        try {
            output = new FileWriter(pathToFile);
            output.write(stringToWrite);
        }
        catch (IOException ioe) {
            logger.error("Could not write " + pathToFile + " file", ioe);
            throw new ChainedException("Could not write " + pathToFile, ioe);
        }
        finally {
            if (output != null) {
                output.close();
            }
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length > 0) {
            WSDDEditor.processArguments(args);
        }
        while (true) {
            int option = WSDDEditor.getEditorOption();
            switch (option) {
                case 0: {
                    break;
                }
                case 1: {
                    System.out.println("Interactive mode.\n");
                    WSDDEditor.processInteractiveMode();
                    break;
                }
                case 2: {
                    System.out.println("Properties file mode.\n");
                    WSDDEditor.processPropertiesFileMode();
                    break;
                }
                case 3: {
                    System.out.println("Quitting editor");
                    System.exit(0);
                }
            }
        }
    }

    private static void processArguments(String[] args) throws Exception {
        String options = " Options are:\n [-file fileName] <serviceOption> <operation> (or)\n [-file fileName] -propFile <propFileName> <serviceOption> <propFileOption>\n where:\nfileName : name of config file. If not used, server-config.wsdd\n          in current directory or \n          GLOBUS_LOCATION/server-config.wsdd is used.\n<serviceOption> : \n\t -service <name> : <name> is name of service \n\t -global         : if global configuration\n<operation> :\n\t -set <paramName> <paramValue>\n\t -add <paramName> <paramValue>\n\t -get <paramName>\n\t\t <paramName>  : Name of paramater\n\t\t <paramValue> : Value of paramater\n<propFileName> : Name of properties file\n<propFileOption> :\n\t-merge : Merge entries from properties file into config file\n\t-write : Write entries to properties file from config file\nTo use interactive mode, use command with no arguments.";
        WSDDEditor editor = null;
        String fileName = null;
        String serviceName = null;
        int operation = -1;
        String paramName = null;
        String value = null;
        String propertiesFileName = null;
        int propOpereration = -1;
        int length = args.length;
        for (int i = 0; i < length; ++i) {
            if (args[i].equals("-help")) {
                System.out.println(options);
                System.exit(0);
            }
            if (args[i].equals("-file")) {
                if (i + 1 >= length) {
                    WSDDEditor.printAndQuit("-file option requires an argument");
                }
                fileName = args[++i];
            }
            if (args[i].equals("-propFile")) {
                if (i + 1 >= length) {
                    WSDDEditor.printAndQuit("-propFile option requires an argument");
                }
                propertiesFileName = args[++i];
            }
            if (args[i].equals("-service")) {
                if (i + 1 >= length) {
                    WSDDEditor.printAndQuit("-service option requires an argument");
                }
                serviceName = args[++i];
            }
            if (args[i].equals("-global")) {
                serviceName = GLOBAL_CONFIG;
            }
            if (args[i].equals("-write")) {
                propOpereration = 0;
            }
            if (args[i].equals("-merge")) {
                propOpereration = 1;
            }
            if (args[i].equals("-set")) {
                if (i + 2 >= length) {
                    WSDDEditor.printAndQuit("-set option requires: parameterName parameterValue");
                }
                operation = 1;
                paramName = args[++i];
                value = args[++i];
            }
            if (args[i].equals("-get")) {
                if (i + 1 >= length) {
                    WSDDEditor.printAndQuit("-get option requires: parameterName");
                }
                operation = 0;
                paramName = args[++i];
            }
            if (!args[i].equals("-add")) continue;
            if (i + 2 >= length) {
                WSDDEditor.printAndQuit("-add option requires: parameterName parameterValue");
            }
            operation = 2;
            paramName = args[++i];
            value = args[++i];
        }
        if (propertiesFileName != null) {
            switch (propOpereration) {
                case -1: {
                    WSDDEditor.printAndQuit("No valid operation chosen for given properties file ");
                }
                case 0: {
                    editor = WSDDEditor.getEditor(fileName);
                    WSDDEditor.processWriteToFileOption(serviceName, editor, propertiesFileName);
                    break;
                }
                case 1: {
                    editor = WSDDEditor.getEditor(fileName);
                    WSDDEditor.processMergeFromFileOption(serviceName, editor, propertiesFileName);
                    editor.writeChanges();
                    editor.fixEolError(editor.getWSDDFilename());
                }
            }
            System.exit(0);
        }
        switch (operation) {
            case -1: {
                WSDDEditor.printAndQuit("No valid operation chosen.");
            }
            case 0: {
                editor = WSDDEditor.getEditor(fileName);
                WSDDEditor.processQueryOption(editor, serviceName, paramName);
                break;
            }
            case 1: {
                editor = WSDDEditor.getEditor(fileName);
                WSDDEditor.processSetOption(editor, serviceName, paramName, value);
                editor.writeChanges();
                editor.fixEolError(editor.getWSDDFilename());
                break;
            }
            case 2: {
                editor = WSDDEditor.getEditor(fileName);
                WSDDEditor.processAddOption(editor, serviceName, paramName, value);
                editor.writeChanges();
                editor.fixEolError(editor.getWSDDFilename());
            }
        }
        System.exit(0);
    }

    private static void printAndQuit(String err) {
        System.err.println(err);
        System.exit(-1);
    }

    private static void processInteractiveMode() throws Exception {
        WSDDEditor editor = WSDDEditor.getEditor();
        String loopOption = null;
        do {
            int option = WSDDEditor.processOptionPrompt();
            switch (option) {
                case 0: {
                    break;
                }
                case 1: {
                    if (!WSDDEditor.processAddOption(editor)) break;
                    System.out.println("Parameter added successfully");
                    break;
                }
                case 2: {
                    if (!WSDDEditor.processSetOption(editor)) break;
                    System.out.println("Parameter value set successfully");
                    break;
                }
                case 3: {
                    WSDDEditor.processQueryOption(editor);
                }
            }
            loopOption = WSDDEditor.processContinueOptionPrompt();
            if (!loopOption.equals("s")) continue;
            editor.writeChanges();
            editor.fixEolError(editor.getWSDDFilename());
            System.out.println("Changes committed.");
            return;
        } while (loopOption.equals("c"));
    }

    private static void processPropertiesFileMode() throws Exception {
        WSDDEditor editor = WSDDEditor.getEditor();
        String loopOption = null;
        do {
            String serviceName = WSDDEditor.getElementName();
            int option = WSDDEditor.processPropFilePrompt();
            switch (option) {
                case 0: {
                    break;
                }
                case 1: {
                    WSDDEditor.processWriteToFileOption(serviceName, editor);
                    break;
                }
                case 2: {
                    WSDDEditor.processMergeFromFileOption(serviceName, editor);
                }
            }
            loopOption = WSDDEditor.processContinueOptionPrompt();
            if (!loopOption.equals("s")) continue;
            editor.writeChanges();
            editor.fixEolError(editor.getWSDDFilename());
            System.out.println("Changes committed.");
            return;
        } while (loopOption.equals("c"));
    }

    private static int processPropFilePrompt() {
        String optionInput = Util.getInput(propertiesFilePrompt);
        if (optionInput.trim().equalsIgnoreCase("write") || optionInput.trim().equalsIgnoreCase("w")) {
            return 1;
        }
        if (optionInput.trim().equalsIgnoreCase("merge") || optionInput.trim().equalsIgnoreCase("m")) {
            return 2;
        }
        System.out.println("Erroneous input.\n");
        return 0;
    }

    private static void processMergeFromFileOption(String serviceName, WSDDEditor editor) throws Exception {
        String prompt = "Enter file name to merge from. By default, servicename.properties (or globalConfiguration.properties)\n.Value: ";
        boolean global = WSDDEditor.isGlobal(serviceName);
        String fileName = WSDDEditor.getFilename(prompt, global, serviceName);
        WSDDEditor.processMergeFromFileOption(serviceName, editor, fileName);
    }

    private static void processMergeFromFileOption(String serviceName, WSDDEditor editor, String fileName) throws Exception {
        boolean global = WSDDEditor.isGlobal(serviceName);
        WSDDService service = null;
        if (!global) {
            service = editor.getService(serviceName);
        }
        Properties prop = new Properties();
        try {
            prop.load(new FileInputStream(fileName));
        }
        catch (IOException exp) {
            System.err.println("Could not load properties file " + fileName);
            return;
        }
        Enumeration<?> e = prop.propertyNames();
        while (e.hasMoreElements()) {
            String propKey = (String)e.nextElement();
            if (global) {
                editor.setGlobalParameter(propKey, prop.getProperty(propKey));
                continue;
            }
            editor.setServiceParameter(service, propKey, prop.getProperty(propKey));
        }
        System.out.println("Properties merged successfully");
    }

    private static void processWriteToFileOption(String serviceName, WSDDEditor editor) throws Exception {
        String prompt = "Enter file name to write to. By default, servicename.properties\n.Value: ";
        boolean global = WSDDEditor.isGlobal(serviceName);
        String fileName = WSDDEditor.getFilename(prompt, global, serviceName);
        WSDDEditor.processWriteToFileOption(serviceName, editor, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void processWriteToFileOption(String serviceName, WSDDEditor editor, String fileName) throws Exception {
        block15: {
            String[] serviceProperties = null;
            boolean global = false;
            if (WSDDEditor.isGlobal(serviceName)) {
                serviceProperties = editor.getGlobalProperties();
                global = true;
            } else {
                serviceProperties = editor.getServiceProperties(serviceName);
            }
            if (serviceProperties == null) {
                System.out.println("No properties to write.\n");
                return;
            }
            PrintWriter writer = null;
            writer = new PrintWriter(new FileWriter(fileName));
            for (int i = 0; i < serviceProperties.length; ++i) {
                writer.println(serviceProperties[i]);
            }
            System.out.println("Written successfully to file " + fileName);
            Object var8_8 = null;
            try {
                if (writer != null) {
                    writer.close();
                }
                break block15;
            }
            catch (Exception exp2) {
                System.err.println("Error closing writer. " + exp2);
            }
            break block15;
            {
                catch (IOException exp) {
                    System.err.println("Error writing to file. " + exp);
                    Object var8_9 = null;
                    try {
                        if (writer != null) {
                            writer.close();
                        }
                        break block15;
                    }
                    catch (Exception exp2) {
                        System.err.println("Error closing writer. " + exp2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (Exception exp2) {
                    System.err.println("Error closing writer. " + exp2);
                }
                throw throwable;
            }
        }
    }

    private static String getFilename(String prompt, boolean global, String serviceName) {
        String fileName = Util.getInput(prompt);
        if (fileName == null || fileName.trim().equals("")) {
            fileName = global ? "globalConfiguration.properties" : serviceName.substring(serviceName.lastIndexOf("/") + 1, serviceName.length()) + ".properties";
        }
        return fileName;
    }

    private static int getEditorOption() {
        String editOpts = Util.getInput(editorOptPrompt);
        if (editOpts.trim().equalsIgnoreCase("i")) {
            return 1;
        }
        if (editOpts.trim().equalsIgnoreCase("p")) {
            return 2;
        }
        if (editOpts.trim().equalsIgnoreCase("q")) {
            return 3;
        }
        return 0;
    }

    private static String processFileInput() {
        String optionInput = Util.getInput(filePrompt);
        if (optionInput == null || optionInput.trim().equals("")) {
            return null;
        }
        return optionInput;
    }

    private static int processOptionPrompt() {
        String optionInput = Util.getInput(optionPrompt);
        if (optionInput.trim().equalsIgnoreCase("add") || optionInput.trim().equalsIgnoreCase("a")) {
            return 1;
        }
        if (optionInput.trim().equalsIgnoreCase("set") || optionInput.trim().equalsIgnoreCase("s")) {
            return 2;
        }
        if (optionInput.trim().equalsIgnoreCase("query") || optionInput.trim().equalsIgnoreCase("q")) {
            return 3;
        }
        System.out.println("Erroneous input.");
        return 0;
    }

    private static boolean processAddOption(WSDDEditor editor) throws Exception {
        String elemName = WSDDEditor.getElementName();
        String paramName = WSDDEditor.getParameterName("add to");
        String paramVal = WSDDEditor.getParameterValue("add");
        return WSDDEditor.processAddOption(editor, elemName, paramName, paramVal);
    }

    private static boolean processAddOption(WSDDEditor editor, String elemName, String paramName, String paramVal) throws Exception {
        try {
            if (WSDDEditor.isGlobal(elemName)) {
                editor.addGlobalParameter(paramName, paramVal);
            } else {
                editor.addServiceParameter(elemName, paramName, paramVal);
            }
        }
        catch (Exception exp) {
            System.err.println(exp.getMessage());
            return false;
        }
        return true;
    }

    private static boolean processSetOption(WSDDEditor editor) throws Exception {
        String elemName = WSDDEditor.getElementName();
        String paramName = WSDDEditor.getParameterName("set");
        String paramVal = WSDDEditor.getParameterValue("set");
        return WSDDEditor.processSetOption(editor, elemName, paramName, paramVal);
    }

    private static boolean processSetOption(WSDDEditor editor, String elemName, String paramName, String paramVal) throws Exception {
        try {
            if (WSDDEditor.isGlobal(elemName)) {
                editor.setGlobalParameter(paramName, paramVal);
            } else {
                editor.setServiceParameter(elemName, paramName, paramVal);
            }
        }
        catch (Exception exp) {
            System.err.println(exp.getMessage());
            return false;
        }
        return true;
    }

    private static boolean processQueryOption(WSDDEditor editor) throws Exception {
        String elemName = WSDDEditor.getElementName();
        String paramName = WSDDEditor.getParameterName("query");
        return WSDDEditor.processQueryOption(editor, elemName, paramName);
    }

    private static boolean processQueryOption(WSDDEditor editor, String elemName, String paramName) throws Exception {
        String returnString = null;
        try {
            returnString = WSDDEditor.isGlobal(elemName) ? editor.getGlobalParameter(paramName) : editor.getServiceParameter(elemName, paramName);
            if (returnString == null) {
                System.out.println("Parameter \"" + paramName + "\" does not " + "exist in \"" + elemName + "\"");
            } else {
                System.out.println("Value of parameter is: \"" + returnString + "\"");
            }
        }
        catch (Exception exp) {
            System.err.println(exp.getMessage());
            return false;
        }
        return true;
    }

    private static boolean isGlobal(String elementName) {
        return elementName != null && (elementName.equals(GLOBAL_CONFIG) || elementName.equalsIgnoreCase("g"));
    }

    private static String processContinueOptionPrompt() {
        String optionInput = null;
        while ((optionInput = Util.getInput(continuePrompt)) == null || !optionInput.trim().equalsIgnoreCase("s") && !optionInput.trim().equalsIgnoreCase("c") && !optionInput.trim().equalsIgnoreCase("q")) {
        }
        return optionInput.trim();
    }

    private static String getElementName() {
        String elementName = null;
        String msg = "Enter service name (or) 'globalConfiguration' or 'g'\nfor global parameters: ";
        while ((elementName = Util.getInput(msg)) == null || elementName.trim().equals("")) {
        }
        return elementName;
    }

    private static String getParameterName(String optionName) {
        String paramName = null;
        while ((paramName = Util.getInput("Enter name of parameter to " + optionName + ": ")) == null || paramName.trim().equals("")) {
        }
        return paramName;
    }

    private static String getParameterValue(String optionName) {
        String paramVal = null;
        while ((paramVal = Util.getInput("Enter value of parameter to " + optionName + ": ")) == null || paramVal.trim().equals("")) {
        }
        return paramVal;
    }

    private static WSDDEditor getEditor() throws Exception {
        String fileName = WSDDEditor.processFileInput();
        return WSDDEditor.getEditor(fileName);
    }

    private static WSDDEditor getEditor(String fileName) throws Exception {
        WSDDEditor editor = null;
        editor = fileName == null ? new WSDDEditor() : new WSDDEditor(fileName);
        System.out.println("Using file " + editor.getWSDDFilename());
        return editor;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

