/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.security.authentication.secureconv;

import java.rmi.RemoteException;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.util.Base64;
import org.globus.ws.trust.BinaryExchangeType;
import org.globus.ws.trust.RequestSecurityTokenResponseType;
import org.globus.ws.trust.RequestSecurityTokenType;
import org.globus.ws.trust.holders.RequestSecurityTokenResponseTypeHolder;
import org.globus.wsrf.encoding.SerializationException;
import org.globus.wsrf.impl.security.authentication.secureconv.SecureConversationMessage;
import org.globus.wsrf.security.impl.secconv.SecureConversation;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;

public class Authenticator {
    static Log logger = LogFactory.getLog(Authenticator.class.getName());
    protected String contextId;
    protected GSSContext context;
    protected EndpointReferenceType contextEPR;

    public Authenticator(GSSContext context) {
        this.context = context;
    }

    public void authenticate(SecureConversation auth) throws GSSException, RemoteException {
        byte[] inToken = new byte[]{};
        byte[] outToken = null;
        RequestSecurityTokenResponseType response = null;
        RequestSecurityTokenResponseTypeHolder holder = new RequestSecurityTokenResponseTypeHolder();
        BinaryExchangeType token = null;
        SecureConversationMessage message = null;
        boolean firstTime = true;
        while (!this.context.isEstablished()) {
            outToken = this.context.initSecContext(inToken, 0, inToken.length);
            if (outToken == null) continue;
            if (firstTime) {
                firstTime = false;
                RequestSecurityTokenType request = new RequestSecurityTokenType();
                token = new BinaryExchangeType();
                token.setValueType(SecureConversationMessage.GSSAPI_GSI_TOKEN_VALUE_TYPE);
                token.setEncodingType(SecureConversationMessage.BASE64_BINARY_ENCODING);
                token.set_value(new String(Base64.encode(outToken)));
                MessageElement[] requestContent = null;
                try {
                    requestContent = SecureConversationMessage.createMessage(token);
                }
                catch (SerializationException e) {
                    throw new RemoteException("", e);
                }
                request.set_any(requestContent);
                response = auth.requestSecurityToken(request);
                this.contextId = response.getContext().getSchemeSpecificPart();
                message = new SecureConversationMessage(response.get_any());
                try {
                    message.parseMessage();
                }
                catch (Exception e) {
                    throw new RemoteException("", e);
                }
                token = message.getExchangeToken();
                inToken = Base64.decode(token.get_value().getBytes());
                continue;
            }
            token.set_value(new String(Base64.encode(outToken)));
            try {
                response.set_any(SecureConversationMessage.createMessage(token));
            }
            catch (SerializationException e) {
                throw new RemoteException("", e);
            }
            holder.value = response;
            auth.requestSecurityTokenResponse(holder);
            response = holder.value;
            message = new SecureConversationMessage(response.get_any());
            try {
                message.parseMessage();
            }
            catch (Exception e) {
                throw new RemoteException("", e);
            }
            token = message.getExchangeToken();
            if (token == null) continue;
            inToken = Base64.decode(token.get_value().getBytes());
        }
    }

    public String getContextId() {
        return this.contextId;
    }

    public EndpointReferenceType getContextEPR() {
        return this.contextEPR;
    }

    public GSSContext getContext() {
        return this.context;
    }
}

