/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.message.token;

import javax.xml.namespace.QName;
import org.apache.ws.security.WSConstants;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.util.DOM2Writer;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.xml.security.utils.Base64;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class BinarySecurity {
    public static final String BASE64_BINARY = "Base64Binary";
    private String base64Encoding;
    protected Element element = null;
    protected WSSConfig wssConfig = WSSConfig.getDefaultWSConfig();
    public static String TOKEN = "BinarySecurityToken";

    public BinarySecurity(WSSConfig wssConfig, Element elem) throws WSSecurityException {
        this.element = elem;
        this.wssConfig = wssConfig;
        this.base64Encoding = BinarySecurity.getBase64EncodingValue(wssConfig);
        boolean nsOK = false;
        if (wssConfig.getProcessNonCompliantMessages()) {
            for (int i = 0; i < WSConstants.WSSE_NS_ARRAY.length; ++i) {
                if (!WSConstants.WSSE_NS_ARRAY[i].equals(this.element.getNamespaceURI())) continue;
                nsOK = true;
                break;
            }
        } else if (wssConfig.getWsseNS().equals(this.element.getNamespaceURI())) {
            nsOK = true;
        }
        if (!nsOK || !this.element.getLocalName().equals(TOKEN) && !this.element.getLocalName().equals("KeyIdentifier")) {
            QName el = new QName(this.element.getNamespaceURI(), this.element.getLocalName());
            throw new WSSecurityException(4, "badTokenType", new Object[]{el});
        }
        if (!this.getEncodingType().endsWith(BASE64_BINARY)) {
            throw new WSSecurityException(4, "badEncoding", new Object[]{this.getEncodingType()});
        }
    }

    public BinarySecurity(WSSConfig wssConfig, Document doc) {
        this.wssConfig = wssConfig;
        this.base64Encoding = BinarySecurity.getBase64EncodingValue(wssConfig);
        this.element = doc.createElementNS(wssConfig.getWsseNS(), "wsse:BinarySecurityToken");
        WSSecurityUtil.setNamespace(this.element, wssConfig.getWsseNS(), "wsse");
        this.setEncodingType(this.base64Encoding);
        this.element.appendChild(doc.createTextNode(""));
    }

    public String getValueType() {
        String valueType = this.element.getAttribute("ValueType");
        if (valueType.length() == 0 && (this.wssConfig.getProcessNonCompliantMessages() || this.wssConfig.isBSTAttributesQualified())) {
            valueType = WSSecurityUtil.getAttributeValueWSSE(this.element, "ValueType", null);
        }
        return valueType;
    }

    protected void setValueType(String type) {
        if (this.wssConfig.isBSTAttributesQualified()) {
            this.element.setAttributeNS(this.wssConfig.getWsseNS(), "wsse:ValueType", type);
        } else {
            this.element.setAttributeNS(null, "ValueType", type);
        }
    }

    public String getEncodingType() {
        String encodingType = this.element.getAttribute("EncodingType");
        if (encodingType.length() == 0 && (this.wssConfig.getProcessNonCompliantMessages() || this.wssConfig.isBSTAttributesQualified())) {
            encodingType = WSSecurityUtil.getAttributeValueWSSE(this.element, "EncodingType", null);
        }
        return encodingType;
    }

    protected void setEncodingType(String encoding) {
        if (this.wssConfig.isBSTAttributesQualified()) {
            this.element.setAttributeNS(this.wssConfig.getWsseNS(), "wsse:EncodingType", encoding);
        } else {
            this.element.setAttributeNS(null, "EncodingType", encoding);
        }
    }

    public byte[] getToken() {
        Text node = this.getFirstNode();
        if (node == null) {
            return null;
        }
        try {
            return Base64.decode(node.getData());
        }
        catch (Exception e) {
            return null;
        }
    }

    protected void setToken(byte[] data) {
        if (data == null) {
            throw new IllegalArgumentException("data == null");
        }
        Text node = this.getFirstNode();
        node.setData(Base64.encode(data));
    }

    protected Text getFirstNode() {
        Node node = this.element.getFirstChild();
        return node != null && node instanceof Text ? (Text)node : null;
    }

    public Element getElement() {
        return this.element;
    }

    public String getID() {
        return this.element.getAttributeNS(this.wssConfig.getWsuNS(), "Id");
    }

    public void setID(String id) {
        String prefix = WSSecurityUtil.setNamespace(this.element, this.wssConfig.getWsuNS(), "wsu");
        this.element.setAttributeNS(this.wssConfig.getWsuNS(), prefix + ":Id", id);
    }

    public String toString() {
        return DOM2Writer.nodeToString(this.element);
    }

    public static String getBase64EncodingValue(WSSConfig wssConfig) {
        if (wssConfig.isBSTValuesPrefixed()) {
            return "wsse:Base64Binary";
        }
        return "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary";
    }
}

