/*
 * Decompiled with CFR 0.152.
 */
package cryptix.provider.rsa;

import cryptix.provider.rsa.RSAAlgorithm;
import cryptix.provider.rsa.RawRSAPrivateKey;
import cryptix.provider.rsa.RawRSAPublicKey;
import cryptix.util.core.BI;
import cryptix.util.core.Debug;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import xjava.security.interfaces.RSAKeyPairGenerator;

public class BaseRSAKeyPairGenerator
extends KeyPairGenerator
implements RSAKeyPairGenerator {
    private static final boolean DEBUG = true;
    private static final int debuglevel = Debug.getLevel("RSA", "BaseRSAKeyPairGenerator");
    private static final PrintWriter err = Debug.getOutput();
    private int strength;
    private BigInteger e;
    private SecureRandom source;
    private static final int CONFIDENCE = 80;
    private static final BigInteger F4 = BigInteger.valueOf(65537L);
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private static final int DEFAULT_STRENGTH = 1024;

    private static void debug(String s) {
        err.println("BaseRSAKeyPairGenerator: " + s);
    }

    public BaseRSAKeyPairGenerator() {
        super("RSA");
    }

    public void initialize(int strength, BigInteger e, SecureRandom source) {
        this.e = e == null ? F4 : e;
        this.strength = strength < 2 ? 1024 : strength;
        this.source = source == null ? new SecureRandom() : source;
    }

    public void initialize(int strength, SecureRandom source) {
        this.initialize(strength, F4, source);
    }

    /*
     * Unable to fully structure code
     */
    public KeyPair generateKeyPair() {
        k1 = this.strength / 2;
        k2 = this.strength - k1;
        t1 = 0L;
        if (BaseRSAKeyPairGenerator.debuglevel < 7) ** GOTO lbl-1000
        t1 = System.currentTimeMillis();
lbl-1000:
        // 2 sources

        {
            do {
                p = new BigInteger(k1, 80, this.source);
                q = new BigInteger(k2, 80, this.source);
                n = p.multiply(q);
            } while (p.compareTo(q) == 0 || n.bitLength() != this.strength);
            phi = p.subtract(BaseRSAKeyPairGenerator.ONE).multiply(q.subtract(BaseRSAKeyPairGenerator.ONE));
            d = this.e.modInverse(phi);
        }
        if (BaseRSAKeyPairGenerator.debuglevel >= 7) {
            t1 = System.currentTimeMillis() - t1;
            BaseRSAKeyPairGenerator.debug(" ...generateKeyPair() completed in " + t1 + " ms.");
        }
        if (BaseRSAKeyPairGenerator.debuglevel >= 5) {
            try {
                BaseRSAKeyPairGenerator.err.print("RSA parameters self test #1/2... ");
                x = new BigInteger(k1, this.source);
                y = RSAAlgorithm.rsa(x, n, this.e);
                z = RSAAlgorithm.rsa(y, n, d);
                yes = z.compareTo(x) == 0;
                BaseRSAKeyPairGenerator.err.println(yes != false ? "OK" : "Failed");
                if (!yes) {
                    throw new RuntimeException();
                }
                BaseRSAKeyPairGenerator.err.print("RSA parameters self test #2/2... ");
                u = q.modInverse(p);
                z = RSAAlgorithm.rsa(y, n, d, p, q, u);
                yes = z.compareTo(x) == 0;
                BaseRSAKeyPairGenerator.err.println(yes != false ? "OK" : "Failed");
                if (!yes) {
                    throw new RuntimeException();
                }
                BaseRSAKeyPairGenerator.err.println();
            }
            catch (Exception ex) {
                BaseRSAKeyPairGenerator.err.println("RSA parameters:");
                BaseRSAKeyPairGenerator.err.println("         n: " + BI.dumpString(n));
                BaseRSAKeyPairGenerator.err.println("         e: " + BI.dumpString(this.e));
                BaseRSAKeyPairGenerator.err.println("         d: " + BI.dumpString(d));
                BaseRSAKeyPairGenerator.err.println("         p: " + BI.dumpString(p));
                BaseRSAKeyPairGenerator.err.println("         q: " + BI.dumpString(q));
                BaseRSAKeyPairGenerator.err.println("q^-1 mod p: " + BI.dumpString(q.modInverse(p)));
                throw new RuntimeException(this.e.toString());
            }
        }
        return this.makeKeyPair(n, this.e, d, p, q);
    }

    protected KeyPair makeKeyPair(BigInteger n, BigInteger e, BigInteger d, BigInteger p, BigInteger q) {
        RawRSAPublicKey pk = new RawRSAPublicKey(n, e);
        RawRSAPrivateKey sk = new RawRSAPrivateKey(d, p, q);
        return new KeyPair(pk, sk);
    }

    public void initialize() {
        this.initialize(1024, F4, new SecureRandom());
    }
}

