/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import java.security.SecureRandom;
import javax.jms.JMSException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.tcp.SslTransportFactory;
import org.apache.activemq.util.JMSExceptionSupport;

public class ActiveMQSslConnectionFactory
extends ActiveMQConnectionFactory {
    protected KeyManager[] keyManager;
    protected TrustManager[] trustManager;
    protected SecureRandom secureRandom;

    public void setKeyAndTrustManagers(KeyManager[] km, TrustManager[] tm, SecureRandom random) {
        this.keyManager = km;
        this.trustManager = tm;
        this.secureRandom = random;
    }

    protected Transport createTransport() throws JMSException {
        if (!this.brokerURL.getScheme().equals("ssl")) {
            return super.createTransport();
        }
        try {
            SslTransportFactory sslFactory = new SslTransportFactory();
            sslFactory.setKeyAndTrustManagers(this.keyManager, this.trustManager, this.secureRandom);
            return sslFactory.doConnect(this.brokerURL);
        }
        catch (Exception e) {
            throw JMSExceptionSupport.create("Could not create Transport. Reason: " + e, e);
        }
    }
}

