/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.informationsystem.client.eximpl;

import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.RPDocument;
import org.gcube.common.core.informationsystem.client.XMLResult;
import org.gcube.common.core.informationsystem.client.impl.AbstractXMLResult;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.state.GCUBEWSResourceKey;
import org.globus.wsrf.ResourceKey;
import org.globus.wsrf.impl.SimpleResourceKey;
import org.globus.wsrf.impl.SimpleResourcePropertyMetaData;
import org.globus.wsrf.utils.AddressingUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RPDocumentImpl
extends AbstractXMLResult
implements RPDocument {
    EndpointReferenceType endpoint;
    GCUBEWSResourceKey key;

    public RPDocumentImpl(String string) throws XMLResult.ISResultInitialisationException {
        super(string);
    }

    protected void parse(String string) throws ISClient.ISMalformedResultException {
        Matcher matcher = Pattern.compile("<Data>(.*?)</Data>", 32).matcher(string);
        if (!matcher.find()) {
            throw new ISClient.ISMalformedResultException((Exception)new IllegalArgumentException());
        }
        super.parse(matcher.group(0));
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            Element element = documentBuilderFactory.newDocumentBuilder().parse(new InputSource(new StringReader(string))).getDocumentElement();
            String string2 = element.getElementsByTagName("Source").item(0).getTextContent();
            NodeList nodeList = element.getElementsByTagName("CompleteSourceKey").item(0).getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!(node instanceof Element)) continue;
                SimpleResourceKey simpleResourceKey = new SimpleResourceKey(new QName(node.getNamespaceURI(), node.getLocalName()), (Object)node.getTextContent());
                this.key = new GCUBEWSResourceKey((ResourceKey)simpleResourceKey);
                this.endpoint = AddressingUtils.createEndpointReference((String)string2, (ResourceKey)simpleResourceKey);
                return;
            }
        }
        catch (Exception exception) {
            throw new ISClient.ISMalformedResultException(exception);
        }
    }

    public GCUBEWSResourceKey getKey() {
        try {
            if (this.dom == null) {
                this.parse(this.result);
            }
        }
        catch (Exception exception) {
            return null;
        }
        return this.key;
    }

    public List<String> evaluate(String string) throws XMLResult.ISResultEvaluationException {
        return super.evaluate("/Data" + string);
    }

    public EndpointReferenceType getEndpoint() {
        try {
            if (this.dom == null) {
                this.parse(this.result);
            }
        }
        catch (Exception exception) {
            return null;
        }
        return this.endpoint;
    }

    public String getServiceID() {
        try {
            return this.evaluate("/ServiceID/text()").get(0);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getServiceName() {
        try {
            return this.evaluate("/ServiceName/text()").get(0);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getServiceClass() {
        try {
            return this.evaluate("/ServiceClass/text()").get(0);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getRIID() {
        try {
            return this.evaluate("/RI/text()").get(0);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getGHNID() {
        try {
            return this.evaluate("/GHN/text()").get(0);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public List<GCUBEScope> getScope() {
        try {
            ArrayList<GCUBEScope> arrayList = new ArrayList<GCUBEScope>();
            for (String string : this.evaluate("/Scope/text()")) {
                arrayList.add(GCUBEScope.getScope((String)string));
            }
            return arrayList;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Calendar getTerminationTime() {
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(new SimpleDateFormat().parse(this.evaluate("/" + SimpleResourcePropertyMetaData.TERMINATION_TIME.getName().getLocalPart() + "/text()").get(0)));
            return calendar;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

