/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.ac;

import java.math.BigInteger;
import java.security.PrivateKey;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.glite.security.voms.ac.AttCertIssuer;
import org.glite.security.voms.ac.AttributeCertificateInfo;
import org.glite.security.voms.ac.Holder;
import org.glite.security.voms.ac.Util;
import org.glite.security.voms.ac.V2Form;

public class ACGenerator {
    X500Principal issuer;
    X500Principal holderIssuer;
    BigInteger holderSerial;
    Date notAfter;
    Date notBefore;
    Vector attributes;
    Vector extensions;

    public void addAttribute(String oid, String policyAuthority, String value) {
    }

    public void addAttributes(String oid, String policyAuthority, List values) {
    }

    public void setExtensions(Vector vector) {
        this.extensions = vector;
    }

    public void setHolderIssuer(X500Principal principal) {
        this.holderIssuer = principal;
    }

    public void setHolderSerial(BigInteger integer) {
        this.holderSerial = integer;
    }

    public void setIssuer(X500Principal principal) {
        this.issuer = principal;
    }

    public void setNotAfter(Date date) {
        this.notAfter = date;
    }

    public void setNotBefore(Date date) {
        this.notBefore = date;
    }

    public AttributeCertificateInfo generateACInfo() {
        if (this.issuer == null || this.holderIssuer == null || this.holderSerial == null || this.notAfter == null || this.notBefore == null) {
            throw new IllegalArgumentException("All mandatory components are not present");
        }
        DEREncodableVector v = new DEREncodableVector();
        v.add((DEREncodable)new DERInteger(1));
        v.add((DEREncodable)new Holder(this.holderIssuer, this.holderSerial));
        v.add((DEREncodable)new AttCertIssuer(new V2Form(Util.x500nameToGeneralNames(this.issuer))));
        v.add((DEREncodable)new AlgorithmIdentifier("1.2.840.113549.1.1.5"));
        v.add((DEREncodable)new DERInteger(1));
        return null;
    }

    public void sign(PrivateKey key) {
    }
}

