/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security;

import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Vector;
import org.apache.ws.security.message.token.Timestamp;
import org.opensaml.SAMLAssertion;

public class WSSecurityEngineResult {
    private int action;
    private Principal principal;
    private X509Certificate cert;
    private SAMLAssertion assertion;
    private Timestamp timestamp;
    private Vector signedElementQnames;

    WSSecurityEngineResult(int act, SAMLAssertion ass) {
        this.principal = null;
        this.cert = null;
        this.action = act;
        this.assertion = ass;
    }

    WSSecurityEngineResult(int act, Principal princ, X509Certificate certificate, Vector elemQnames) {
        this.principal = princ;
        this.action = act;
        this.cert = certificate;
        this.signedElementQnames = elemQnames;
    }

    WSSecurityEngineResult(int act, Timestamp tstamp) {
        this.action = act;
        this.timestamp = tstamp;
    }

    public int getAction() {
        return this.action;
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public X509Certificate getCertificate() {
        return this.cert;
    }

    public SAMLAssertion getAssertion() {
        return this.assertion;
    }

    public Timestamp getTimestamp() {
        return this.timestamp;
    }

    public Vector getSignedElementQnames() {
        return this.signedElementQnames;
    }
}

