/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.authorization.library.enpoints;

import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.gcube.common.authorization.library.enpoints.AuthorizationEndpoint;
import org.gcube.common.scan.ClasspathScanner;
import org.gcube.common.scan.ClasspathScannerFactory;
import org.gcube.common.scan.matchers.NameMatcher;
import org.gcube.common.scan.matchers.ResourceMatcher;
import org.gcube.common.scan.resources.ClasspathResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizationEndpointScanner {
    private static Logger log = LoggerFactory.getLogger(AuthorizationEndpointScanner.class);
    private static Map<Integer, AuthorizationEndpoint> endpoints;
    static final String configurationPattern = "authorization-endpoint.xml";

    public static synchronized Map<Integer, AuthorizationEndpoint> endpoints() {
        if (endpoints == null || endpoints.size() == 0) {
            endpoints = new HashMap<Integer, AuthorizationEndpoint>();
            try {
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{AuthorizationEndpoint.class});
                Unmarshaller um = context.createUnmarshaller();
                ClasspathScanner scanner = ClasspathScannerFactory.scanner();
                for (ClasspathResource r : scanner.scan((ResourceMatcher)new NameMatcher(configurationPattern))) {
                    AuthorizationEndpoint endpoint = (AuthorizationEndpoint)um.unmarshal(r.stream());
                    if (!endpoints.containsKey(endpoint.getInfrastructure()) || endpoints.get(endpoint.getInfrastructure()).getPriority() > endpoint.getPriority()) {
                        endpoints.put(endpoint.getInfrastructure().hashCode(), endpoint);
                    }
                    log.info("loaded endpoint {} ", (Object)endpoint.toString());
                }
                if (endpoints.size() == 0) {
                    throw new Exception("no endpoints retreived");
                }
            }
            catch (Exception e) {
                throw new RuntimeException("could not load authorization endpoints", e);
            }
        }
        return endpoints;
    }
}

