/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.security.authentication.signature;

import java.security.Key;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.SOAPConstants;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.conversation.message.token.SecurityContextToken;
import org.apache.ws.security.message.EnvelopeIdResolver;
import org.apache.ws.security.message.WSSignEnvelope;
import org.apache.ws.security.message.token.Reference;
import org.apache.ws.security.message.token.SecurityTokenReference;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.xml.security.algorithms.SignatureAlgorithm;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.transforms.params.InclusiveNamespaces;
import org.apache.xml.security.utils.XMLUtils;
import org.globus.wsrf.impl.security.authentication.secureconv.SecureConversationMessage;
import org.globus.wsrf.impl.security.authentication.wssec.GSSConfig;
import org.globus.wsrf.impl.security.util.EnvelopeConverter;
import org.globus.wsrf.providers.GSSPrivateKey;
import org.ietf.jgss.GSSContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GssSignedSOAPEnvelopeBuilder
extends WSSignEnvelope {
    private static Log logger = LogFactory.getLog((String)GssSignedSOAPEnvelopeBuilder.class.getName());
    protected GSSContext context;
    protected MessageContext msgContext;
    protected String contextId;
    protected String canonicalizationAlgorithm = "http://www.w3.org/2001/10/xml-exc-c14n#";

    public GssSignedSOAPEnvelopeBuilder(MessageContext msgContext, GSSContext context) {
        this(msgContext, context, null);
    }

    public GssSignedSOAPEnvelopeBuilder(MessageContext msgContext, GSSContext context, String contextId) {
        this.msgContext = msgContext;
        this.context = context;
        this.contextId = contextId;
    }

    private String getContextId() {
        if (this.contextId == null) {
            return String.valueOf(this.context.hashCode());
        }
        return this.contextId;
    }

    public String getCanonicalizationAlgorithm() {
        return this.canonicalizationAlgorithm;
    }

    public void setCanonicalizationAlgorithm(String canonicalizationAlgorithm) {
        this.canonicalizationAlgorithm = canonicalizationAlgorithm;
    }

    public SOAPEnvelope build(SOAPEnvelope envelope) throws Exception {
        return this.buildMessage(envelope).getSOAPPart().getEnvelope();
    }

    public SOAPMessage buildMessage(SOAPEnvelope env) throws Exception {
        SOAPHeader header;
        logger.debug((Object)"Beginning signing...");
        WSSConfig wssConfig = WSSConfig.getDefaultWSConfig();
        Document doc = EnvelopeConverter.getInstance().toDocument(env);
        SOAPConstants soapConstants = WSSecurityUtil.getSOAPConstants((Element)doc.getDocumentElement());
        Element secHeader = this.insertSecurityHeader(doc);
        Element canonElem = XMLUtils.createElementInSignatureSpace((Document)doc, (String)"CanonicalizationMethod");
        canonElem.setAttributeNS(null, "Algorithm", this.canonicalizationAlgorithm);
        Set prefixes = this.getInclusivePrefixes(secHeader, false);
        InclusiveNamespaces inclusiveNamespaces = new InclusiveNamespaces(doc, prefixes);
        canonElem.appendChild(inclusiveNamespaces.getElement());
        SignatureAlgorithm signatureAlgorithm = new SignatureAlgorithm(doc, "http://www.globus.org/2002/04/xmlenc#gssapi-sign");
        XMLSignature sig = new XMLSignature(doc, null, signatureAlgorithm.getElement(), canonElem);
        Element body = WSSecurityUtil.findBodyElement((Document)doc, (SOAPConstants)soapConstants);
        String id = this.setWsuId(body);
        Transforms transforms = new Transforms(doc);
        transforms.addTransform("http://www.w3.org/2001/10/xml-exc-c14n#");
        transforms.item(0).getElement().appendChild(new InclusiveNamespaces(doc, this.getInclusivePrefixes(body)).getElement());
        sig.addResourceResolver(EnvelopeIdResolver.getInstance((WSSConfig)wssConfig));
        sig.addDocument("#" + id, transforms);
        HashMap nonWsaHeaders = (HashMap)this.msgContext.getProperty("org.globus.security.secure.headers");
        if (nonWsaHeaders != null && (header = env.getHeader()) != null) {
            Iterator iter = header.examineHeaderElements(this.actor);
            while (iter.hasNext()) {
                String name;
                SOAPHeaderElement elem = (SOAPHeaderElement)iter.next();
                String ns = elem.getNamespaceURI();
                QName qName = new QName(ns, name = elem.getElementName().getLocalName());
                if (!nonWsaHeaders.containsKey(qName)) continue;
                logger.debug((Object)("Sign header " + qName));
                NodeList list = doc.getElementsByTagNameNS(ns, name);
                Element headerElem = (Element)list.item(0);
                String headerId = this.setWsuId(headerElem);
                transforms = new Transforms(doc);
                transforms.addTransform("http://www.w3.org/2001/10/xml-exc-c14n#");
                transforms.item(0).getElement().appendChild(new InclusiveNamespaces(doc, this.getInclusivePrefixes(headerElem)).getElement());
                sig.addDocument("#" + headerId, transforms);
            }
        }
        GSSPrivateKey contextKey = new GSSPrivateKey(this.getContextId(), this.context);
        sig.sign((Key)contextKey);
        KeyInfo keyInfo = sig.getKeyInfo();
        SecurityTokenReference securityTokenReference = new SecurityTokenReference(wssConfig, doc);
        Reference tokenReference = new Reference(wssConfig, doc);
        tokenReference.setValueType(SecureConversationMessage.CONTEXT_TOKEN_VALUE_TYPE.toString());
        tokenReference.setURI("#SecurityContextToken-" + env.hashCode());
        securityTokenReference.setReference(tokenReference);
        keyInfo.addUnknownElement(securityTokenReference.getElement());
        SecurityContextToken secContextToken = new SecurityContextToken(doc, this.getContextId());
        secContextToken.setID("SecurityContextToken-" + env.hashCode());
        WSSecurityUtil.prependChildElement((Document)doc, (Element)secHeader, (Element)secContextToken.getElement(), (boolean)false);
        WSSecurityUtil.prependChildElement((Document)doc, (Element)secHeader, (Element)sig.getElement(), (boolean)false);
        logger.debug((Object)"Signing complete.");
        return EnvelopeConverter.getInstance().toSOAPMessage(doc);
    }

    static {
        GSSConfig.init();
    }
}

