/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.container;

import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.axis.AxisEngine;
import org.apache.axis.deployment.wsdd.WSDDService;
import org.globus.wsrf.container.ServiceHost;
import org.globus.wsrf.container.ServiceManager;
import org.globus.wsrf.container.usage.ContainerUsageStartPacketV2;
import org.globus.wsrf.container.usage.ContainerUsageStopPacketV2;

public class UsageConfig {
    private static final String USAGE_STATISTICS_TARGETS = "usageStatisticsTargets";
    private static short containerType = 0;
    private ServiceManager manager;
    private List targetList;
    private long startTime;

    UsageConfig(ServiceManager manager) {
        if (manager == null) {
            throw new IllegalArgumentException();
        }
        this.manager = manager;
        String targets = manager.getOption(USAGE_STATISTICS_TARGETS);
        this.init(targets);
    }

    UsageConfig(ServiceManager manager, String targets) {
        if (manager == null) {
            throw new IllegalArgumentException();
        }
        this.manager = manager;
        this.init(targets);
    }

    protected void init(String targets) {
        this.targetList = new ArrayList();
        if (targets != null) {
            StringTokenizer tokens = new StringTokenizer(targets);
            while (tokens.hasMoreTokens()) {
                this.targetList.add(tokens.nextToken());
            }
        }
    }

    public static UsageConfig getUsageConfig() {
        ServiceManager manager = ServiceManager.getCurrentServiceManager();
        return manager != null ? manager.getUsageConfig() : null;
    }

    public boolean hasTargets() {
        return !this.targetList.isEmpty();
    }

    public List getTargets() {
        return this.targetList;
    }

    public void addTarget(String target) {
        this.targetList.add(target);
    }

    public void removeTarget(String target) {
        this.targetList.remove(target);
    }

    public void clearTargets() {
        this.targetList.clear();
    }

    static void setContainerType(short type) {
        if (containerType == 0) {
            containerType = type;
        }
    }

    static short getContainerType() {
        return containerType;
    }

    public InetAddress getContainerHost() {
        try {
            return InetAddress.getByName(ServiceHost.getHost((AxisEngine)this.manager.getAxisEngine()));
        }
        catch (IOException e) {
            try {
                return InetAddress.getLocalHost();
            }
            catch (IOException ee) {
                return null;
            }
        }
    }

    void sendStartPacket() {
        this.startTime = System.currentTimeMillis();
        WSDDService[] services = this.manager.getServices();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < services.length; ++i) {
            String serviceName = services[i].getQName().getLocalPart();
            buf.append(serviceName);
            if (i == services.length - 1) continue;
            buf.append(",");
        }
        ContainerUsageStartPacketV2 packet = new ContainerUsageStartPacketV2();
        packet.setHostIP(this.getContainerHost());
        packet.setContainerID(this.manager.hashCode());
        packet.setContainerType(UsageConfig.getContainerType());
        packet.setServiceList(buf.toString());
        packet.sendPacket(this.getTargets());
    }

    void sendStopPacket() {
        long uptime = (System.currentTimeMillis() - this.startTime) / 1000L;
        WSDDService[] services = this.manager.getServices();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < services.length; ++i) {
            if (!ServiceManager.isServiceInitialized(services[i].getServiceDesc())) continue;
            if (buf.length() > 0) {
                buf.append(",");
            }
            String serviceName = services[i].getQName().getLocalPart();
            buf.append(serviceName);
        }
        ContainerUsageStopPacketV2 packet = new ContainerUsageStopPacketV2();
        packet.setHostIP(this.getContainerHost());
        packet.setContainerID(this.manager.hashCode());
        packet.setContainerType(UsageConfig.getContainerType());
        packet.setUptime((int)uptime);
        packet.setServiceList(buf.toString());
        packet.sendPacket(this.getTargets());
    }
}

