/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.tools.jndi;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.globus.wsrf.tools.jndi.Environment;
import org.globus.wsrf.tools.jndi.Resource;
import org.globus.wsrf.tools.jndi.ResourceLink;

public class ConfigContext {
    protected Map subContexts = new HashMap();
    protected Map environmentEntries = new HashMap();
    protected Map resourceEntries = new HashMap();
    protected Map resourceLinks = new HashMap();
    protected String name = null;
    protected boolean global;

    public ConfigContext() {
        this(false);
    }

    public ConfigContext(boolean global) {
        this.global = global;
    }

    public boolean isGlobal() {
        return this.global;
    }

    public void setGlobal(boolean global) {
        this.global = global;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addEnvironment(Environment environment) {
        this.environmentEntries.put(environment.getName(), environment);
    }

    public Environment getEnvironment(String name) {
        return (Environment)this.environmentEntries.get(name);
    }

    public Set getEnvironmentNames() {
        return this.environmentEntries.keySet();
    }

    public void addResource(Resource resource) {
        this.resourceEntries.put(resource.getName(), resource);
    }

    public Resource getResource(String name) {
        return (Resource)this.resourceEntries.get(name);
    }

    public Set getResourceNames() {
        return this.resourceEntries.keySet();
    }

    public void addSubContext(ConfigContext context) {
        this.subContexts.put(context.getName(), context);
    }

    public ConfigContext getSubContext(String name) {
        return (ConfigContext)this.subContexts.get(name);
    }

    public Set getSubContextNames() {
        return this.subContexts.keySet();
    }

    public void removeSubContext(String name) {
        this.subContexts.remove(name);
    }

    public void addResourceLink(ResourceLink link) {
        this.resourceLinks.put(link.getName(), link);
    }

    public ResourceLink getResourceLink(String name) {
        return (ResourceLink)this.resourceLinks.get(name);
    }

    public Set getResourceLinkNames() {
        return this.resourceLinks.keySet();
    }

    public String toString() {
        StringBuffer out = new StringBuffer();
        if (this.global) {
            out.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n");
            out.append("<jndiConfig xmlns=\"http://wsrf.globus.org/jndi/config\">\r\n");
            out.append("    <global>\r\n");
        } else {
            out.append("    <service name=\"");
            out.append(this.name);
            out.append("\">\r\n");
        }
        Set names = this.getEnvironmentNames();
        Iterator nameIterator = names.iterator();
        while (nameIterator.hasNext()) {
            out.append(((Environment)this.environmentEntries.get(nameIterator.next())).toString());
        }
        names = this.getResourceNames();
        nameIterator = names.iterator();
        while (nameIterator.hasNext()) {
            out.append(((Resource)this.resourceEntries.get(nameIterator.next())).toString());
        }
        names = this.getResourceLinkNames();
        nameIterator = names.iterator();
        while (nameIterator.hasNext()) {
            out.append(((ResourceLink)this.resourceLinks.get(nameIterator.next())).toString());
        }
        if (this.global) {
            out.append("    </global>\r\n");
            names = this.getSubContextNames();
            nameIterator = names.iterator();
            while (nameIterator.hasNext()) {
                out.append(((ConfigContext)this.subContexts.get(nameIterator.next())).toString());
            }
            out.append("</jndiConfig>\r\n");
        } else {
            out.append("    </service>\r\n");
        }
        return out.toString();
    }
}

