/*
 * Decompiled with CFR 0.152.
 */
package org.globus.rsl;

import java.util.Map;
import org.globus.rsl.RslEvaluationException;
import org.globus.rsl.Value;

public class Binding {
    protected String _name;
    protected Value _value;

    public Binding(String name, Value value) {
        this._name = name;
        this._value = value;
    }

    public Binding(String name, String value) {
        this._name = name;
        this._value = new Value(value);
    }

    public String getName() {
        return this._name;
    }

    public Value getValue() {
        return this._value;
    }

    public Binding evaluate(Map symbolTable) throws RslEvaluationException {
        String strValue = this._value.evaluate(symbolTable);
        return new Binding(this.getName(), new Value(strValue));
    }

    public String toRSL(boolean explicitConcat) {
        StringBuffer buf = new StringBuffer();
        this.toRSL(buf, explicitConcat);
        return buf.toString();
    }

    public void toRSL(StringBuffer buf, boolean explicitConcat) {
        buf.append("(");
        buf.append(this.getName());
        buf.append(" ");
        this.getValue().toRSL(buf, explicitConcat);
        buf.append(")");
    }

    public String toString() {
        return this.toRSL(true);
    }
}

