/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.authorization.client.proxy;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.gcube.common.authorization.client.Binder;
import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.client.exceptions.ObjectNotFound;
import org.gcube.common.authorization.client.proxy.AuthorizationEntryCache;
import org.gcube.common.authorization.client.proxy.AuthorizationProxy;
import org.gcube.common.authorization.client.proxy.Utils;
import org.gcube.common.authorization.library.AuthorizationEntry;
import org.gcube.common.authorization.library.Policies;
import org.gcube.common.authorization.library.QualifiersList;
import org.gcube.common.authorization.library.enpoints.AuthorizationEndpoint;
import org.gcube.common.authorization.library.enpoints.AuthorizationEndpointScanner;
import org.gcube.common.authorization.library.policies.Policy;
import org.gcube.common.authorization.library.provider.ContainerInfo;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.authorization.library.provider.ServiceInfo;
import org.gcube.common.authorization.library.provider.UserInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAuthorizationProxy
implements AuthorizationProxy {
    private static Logger log = LoggerFactory.getLogger(AuthorizationProxy.class);
    private static Map<String, AuthorizationEntryCache> cache = Collections.synchronizedMap(new WeakHashMap());
    private Map<Integer, AuthorizationEndpoint> endpoints = AuthorizationEndpointScanner.endpoints();

    private String getInternalEnpoint(int infrastructureHash) {
        StringBuilder endpoint = new StringBuilder("http://").append(this.getEndpoint(infrastructureHash).getHost()).append(":").append(this.getEndpoint(infrastructureHash).getPort()).append("/authorization-service/gcube/service");
        return endpoint.toString();
    }

    @Override
    public String generateServiceToken(ServiceInfo client) throws Exception {
        String methodPath = "/token/service";
        int infrastructureHash = Utils.getInfrastructureHashFromToken(SecurityTokenProvider.instance.get());
        StringBuilder callUrl = new StringBuilder(this.getInternalEnpoint(infrastructureHash)).append(methodPath);
        URL url = new URL(callUrl.toString());
        HttpURLConnection connection = this.makeRequest(url, "PUT", true);
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setRequestProperty("Content-type", "application/xml");
        try (BufferedOutputStream os = new BufferedOutputStream(connection.getOutputStream());){
            Binder.getContext().createMarshaller().marshal((Object)client, (OutputStream)os);
        }
        log.debug("response code for " + callUrl.toString() + " is " + connection.getResponseCode() + " " + connection.getResponseMessage());
        if (connection.getResponseCode() != 200) {
            throw new Exception("error contacting authorization service");
        }
        String token = "";
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)connection.getContent()));){
            String line;
            StringBuilder result = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                result.append(line);
            }
            token = result.toString();
        }
        return Utils.addInfrastructureHashToToken(token, infrastructureHash);
    }

    @Override
    public String generateUserToken(UserInfo client, String context) throws Exception {
        String methodPath = "/token/user";
        int infrastructureHash = Utils.getInfrastructureHashfromContext(context);
        StringBuilder callUrl = new StringBuilder(this.getInternalEnpoint(infrastructureHash)).append(methodPath).append("?").append(Constants.CONTEXT_PARAM).append("=").append(context);
        URL url = new URL(callUrl.toString());
        HttpURLConnection connection = this.makeRequest(url, "PUT", false);
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setRequestProperty("Content-type", "application/xml");
        try (BufferedOutputStream os = new BufferedOutputStream(connection.getOutputStream());){
            Binder.getContext().createMarshaller().marshal((Object)client, (OutputStream)os);
        }
        log.debug("response code for " + callUrl.toString() + " is " + connection.getResponseCode() + " " + connection.getResponseMessage());
        if (connection.getResponseCode() != 200) {
            throw new Exception("error contacting authorization service");
        }
        String token = "";
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)connection.getContent()));){
            String line;
            StringBuilder result = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                result.append(line);
            }
            token = result.toString();
        }
        return Utils.addInfrastructureHashToToken(token, infrastructureHash);
    }

    @Override
    public String generateApiKey(String apiQualifier) throws Exception {
        String methodPath = String.format("/apikey?qualifier=%s", apiQualifier);
        int infrastructureHash = Utils.getInfrastructureHashFromToken(SecurityTokenProvider.instance.get());
        StringBuilder callUrl = new StringBuilder(this.getInternalEnpoint(infrastructureHash)).append(methodPath);
        URL url = new URL(callUrl.toString());
        HttpURLConnection connection = this.makeRequest(url, "PUT", true);
        connection.setDoInput(true);
        connection.setRequestProperty("Content-type", "application/xml");
        log.debug("response code for " + callUrl.toString() + " is " + connection.getResponseCode() + " " + connection.getResponseMessage());
        if (connection.getResponseCode() != 200) {
            throw new Exception("error contacting authorization service");
        }
        String token = "";
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)connection.getContent()));){
            String line;
            StringBuilder result = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                result.append(line);
            }
            token = result.toString();
        }
        return Utils.addInfrastructureHashToToken(token, infrastructureHash);
    }

    @Override
    public Map<String, String> retrieveApiKeys() throws Exception {
        String methodPath = "/apikey/";
        int infrastructureHash = Utils.getInfrastructureHashFromToken(SecurityTokenProvider.instance.get());
        StringBuilder callUrl = new StringBuilder(this.getInternalEnpoint(infrastructureHash)).append(methodPath);
        URL url = new URL(callUrl.toString());
        HttpURLConnection connection = this.makeRequest(url, "GET", true);
        connection.setDoInput(true);
        connection.setDoOutput(true);
        if (connection.getResponseCode() != 200) {
            throw new Exception("error retrieving keys (error code is " + connection.getResponseCode() + ")");
        }
        if (connection.getContentLengthLong() <= 0L) {
            return Collections.emptyMap();
        }
        try (InputStream stream = (InputStream)connection.getContent();){
            QualifiersList entries = (QualifiersList)Binder.getContext().createUnmarshaller().unmarshal(stream);
            Map map = entries.getQualifiers();
            return map;
        }
    }

    @Override
    public String requestActivation(ContainerInfo container, String context) throws Exception {
        String methodPath = "/token/node";
        int infrastructureHash = Utils.getInfrastructureHashfromContext(context);
        StringBuilder callUrl = new StringBuilder(this.getInternalEnpoint(infrastructureHash)).append(methodPath).append("?").append(Constants.CONTEXT_PARAM).append("=").append(context);
        URL url = new URL(callUrl.toString());
        HttpURLConnection connection = this.makeRequest(url, "PUT", false);
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setRequestProperty("Content-type", "application/xml");
        try (BufferedOutputStream os = new BufferedOutputStream(connection.getOutputStream());){
            Binder.getContext().createMarshaller().marshal((Object)container, (OutputStream)os);
        }
        log.debug("response code is " + connection.getResponseCode());
        if (connection.getResponseCode() != 200) {
            throw new Exception("error contacting authorization service");
        }
        String token = "";
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)connection.getContent()));){
            String line;
            StringBuilder result = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                result.append(line);
            }
            token = result.toString();
        }
        return Utils.addInfrastructureHashToToken(token, infrastructureHash);
    }

    @Override
    public AuthorizationEntry get(String token) throws ObjectNotFound, Exception {
        if (cache.containsKey(token) && cache.get(token).isValid()) {
            return cache.get(token).getEntry();
        }
        String methodPath = "/token/";
        StringBuilder callUrl = new StringBuilder(this.getInternalEnpoint(Utils.getInfrastructureHashFromToken(token))).append("/token/").append(Utils.getRealToken(token));
        URL url = new URL(callUrl.toString());
        HttpURLConnection connection = this.makeRequest(url, "GET", false);
        connection.setDoInput(true);
        if (connection.getResponseCode() == 404) {
            throw new ObjectNotFound("token " + token + " not found");
        }
        if (connection.getResponseCode() != 200) {
            throw new Exception("error contacting authorization service (error code is " + connection.getResponseCode() + ")");
        }
        if (connection.getContentLengthLong() <= 0L) {
            return null;
        }
        try (InputStream stream = (InputStream)connection.getContent();){
            AuthorizationEntry entry;
            AuthorizationEntry authorizationEntry = entry = (AuthorizationEntry)Binder.getContext().createUnmarshaller().unmarshal(stream);
            return authorizationEntry;
        }
    }

    @Override
    public void addPolicies(List<Policy> policies) throws Exception {
        String methodPath = "/policyManager";
        StringBuilder callUrl = new StringBuilder(this.getInternalEnpoint(Utils.getInfrastructureHashFromToken(SecurityTokenProvider.instance.get()))).append("/policyManager");
        URL url = new URL(callUrl.toString());
        HttpURLConnection connection = this.makeRequest(url, "POST", true);
        connection.setDoOutput(true);
        connection.setRequestProperty("Content-type", "application/xml");
        try (BufferedOutputStream os = new BufferedOutputStream(connection.getOutputStream());){
            Binder.getContext().createMarshaller().marshal((Object)new Policies(policies), (OutputStream)os);
        }
        if (connection.getResponseCode() != 200) {
            throw new Exception("error adding policies");
        }
    }

    @Override
    public void removePolicies(long ... ids) throws Exception {
        String methodPath = "/policyManager/";
        StringBuilder callUrl = new StringBuilder(this.getInternalEnpoint(Utils.getInfrastructureHashFromToken(SecurityTokenProvider.instance.get()))).append("/policyManager/");
        ArrayList<Long> errorIds = new ArrayList<Long>();
        for (long id : ids) {
            URL url = new URL(callUrl.toString() + id);
            HttpURLConnection connection = this.makeRequest(url, "DELETE", true);
            if (connection.getResponseCode() == 200) continue;
            errorIds.add(id);
        }
        if (!errorIds.isEmpty()) {
            throw new Exception("error removing policies with ids: " + errorIds);
        }
    }

    @Override
    public List<Policy> getPolicies(String context) throws Exception {
        String methodPath = "/policyManager/";
        StringBuilder callUrl = new StringBuilder(this.getInternalEnpoint(Utils.getInfrastructureHashfromContext(context))).append("/policyManager/").append("?").append(Constants.CONTEXT_PARAM).append("=").append(context);
        URL url = new URL(callUrl.toString());
        HttpURLConnection connection = this.makeRequest(url, "GET", true);
        connection.setDoInput(true);
        if (connection.getResponseCode() != 200) {
            throw new Exception("error retrieving policies");
        }
        if (connection.getContentLengthLong() <= 0L) {
            return Collections.emptyList();
        }
        try (InputStreamReader stream = new InputStreamReader((InputStream)connection.getContent());){
            Policies policies = (Policies)Binder.getContext().createUnmarshaller().unmarshal((Reader)stream);
            List list = policies.getPolicies();
            return list;
        }
    }

    private HttpURLConnection makeRequest(URL url, String method, boolean includeTokenInHeader) throws Exception {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        if (includeTokenInHeader) {
            if (SecurityTokenProvider.instance.get() == null) {
                throw new RuntimeException("null token passed");
            }
            connection.setRequestProperty("gcube-token", Utils.getRealToken(SecurityTokenProvider.instance.get()));
        }
        connection.setRequestMethod(method);
        return connection;
    }

    @Override
    public AuthorizationEndpoint getEndpoint(int infrastructureHash) {
        if (!this.endpoints.containsKey(infrastructureHash)) {
            throw new RuntimeException("Authorization Endpoint not found for the required infrastructure");
        }
        return this.endpoints.get(infrastructureHash);
    }

    @Override
    public void setEndpoint(Map<Integer, AuthorizationEndpoint> endpoints) {
        this.endpoints = endpoints;
    }
}

