/*
 * Decompiled with CFR 0.152.
 */
package ise.antelope.tasks;

import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class HostnameTask
extends Task {
    private String property = "hostname";
    private boolean useIp = false;
    private String host = null;
    private String nIC = null;
    private boolean failOnError = false;
    private boolean showAll = false;
    private boolean canonical = true;
    private int outputType = 0;
    public static final int HOST = 0;
    public static final int IP = 1;
    public static final int CANON = 2;

    public void setProperty(String p) {
        this.property = p;
    }

    public void setShowip(boolean b) {
        this.useIp = b;
        this.outputType = 1;
    }

    public void setFailonerror(boolean b) {
        this.failOnError = b;
    }

    public void setNic(String n) {
        this.nIC = n;
    }

    public void setShowall(boolean b) {
        this.showAll = b;
    }

    public void setShowcanonical(boolean b) {
        this.canonical = b;
        this.outputType = 2;
    }

    public void execute() {
        try {
            if (this.showAll) {
                StringBuffer hostnames = new StringBuffer();
                Enumeration<NetworkInterface> nics = NetworkInterface.getNetworkInterfaces();
                while (nics.hasMoreElements()) {
                    NetworkInterface nic = nics.nextElement();
                    hostnames.append(nic.getName() + ":");
                    Enumeration<InetAddress> addrs = nic.getInetAddresses();
                    while (addrs.hasMoreElements()) {
                        InetAddress addr = addrs.nextElement();
                        String hostname = this.getAddress(addr);
                        if (hostname != null && hostname.trim().length() > 0) {
                            hostnames.append(hostname);
                        }
                        if (!addrs.hasMoreElements()) continue;
                        hostnames.append(", ");
                    }
                    if (!nics.hasMoreElements()) continue;
                    hostnames.append(", ");
                }
                this.getProject().setProperty(this.property, hostnames.toString());
            } else if (this.nIC != null) {
                StringBuffer hostnames = new StringBuffer();
                Enumeration<NetworkInterface> nics = NetworkInterface.getNetworkInterfaces();
                while (nics.hasMoreElements()) {
                    NetworkInterface nic = nics.nextElement();
                    if (!this.nIC.equals(nic.getName())) continue;
                    hostnames.append(nic.getName() + ":");
                    Enumeration<InetAddress> addrs = nic.getInetAddresses();
                    while (addrs.hasMoreElements()) {
                        InetAddress addr = addrs.nextElement();
                        String hostname = this.getAddress(addr);
                        if (hostname != null && hostname.trim().length() > 0) {
                            hostnames.append(hostname);
                        }
                        if (!addrs.hasMoreElements()) continue;
                        hostnames.append(", ");
                    }
                }
                this.getProject().setProperty(this.property, hostnames.toString());
            } else {
                InetAddress addr = InetAddress.getLocalHost();
                String hostname = this.getAddress(addr);
                this.getProject().setProperty(this.property, hostname);
            }
        }
        catch (IOException e) {
            if (this.failOnError) {
                throw new BuildException(e.getMessage());
            }
            this.log(e.getMessage());
        }
    }

    private String getAddress(InetAddress addr) {
        String hostname = "";
        switch (this.outputType) {
            case 1: {
                hostname = addr.getHostAddress();
                break;
            }
            case 2: {
                hostname = addr.getCanonicalHostName();
                break;
            }
            default: {
                hostname = addr.getHostName();
            }
        }
        return hostname;
    }
}

