/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.commons.state;

import gr.uoa.di.madgik.commons.configuration.ConfigurationManager;
import gr.uoa.di.madgik.commons.state.store.StateStoreInfo;
import gr.uoa.di.madgik.commons.state.store.data.ISerializable;
import gr.uoa.di.madgik.commons.state.store.data.StateStoreData;
import gr.uoa.di.madgik.commons.state.store.registry.StateStoreRegistry;
import gr.uoa.di.madgik.commons.state.store.registry.StateStoreRegistryKey;
import gr.uoa.di.madgik.commons.utils.FileUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StateManager {
    private static Logger logger;
    private static StateStoreInfo Info;
    private static StateStoreRegistry Registry;

    public static String GetStateStoreInfo() {
        return Info.toString();
    }

    public static synchronized boolean Delete(String Key) throws Exception {
        if (!StateManager.Contains(Key).booleanValue()) {
            return false;
        }
        return Registry.Delete(Key, Info);
    }

    public static synchronized Boolean Contains(String key) {
        Boolean entryexists = Registry.Contains(key);
        if (!entryexists.booleanValue()) {
            return false;
        }
        if (!Registry.Get(key).IsActive().booleanValue()) {
            return false;
        }
        return true;
    }

    public static synchronized StateStoreRegistryKey.EntryType ContainsType(String key) throws Exception {
        if (StateManager.Contains(key).booleanValue()) {
            return Registry.Get(key).GetTypeOfEntry();
        }
        throw new Exception("Key " + key + " not found");
    }

    private static Object Get(String key) throws Exception {
        if (!StateManager.Contains(key).booleanValue()) {
            return null;
        }
        StateStoreRegistryKey entry = Registry.Get(key);
        if (entry == null) {
            return null;
        }
        Object obj = null;
        StateStoreData ssdata = new StateStoreData(Info);
        switch (entry.GetTypeOfEntry()) {
            case Alphanumeric: {
                obj = ssdata.GetAlphanumeric(entry);
                break;
            }
            case Bytearray: {
                obj = ssdata.GetByteArray(entry);
                break;
            }
            case File: {
                obj = ssdata.GetFile(entry);
                break;
            }
            case ISerializable: {
                obj = ssdata.GetISerializable(entry);
                break;
            }
            case Serializable: {
                obj = ssdata.GetSerializable(entry);
            }
        }
        return obj;
    }

    public static synchronized String GetAlphanumeric(String Key) throws Exception {
        Object obj = StateManager.Get(Key);
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        throw new Exception("Retrieved entry is not of expected type");
    }

    public static synchronized File GetFile(String Key) throws Exception {
        Object obj = StateManager.Get(Key);
        if (obj == null) {
            return null;
        }
        if (obj instanceof File) {
            return (File)obj;
        }
        throw new Exception("Retrieved entry is not of expected type");
    }

    public static synchronized byte[] GetByteArray(String Key) throws Exception {
        Object obj = StateManager.Get(Key);
        if (obj == null) {
            return null;
        }
        if (obj instanceof byte[]) {
            return (byte[])obj;
        }
        throw new Exception("Retrieved entry is not of expected type");
    }

    public static synchronized Serializable GetSerializable(String Key) throws Exception {
        Object obj = StateManager.Get(Key);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Serializable) {
            return (Serializable)obj;
        }
        throw new Exception("Retrieved entry is not of expected type");
    }

    public static synchronized ISerializable GetISerializable(String Key) throws Exception {
        Object obj = StateManager.Get(Key);
        if (obj == null) {
            return null;
        }
        if (obj instanceof ISerializable) {
            return (ISerializable)obj;
        }
        throw new Exception("Retrieved entry is not of expected type");
    }

    public static synchronized Boolean Put(String key, String Alphanumeric) throws Exception {
        if (Alphanumeric == null) {
            throw new NullPointerException("Provided object not set");
        }
        StateStoreRegistryKey Key = new StateStoreRegistryKey(key, 0L, 0L, 0L, StateStoreRegistryKey.EntryType.Alphanumeric);
        StateStoreData ssdata = new StateStoreData(Info);
        ssdata.Put(Key, Alphanumeric);
        return Registry.Put(Key, Info);
    }

    public static synchronized Boolean Put(String key, byte[] bytearray) throws Exception {
        if (bytearray == null) {
            throw new NullPointerException("Provided object not set");
        }
        StateStoreRegistryKey Key = new StateStoreRegistryKey(key, 0L, 0L, 0L, StateStoreRegistryKey.EntryType.Bytearray);
        StateStoreData ssdata = new StateStoreData(Info);
        ssdata.Put(Key, bytearray);
        return Registry.Put(Key, Info);
    }

    public static synchronized Boolean Put(String key, ISerializable obj) throws Exception {
        if (obj == null) {
            throw new NullPointerException("Provided object not set");
        }
        StateStoreRegistryKey Key = new StateStoreRegistryKey(key, 0L, 0L, 0L, StateStoreRegistryKey.EntryType.ISerializable);
        StateStoreData ssdata = new StateStoreData(Info);
        ssdata.Put(Key, obj);
        return Registry.Put(Key, Info);
    }

    public static synchronized Boolean Put(String key, Serializable obj) throws Exception {
        if (obj == null) {
            throw new NullPointerException("Provided object not set");
        }
        StateStoreRegistryKey Key = new StateStoreRegistryKey(key, 0L, 0L, 0L, StateStoreRegistryKey.EntryType.Serializable);
        StateStoreData ssdata = new StateStoreData(Info);
        ssdata.Put(Key, obj);
        return Registry.Put(Key, Info);
    }

    public static synchronized Boolean Put(String key, File file) throws Exception {
        if (!file.exists() || file.isDirectory()) {
            throw new FileNotFoundException("File " + file + " not found");
        }
        StateStoreRegistryKey Key = new StateStoreRegistryKey(key, 0L, 0L, 0L, StateStoreRegistryKey.EntryType.File);
        StateStoreData ssdata = new StateStoreData(Info);
        ssdata.Put(Key, file);
        return Registry.Put(Key, Info);
    }

    public static synchronized void Compact() throws Exception {
        File registryFile = null;
        File dataFile = null;
        try {
            registryFile = Registry.MoveToClean();
            StateStoreData ssdata = new StateStoreData(Info);
            dataFile = ssdata.MoveToClean(Registry.GetDictionary());
            for (Map.Entry<String, StateStoreRegistryKey> entry : Registry.GetDictionary().entrySet()) {
                Registry.StoreUpdate(new StateStoreInfo(registryFile, dataFile), entry.getValue(), true);
            }
            Info.GetEntryDataFile().delete();
            Info.GetEntryRegistryFile().delete();
            FileUtils.Copy(registryFile, Info.GetEntryRegistryFile());
            FileUtils.Copy(dataFile, Info.GetEntryDataFile());
            registryFile.delete();
            dataFile.delete();
        }
        catch (Exception ex) {
            if (registryFile != null) {
                registryFile.delete();
            }
            if (dataFile != null) {
                dataFile.delete();
            }
            throw ex;
        }
    }

    static {
        block3: {
            logger = Logger.getLogger(StateManager.class.getName());
            Info = null;
            Registry = null;
            try {
                Info = (StateStoreInfo)ConfigurationManager.GetParameter("StateManager.StateStoreInfo");
                Registry = new StateStoreRegistry();
                Registry.Deserialize(Info);
                if (ConfigurationManager.GetBooleanParameter("StateManager.CleanUpOnInit").booleanValue()) {
                    StateManager.Compact();
                }
            }
            catch (Exception ex) {
                if (!logger.isLoggable(Level.WARNING)) break block3;
                logger.log(Level.WARNING, "Could not initialize state manager", ex);
            }
        }
    }
}

