/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.security.authentication.secureconv.service;

import java.rmi.RemoteException;
import javax.security.auth.Subject;
import javax.xml.soap.SOAPElement;
import org.apache.axis.MessageContext;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.axis.types.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.gsi.gssapi.GSSConstants;
import org.globus.gsi.jaas.JaasGssUtil;
import org.globus.util.Base64;
import org.globus.util.I18n;
import org.globus.ws.sc.SecurityContextTokenType;
import org.globus.ws.trust.BinaryExchangeType;
import org.globus.ws.trust.RequestSecurityTokenResponseType;
import org.globus.ws.trust.RequestSecurityTokenType;
import org.globus.ws.trust.holders.RequestSecurityTokenResponseTypeHolder;
import org.globus.wsrf.Resource;
import org.globus.wsrf.ResourceContext;
import org.globus.wsrf.ResourceContextException;
import org.globus.wsrf.ResourceException;
import org.globus.wsrf.ResourceKey;
import org.globus.wsrf.encoding.ObjectSerializer;
import org.globus.wsrf.impl.ResourceContextImpl;
import org.globus.wsrf.impl.SimpleResourceKey;
import org.globus.wsrf.impl.security.authentication.secureconv.SecureConversationMessage;
import org.globus.wsrf.impl.security.authentication.secureconv.service.AuthenticationServiceConstants;
import org.globus.wsrf.impl.security.authentication.secureconv.service.SecurityContext;
import org.globus.wsrf.impl.security.authentication.secureconv.service.SecurityContextHome;
import org.globus.wsrf.impl.security.descriptor.SecurityPropertiesHelper;
import org.globus.wsrf.security.SecurityException;
import org.globus.wsrf.security.SecurityManager;
import org.globus.wsrf.security.impl.secconv.BinaryExchangeFaultType;
import org.globus.wsrf.security.impl.secconv.EncodingTypeNotSupportedFaultType;
import org.globus.wsrf.security.impl.secconv.InvalidContextIdFaultType;
import org.globus.wsrf.security.impl.secconv.MalformedMessageFaultType;
import org.globus.wsrf.security.impl.secconv.RequestTypeNotSupportedFaultType;
import org.globus.wsrf.security.impl.secconv.SecureConversation;
import org.globus.wsrf.security.impl.secconv.TokenTypeNotSupportedFaultType;
import org.globus.wsrf.security.impl.secconv.ValueTypeNotSupportedFaultType;
import org.globus.wsrf.utils.AddressingUtils;
import org.globus.wsrf.utils.FaultHelper;
import org.gridforum.jgss.ExtendedGSSContext;
import org.gridforum.jgss.ExtendedGSSManager;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSManager;

public class AuthenticationServiceImpl
implements AuthenticationServiceConstants,
SecureConversation {
    static Log logger = LogFactory.getLog(AuthenticationServiceImpl.class.getName());
    private static I18n i18n = I18n.getI18n("org.globus.wsrf.impl.security.error", AuthenticationServiceImpl.class.getClassLoader());

    protected GSSCredential getCredential(String servicePath, Resource resource) throws SecurityException {
        Subject subject = SecurityManager.getManager().getSubject(servicePath, resource);
        logger.debug("Credential on server side " + subject);
        if (subject == null) {
            throw new SecurityException(i18n.getMessage("invalidCredentials"));
        }
        return JaasGssUtil.getCredential(subject);
    }

    private String getTargetService() {
        MessageContext ctx = MessageContext.getCurrentContext();
        String url = (String)ctx.getProperty("targetService");
        if (url == null) {
            url = ctx.getTargetService();
        }
        logger.debug("Target service " + url);
        return url;
    }

    private Resource getTargetResource(String servicePath) throws SecurityException {
        logger.debug("Service path is " + servicePath);
        ResourceContext ctx = null;
        try {
            ctx = ResourceContext.getResourceContext();
        }
        catch (ResourceContextException exp) {
            throw new SecurityException(exp);
        }
        ((ResourceContextImpl)ctx).setService(servicePath);
        Resource resource = null;
        try {
            resource = ctx.getResource();
        }
        catch (ResourceContextException exp) {
            resource = null;
            logger.debug("Error getting resource/may not exist", exp);
        }
        catch (ResourceException exp) {
            resource = null;
            logger.debug("Error getting resource/may not exist", exp);
        }
        logger.debug("Resource is null: " + (resource == null));
        return resource;
    }

    public void requestSecurityTokenResponse(RequestSecurityTokenResponseTypeHolder response) throws RemoteException, MalformedMessageFaultType, InvalidContextIdFaultType, TokenTypeNotSupportedFaultType, ValueTypeNotSupportedFaultType, EncodingTypeNotSupportedFaultType, BinaryExchangeFaultType, RequestTypeNotSupportedFaultType {
        RequestSecurityTokenResponseType request = response.value;
        SecurityContext securityContext = null;
        ResourceContext ctx = null;
        SimpleResourceKey key = null;
        MessageElement[] requestElements = request.get_any();
        SecureConversationMessage message = new SecureConversationMessage(requestElements);
        BinaryExchangeType gssToken = message.parseMessage();
        String contextId = request.getContext().getSchemeSpecificPart();
        try {
            ctx = ResourceContext.getResourceContext();
            SecurityContextHome home = (SecurityContextHome)ctx.getResourceHome();
            logger.debug("Context id is " + contextId);
            key = new SimpleResourceKey(home.getKeyTypeName(), contextId);
            securityContext = (SecurityContext)home.find(key);
        }
        catch (Exception e) {
            InvalidContextIdFaultType fault = new InvalidContextIdFaultType();
            FaultHelper faultHelper = new FaultHelper(fault);
            faultHelper.addFaultCause(e);
            throw fault;
        }
        GSSContext context = securityContext.getContext();
        byte[] inToken = Base64.decode(gssToken.get_value().getBytes());
        try {
            byte[] outToken = context.acceptSecContext(inToken, 0, inToken.length);
            if (outToken != null && context.isEstablished()) {
                SecurityContextTokenType contextToken = this.createSecurityContextToken(request.getContext(), ctx, key);
                gssToken.set_value(new String(Base64.encode(outToken)));
                request.set_any(SecureConversationMessage.createMessage(gssToken, contextToken));
            } else if (outToken != null) {
                gssToken.set_value(new String(Base64.encode(outToken)));
                request.set_any(SecureConversationMessage.createMessage(gssToken));
            } else if (context.isEstablished()) {
                SecurityContextTokenType contextToken = this.createSecurityContextToken(request.getContext(), ctx, key);
                request.set_any(SecureConversationMessage.createMessage(contextToken));
            }
        }
        catch (Exception e) {
            BinaryExchangeFaultType fault = new BinaryExchangeFaultType();
            FaultHelper faultHelper = new FaultHelper(fault);
            faultHelper.addFaultCause(e);
            throw fault;
        }
    }

    private SecurityContextTokenType createSecurityContextToken(URI contextId, ResourceContext ctx, SimpleResourceKey key) throws Exception {
        SecurityContextTokenType contextToken = new SecurityContextTokenType();
        contextToken.setIdentifier(contextId);
        EndpointReferenceType contextEPR = AddressingUtils.createEndpointReference(ctx.getServiceURL().toString(), (ResourceKey)key);
        SOAPElement contextEPRElement = ObjectSerializer.toSOAPElement(contextEPR, SecureConversationMessage.CONTEXT_EPR_QNAME);
        contextToken.set_any(new MessageElement[]{(MessageElement)contextEPRElement});
        return contextToken;
    }

    public RequestSecurityTokenResponseType requestSecurityToken(RequestSecurityTokenType request) throws RemoteException, MalformedMessageFaultType, TokenTypeNotSupportedFaultType, ValueTypeNotSupportedFaultType, EncodingTypeNotSupportedFaultType, BinaryExchangeFaultType, RequestTypeNotSupportedFaultType {
        logger.debug("Enter requestSecurityToken");
        RequestSecurityTokenResponseType response = new RequestSecurityTokenResponseType();
        SecureConversationMessage message = new SecureConversationMessage(request.get_any());
        BinaryExchangeType gssToken = message.parseMessage();
        GSSManager manager = ExtendedGSSManager.getInstance();
        ExtendedGSSContext context = null;
        String servicePath = this.getTargetService();
        if (servicePath == null) {
            BinaryExchangeFaultType fault = new BinaryExchangeFaultType();
            FaultHelper faultHelper = new FaultHelper(fault);
            faultHelper.setDescription(i18n.getMessage("noTargetService"));
            throw fault;
        }
        try {
            Resource resource = this.getTargetResource(servicePath);
            context = (ExtendedGSSContext)manager.createContext(this.getCredential(servicePath, resource));
            logger.debug("Invoking secure service on " + servicePath);
            Integer reqContextLifetime = null;
            reqContextLifetime = SecurityPropertiesHelper.getContextLifetime(servicePath, resource);
            if (reqContextLifetime != null) {
                logger.debug("Setting context lifetime to " + reqContextLifetime);
                context.requestLifetime(reqContextLifetime);
            }
            Boolean rejectLimProxy = SecurityPropertiesHelper.getRejectLimitedProxyState(servicePath, resource);
            context.setOption(GSSConstants.REJECT_LIMITED_PROXY, rejectLimProxy);
            context.setOption(GSSConstants.ACCEPT_NO_CLIENT_CERTS, Boolean.TRUE);
            ResourceContext ctx = ResourceContext.getResourceContext();
            SecurityContextHome home = (SecurityContextHome)ctx.getResourceHome();
            SimpleResourceKey key = home.create(context);
            response.setContext(new URI("uuid", (String)key.getValue()));
            byte[] inToken = Base64.decode(gssToken.get_value().getBytes());
            byte[] outToken = context.acceptSecContext(inToken, 0, inToken.length);
            gssToken.set_value(new String(Base64.encode(outToken)));
            response.set_any(SecureConversationMessage.createMessage(gssToken));
        }
        catch (Exception e) {
            BinaryExchangeFaultType fault = new BinaryExchangeFaultType();
            FaultHelper faultHelper = new FaultHelper(fault);
            faultHelper.addFaultCause(e);
            throw fault;
        }
        return response;
    }
}

