/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQDispatcher;
import org.apache.activemq.FifoMessageDispatchChannel;
import org.apache.activemq.MessageDispatchChannel;
import org.apache.activemq.command.ActiveMQBytesMessage;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ConsumerId;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageDispatch;
import org.apache.activemq.command.ProducerId;
import org.apache.activemq.selector.SelectorParser;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.activemq.util.IntrospectionSupport;
import org.apache.activemq.util.JMSExceptionSupport;

public class ActiveMQInputStream
extends InputStream
implements ActiveMQDispatcher {
    private final ActiveMQConnection connection;
    private final ConsumerInfo info;
    private final MessageDispatchChannel unconsumedMessages = new FifoMessageDispatchChannel();
    private int deliveredCounter;
    private MessageDispatch lastDelivered;
    private boolean eosReached;
    private byte[] buffer;
    private int pos;
    private Map<String, Object> jmsProperties;
    private ProducerId producerId;
    private long nextSequenceId;
    private final long timeout;
    private boolean firstReceived;

    public ActiveMQInputStream(ActiveMQConnection connection, ConsumerId consumerId, ActiveMQDestination dest, String selector, boolean noLocal, String name, int prefetch, long timeout) throws JMSException {
        this.connection = connection;
        if (dest == null) {
            throw new InvalidDestinationException("Don't understand null destinations");
        }
        if (dest.isTemporary()) {
            String physicalName = dest.getPhysicalName();
            if (physicalName == null) {
                throw new IllegalArgumentException("Physical name of Destination should be valid: " + dest);
            }
            String connectionID = connection.getConnectionInfo().getConnectionId().getValue();
            if (physicalName.indexOf(connectionID) < 0) {
                throw new InvalidDestinationException("Cannot use a Temporary destination from another Connection");
            }
            if (connection.isDeleted(dest)) {
                throw new InvalidDestinationException("Cannot use a Temporary destination that has been deleted");
            }
        }
        if (timeout < -1L) {
            throw new IllegalArgumentException("Timeout must be >= -1");
        }
        this.timeout = timeout;
        this.info = new ConsumerInfo(consumerId);
        this.info.setSubscriptionName(name);
        selector = selector != null && selector.trim().length() != 0 ? "JMSType='org.apache.activemq.Stream' AND ( " + selector + " ) " : "JMSType='org.apache.activemq.Stream'";
        SelectorParser.parse(selector);
        this.info.setSelector(selector);
        this.info.setPrefetchSize(prefetch);
        this.info.setNoLocal(noLocal);
        this.info.setBrowser(false);
        this.info.setDispatchAsync(false);
        if (dest.getOptions() != null) {
            HashMap<String, String> options = new HashMap<String, String>(dest.getOptions());
            IntrospectionSupport.setProperties(this.info, options, "consumer.");
        }
        this.info.setDestination(dest);
        this.connection.addInputStream(this);
        this.connection.addDispatcher(this.info.getConsumerId(), this);
        this.connection.syncSendPacket(this.info);
        this.unconsumedMessages.start();
    }

    @Override
    public void close() throws IOException {
        if (!this.unconsumedMessages.isClosed()) {
            try {
                if (this.lastDelivered != null) {
                    MessageAck ack = new MessageAck(this.lastDelivered, 2, this.deliveredCounter);
                    this.connection.asyncSendPacket(ack);
                }
                this.dispose();
                this.connection.syncSendPacket(this.info.createRemoveCommand());
            }
            catch (JMSException e) {
                throw IOExceptionSupport.create((Exception)((Object)e));
            }
        }
    }

    public void dispose() {
        if (!this.unconsumedMessages.isClosed()) {
            this.unconsumedMessages.close();
            this.connection.removeDispatcher(this.info.getConsumerId());
            this.connection.removeInputStream(this);
        }
    }

    public Map<String, Object> getJMSProperties() throws IOException {
        if (this.jmsProperties == null) {
            this.fillBuffer();
        }
        return this.jmsProperties;
    }

    public ActiveMQMessage receive() throws JMSException, ReadTimeoutException {
        MessageDispatch md;
        this.checkClosed();
        try {
            if (this.firstReceived || this.timeout == -1L) {
                md = this.unconsumedMessages.dequeue(-1L);
                this.firstReceived = true;
            } else {
                md = this.unconsumedMessages.dequeue(this.timeout);
                if (md == null) {
                    throw new ReadTimeoutException();
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw JMSExceptionSupport.create(e);
        }
        if (md == null || this.unconsumedMessages.isClosed() || md.getMessage().isExpired()) {
            return null;
        }
        ++this.deliveredCounter;
        if (0.75 * (double)this.info.getPrefetchSize() <= (double)this.deliveredCounter) {
            MessageAck ack = new MessageAck(md, 2, this.deliveredCounter);
            this.connection.asyncSendPacket(ack);
            this.deliveredCounter = 0;
            this.lastDelivered = null;
        } else {
            this.lastDelivered = md;
        }
        return (ActiveMQMessage)md.getMessage();
    }

    protected void checkClosed() throws IllegalStateException {
        if (this.unconsumedMessages.isClosed()) {
            throw new IllegalStateException("The Consumer is closed");
        }
    }

    @Override
    public int read() throws IOException {
        this.fillBuffer();
        if (this.eosReached || this.buffer.length == 0) {
            return -1;
        }
        return this.buffer[this.pos++] & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.fillBuffer();
        if (this.eosReached || this.buffer.length == 0) {
            return -1;
        }
        int max = Math.min(len, this.buffer.length - this.pos);
        System.arraycopy(this.buffer, this.pos, b, off, max);
        this.pos += max;
        return max;
    }

    private void fillBuffer() throws IOException {
        if (this.eosReached || this.buffer != null && this.buffer.length > this.pos) {
            return;
        }
        try {
            block11: {
                ActiveMQMessage m;
                while ((m = this.receive()) != null && m.getDataStructureType() == 24) {
                    long producerSequenceId = m.getMessageId().getProducerSequenceId();
                    if (this.producerId == null) {
                        if (producerSequenceId != 0L) continue;
                        ++this.nextSequenceId;
                        this.producerId = m.getMessageId().getProducerId();
                    } else {
                        if (!m.getMessageId().getProducerId().equals(this.producerId)) {
                            throw new IOException("Received an unexpected message: invalid producer: " + m);
                        }
                        if (producerSequenceId != this.nextSequenceId++) {
                            throw new IOException("Received an unexpected message: expected ID: " + (this.nextSequenceId - 1L) + " but was: " + producerSequenceId + " for message: " + m);
                        }
                    }
                    ActiveMQBytesMessage bm = (ActiveMQBytesMessage)m;
                    this.buffer = new byte[(int)bm.getBodyLength()];
                    bm.readBytes(this.buffer);
                    this.pos = 0;
                    if (this.jmsProperties == null) {
                        this.jmsProperties = Collections.unmodifiableMap(new HashMap<String, Object>(bm.getProperties()));
                    }
                    break block11;
                }
                this.eosReached = true;
                if (this.jmsProperties == null) {
                    this.jmsProperties = Collections.emptyMap();
                }
            }
            return;
        }
        catch (JMSException e) {
            this.eosReached = true;
            if (this.jmsProperties == null) {
                this.jmsProperties = Collections.emptyMap();
            }
            throw IOExceptionSupport.create((Exception)((Object)e));
        }
    }

    @Override
    public void dispatch(MessageDispatch md) {
        this.unconsumedMessages.enqueue(md);
    }

    public String toString() {
        return "ActiveMQInputStream { value=" + this.info.getConsumerId() + ", producerId=" + this.producerId + " }";
    }

    public class ReadTimeoutException
    extends IOException {
        private static final long serialVersionUID = -3217758894326719909L;
    }
}

