/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.searchservice.searchlibrary.resultset.elements;

import org.gcube.common.searchservice.searchlibrary.resultset.elements.PropertyElementBase;

public class PropertyElementEstimationCount
extends PropertyElementBase {
    public static String propertyType = "EstimationCount";
    public static int unspecified = Integer.MIN_VALUE;
    private int min = unspecified;
    private int max = unspecified;
    private int estimation = unspecified;

    public PropertyElementEstimationCount() {
    }

    public PropertyElementEstimationCount(int min, int max, int estimation) throws Exception {
        this.min = min;
        this.max = max;
        this.estimation = estimation;
        this.setType(propertyType);
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public int getEstimation() {
        return this.estimation;
    }

    @Override
    public String toXML() throws Exception {
        return "<min>" + this.min + "</min><max>" + this.max + "</max><estimation>" + this.estimation + "</estimation>";
    }

    @Override
    public void fromXML(String xml) throws Exception {
        int minStart = xml.indexOf("<min>");
        int minStop = xml.indexOf("</min>");
        int maxStart = xml.indexOf("<max>");
        int maxStop = xml.indexOf("</max>");
        int estimationStart = xml.indexOf("<estimation>");
        int estimationStop = xml.indexOf("</estimation>");
        if (minStart < 0 || minStop < 0 || maxStart < 0 || maxStop < 0 || estimationStart < 0 || estimationStop < 0 || minStart >= minStop || maxStart >= maxStop || estimationStart >= estimationStop) {
            throw new Exception("invalid serialization");
        }
        String min = xml.substring(minStart + "<min>".length(), minStop);
        String max = xml.substring(maxStart + "<max>".length(), maxStop);
        String estimation = xml.substring(estimationStart + "<estimation>".length(), estimationStop);
        if (estimation == null || estimation.trim().length() <= 0 || min == null || min.trim().length() <= 0 || max == null || max.trim().length() <= 0) {
            throw new Exception("invalid serialization");
        }
        this.min = Integer.parseInt(min);
        this.max = Integer.parseInt(max);
        this.estimation = Integer.parseInt(estimation);
    }
}

