/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.commons.state.store.data;

import gr.uoa.di.madgik.commons.configuration.ConfigurationManager;
import gr.uoa.di.madgik.commons.state.store.StateStoreInfo;
import gr.uoa.di.madgik.commons.state.store.data.ISerializable;
import gr.uoa.di.madgik.commons.state.store.registry.StateStoreRegistryKey;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StateStoreData {
    private static final Logger logger = Logger.getLogger(StateStoreData.class.getName());
    private StateStoreInfo Info = null;

    public StateStoreData(StateStoreInfo Info2) {
        this.Info = Info2;
    }

    public void Put(StateStoreRegistryKey Key, String Alphanumeric) throws Exception {
        RandomAccessFile acc = null;
        try {
            acc = new RandomAccessFile(this.Info.GetEntryDataFile(), "rw");
            acc.seek(this.Info.GetEntryDataFile().length());
            long start = acc.getFilePointer();
            acc.write(Alphanumeric.getBytes(ConfigurationManager.GetStringParameter("EncodingCharset")));
            long end = acc.getFilePointer();
            Key.SetStartingDataOffset(start);
            Key.SetEndingDataOffset(end);
            acc.close();
        }
        catch (Exception ex) {
            try {
                if (acc != null) {
                    acc.close();
                }
            }
            catch (Exception exx) {
                // empty catch block
            }
            throw ex;
        }
    }

    public String GetAlphanumeric(StateStoreRegistryKey Key) throws Exception {
        FilterInputStream din = null;
        try {
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "Retrieving " + Key.GetKey() + " from " + Key.GetStartingDataOffset() + "-" + Key.GetEndingDataOffset());
            }
            din = new DataInputStream(new BufferedInputStream(new FileInputStream(this.Info.GetEntryDataFile())));
            din.skip(Key.GetStartingDataOffset());
            int size = (int)(Key.GetEndingDataOffset() - Key.GetStartingDataOffset());
            byte[] buf = new byte[size];
            ((DataInputStream)din).readFully(buf);
            String ret = new String(buf, ConfigurationManager.GetStringParameter("EncodingCharset"));
            din.close();
            return ret;
        }
        catch (Exception ex) {
            if (din != null) {
                din.close();
            }
            throw ex;
        }
    }

    public void Put(StateStoreRegistryKey Key, byte[] bytearray) throws Exception {
        RandomAccessFile acc = null;
        try {
            acc = new RandomAccessFile(this.Info.GetEntryDataFile(), "rw");
            acc.seek(this.Info.GetEntryDataFile().length());
            long start = acc.getFilePointer();
            acc.write(bytearray);
            long end = acc.getFilePointer();
            Key.SetStartingDataOffset(start);
            Key.SetEndingDataOffset(end);
            acc.close();
        }
        catch (Exception ex) {
            try {
                if (acc != null) {
                    acc.close();
                }
            }
            catch (Exception exx) {
                // empty catch block
            }
            throw ex;
        }
    }

    public byte[] GetByteArray(StateStoreRegistryKey Key) throws Exception {
        FilterInputStream din = null;
        try {
            din = new DataInputStream(new BufferedInputStream(new FileInputStream(this.Info.GetEntryDataFile())));
            din.skip(Key.GetStartingDataOffset());
            int size = (int)(Key.GetEndingDataOffset() - Key.GetStartingDataOffset());
            byte[] buf = new byte[size];
            ((DataInputStream)din).readFully(buf);
            din.close();
            return buf;
        }
        catch (Exception ex) {
            if (din != null) {
                din.close();
            }
            throw ex;
        }
    }

    public void Put(StateStoreRegistryKey Key, ISerializable obj) throws Exception {
        RandomAccessFile acc = null;
        try {
            acc = new RandomAccessFile(this.Info.GetEntryDataFile(), "rw");
            acc.seek(this.Info.GetEntryDataFile().length());
            long start = acc.getFilePointer();
            byte[] classname = obj.getClass().getName().getBytes(ConfigurationManager.GetStringParameter("EncodingCharset"));
            acc.writeInt(classname.length);
            acc.write(classname);
            acc.write(obj.Serialize());
            long end = acc.getFilePointer();
            Key.SetStartingDataOffset(start);
            Key.SetEndingDataOffset(end);
            acc.close();
        }
        catch (Exception ex) {
            try {
                if (acc != null) {
                    acc.close();
                }
            }
            catch (Exception exx) {
                // empty catch block
            }
            throw ex;
        }
    }

    public ISerializable GetISerializable(StateStoreRegistryKey Key) throws Exception {
        FilterInputStream din = null;
        try {
            din = new DataInputStream(new BufferedInputStream(new FileInputStream(this.Info.GetEntryDataFile())));
            din.skip(Key.GetStartingDataOffset());
            int fullentrysize = (int)(Key.GetEndingDataOffset() - Key.GetStartingDataOffset());
            byte[] classname = new byte[((DataInputStream)din).readInt()];
            ((DataInputStream)din).readFully(classname);
            String objname = new String(classname, ConfigurationManager.GetStringParameter("EncodingCharset"));
            Class<?> ModuleClass = Class.forName(objname);
            Object Instance = null;
            Instance = ModuleClass.newInstance();
            if (!(Instance instanceof ISerializable)) {
                throw new Exception("Found instance does not implement ISerializable interface");
            }
            byte[] buf = new byte[fullentrysize - 4 - classname.length];
            ((DataInputStream)din).readFully(buf);
            din.close();
            ((ISerializable)Instance).Deserialize(buf);
            return Instance;
        }
        catch (Exception ex) {
            if (din != null) {
                din.close();
            }
            throw ex;
        }
    }

    public void Put(StateStoreRegistryKey Key, Serializable obj) throws Exception {
        RandomAccessFile acc = null;
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            ObjectOutputStream oout = new ObjectOutputStream(bout);
            oout.writeObject(obj);
            oout.flush();
            bout.flush();
            oout.close();
            bout.close();
            acc = new RandomAccessFile(this.Info.GetEntryDataFile(), "rw");
            acc.seek(this.Info.GetEntryDataFile().length());
            long start = acc.getFilePointer();
            acc.write(bout.toByteArray());
            long end = acc.getFilePointer();
            Key.SetStartingDataOffset(start);
            Key.SetEndingDataOffset(end);
            acc.close();
        }
        catch (Exception ex) {
            try {
                if (acc != null) {
                    acc.close();
                }
            }
            catch (Exception exx) {
                // empty catch block
            }
            throw ex;
        }
    }

    public Serializable GetSerializable(StateStoreRegistryKey Key) throws Exception {
        FilterInputStream din = null;
        try {
            din = new DataInputStream(new BufferedInputStream(new FileInputStream(this.Info.GetEntryDataFile())));
            din.skip(Key.GetStartingDataOffset());
            int fullentrysize = (int)(Key.GetEndingDataOffset() - Key.GetStartingDataOffset());
            byte[] buf = new byte[fullentrysize];
            ((DataInputStream)din).readFully(buf);
            din.close();
            ObjectInputStream oin = new ObjectInputStream(new ByteArrayInputStream(buf));
            Object Instance = oin.readObject();
            if (!(Instance instanceof Serializable)) {
                throw new Exception("Found instance does not implement Serializable interface");
            }
            return (Serializable)Instance;
        }
        catch (Exception ex) {
            if (din != null) {
                din.close();
            }
            throw ex;
        }
    }

    public void Put(StateStoreRegistryKey Key, File file) throws Exception {
        RandomAccessFile acc = null;
        BufferedInputStream bin = null;
        try {
            int n;
            bin = new BufferedInputStream(new FileInputStream(file));
            acc = new RandomAccessFile(this.Info.GetEntryDataFile(), "rw");
            acc.seek(this.Info.GetEntryDataFile().length());
            long start = acc.getFilePointer();
            byte[] buf = new byte[4096];
            while ((n = bin.read(buf)) >= 0) {
                acc.write(buf, 0, n);
            }
            long end = acc.getFilePointer();
            Key.SetStartingDataOffset(start);
            Key.SetEndingDataOffset(end);
            acc.close();
        }
        catch (Exception ex) {
            try {
                if (acc != null) {
                    acc.close();
                }
            }
            catch (Exception exx) {
                // empty catch block
            }
            try {
                if (bin != null) {
                    bin.close();
                }
            }
            catch (Exception exx) {
                // empty catch block
            }
            throw ex;
        }
    }

    public File GetFile(StateStoreRegistryKey Key) throws Exception {
        FilterInputStream din = null;
        File tmp = null;
        FilterOutputStream bout = null;
        try {
            tmp = File.createTempFile(UUID.randomUUID().toString(), ".state.entry.data.tmp");
            bout = new BufferedOutputStream(new FileOutputStream(tmp));
            din = new DataInputStream(new BufferedInputStream(new FileInputStream(this.Info.GetEntryDataFile())));
            din.skip(Key.GetStartingDataOffset());
            long fullentrysize = Key.GetEndingDataOffset() - Key.GetStartingDataOffset();
            byte[] buf = new byte[4096];
            long count = 0L;
            while (count < fullentrysize) {
                int n;
                int remaining = buf.length;
                if (count + (long)remaining > fullentrysize) {
                    remaining = (int)(fullentrysize - count);
                }
                if ((n = ((DataInputStream)din).read(buf, 0, remaining)) < 0) break;
                ((BufferedOutputStream)bout).write(buf, 0, n);
            }
            ((BufferedOutputStream)bout).flush();
            bout.close();
            din.close();
            return tmp;
        }
        catch (Exception ex) {
            if (din != null) {
                din.close();
            }
            if (tmp != null) {
                tmp.delete();
            }
            if (bout != null) {
                bout.close();
            }
            throw ex;
        }
    }

    private void Move(Map.Entry<String, StateStoreRegistryKey> entry, RandomAccessFile din, RandomAccessFile acc) throws Exception {
        int n;
        long startoffset = acc.getFilePointer();
        long length = entry.getValue().GetEndingDataOffset() - entry.getValue().GetStartingDataOffset();
        din.seek(entry.getValue().GetStartingDataOffset());
        byte[] buf = new byte[4096];
        for (long count = 0L; count < length; count += (long)n) {
            int remaining = buf.length;
            if (length - count < (long)remaining) {
                remaining = (int)(length - count);
            }
            if ((n = din.read(buf, 0, remaining)) < 0) break;
            acc.write(buf, 0, n);
        }
        long endoffset = acc.getFilePointer();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Moved entry " + entry.getKey() + " from " + entry.getValue().GetStartingDataOffset() + "-" + entry.getValue().GetEndingDataOffset() + " to " + startoffset + "-" + endoffset);
        }
        entry.getValue().SetStartingDataOffset(startoffset);
        entry.getValue().SetEndingDataOffset(endoffset);
    }

    public File MoveToClean(Map<String, StateStoreRegistryKey> registry) throws Exception {
        File tmp = null;
        RandomAccessFile acc = null;
        RandomAccessFile din = null;
        try {
            tmp = File.createTempFile(UUID.randomUUID().toString(), ".madgik.state.data.tmp");
            acc = new RandomAccessFile(tmp, "rw");
            if (!this.Info.GetEntryDataFile().exists()) {
                acc.close();
                return tmp;
            }
            din = new RandomAccessFile(this.Info.GetEntryDataFile(), "rw");
            for (Map.Entry<String, StateStoreRegistryKey> entry : registry.entrySet()) {
                this.Move(entry, din, acc);
            }
            din.close();
            acc.close();
            return tmp;
        }
        catch (Exception ex) {
            try {
                if (din != null) {
                    din.close();
                }
            }
            catch (Exception exx) {
                // empty catch block
            }
            try {
                if (acc != null) {
                    acc.close();
                }
            }
            catch (Exception exx) {
                // empty catch block
            }
            try {
                if (tmp != null) {
                    tmp.delete();
                }
            }
            catch (Exception exx) {
                // empty catch block
            }
            throw ex;
        }
    }
}

