/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.security.authentication.secureconv;

import java.net.URL;
import java.util.Map;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import javax.xml.rpc.Stub;
import javax.xml.rpc.handler.GenericHandler;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.handler.MessageContext;
import org.apache.axis.message.addressing.AddressingHeaders;
import org.apache.axis.message.addressing.To;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.axis.gsi.GSIConstants;
import org.globus.gsi.gssapi.GSSConstants;
import org.globus.gsi.jaas.JaasGssUtil;
import org.globus.gsi.jaas.JaasSubject;
import org.globus.wsrf.impl.security.authentication.Constants;
import org.globus.wsrf.impl.security.authentication.secureconv.Authenticator;
import org.globus.wsrf.impl.security.authentication.secureconv.service.SecurityContext;
import org.globus.wsrf.impl.security.authentication.wssec.WSSecurityFault;
import org.globus.wsrf.impl.security.authorization.Authorization;
import org.globus.wsrf.impl.security.authorization.HostAuthorization;
import org.globus.wsrf.impl.security.authorization.SelfAuthorization;
import org.globus.wsrf.impl.security.util.AuthUtil;
import org.globus.wsrf.security.impl.secconv.SecureConversation;
import org.globus.wsrf.security.impl.secconv.SecureConversationServiceAddressingLocator;
import org.gridforum.jgss.ExtendedGSSContext;
import org.gridforum.jgss.ExtendedGSSManager;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class SecContextHandler
extends GenericHandler {
    protected static Log log = LogFactory.getLog(SecContextHandler.class.getName());
    private Authenticator authInfo;
    private String lastMode;
    private Integer lastContextLifetime;
    private boolean auto;
    private Thread lastThread;
    private static SecureConversationServiceAddressingLocator locator = new SecureConversationServiceAddressingLocator();

    public SecContextHandler() {
        log.debug("Enter: constructor");
    }

    public boolean handleRequest(MessageContext msgContext) {
        String mode;
        log.debug("Enter: invoke");
        Object tmp = msgContext.getProperty("org.globus.security.secConv.msg.type");
        if (tmp == null || tmp.equals(Constants.NONE)) {
            this.authInfo = null;
            log.debug("Exit: invoke");
            return true;
        }
        if (log.isDebugEnabled()) {
            if (this.lastThread == null) {
                this.lastThread = Thread.currentThread();
            } else if (this.lastThread != Thread.currentThread()) {
                throw WSSecurityFault.makeFault(new Exception("Multiple threads accessing the same handler!"));
            }
        }
        if ((mode = (String)msgContext.getProperty("org.globus.gsi.mode")) == null) {
            mode = "gsi";
        }
        Integer contextLifetime = (Integer)msgContext.getProperty("org.globus.security.context.lifetime");
        if (this.authInfo == null || !mode.equals(this.lastMode) || contextLifetime != null && !contextLifetime.equals(this.lastContextLifetime)) {
            log.debug("Establishing new context");
            try {
                Authorization author;
                Subject subject;
                String endpointAddress = AuthUtil.getEndpointAddress(msgContext);
                if (this.auto) {
                    endpointAddress = endpointAddress + "-authService";
                }
                log.debug("Endpoint address is " + endpointAddress);
                URL url = new URL(endpointAddress);
                AddressingHeaders headers = (AddressingHeaders)msgContext.getProperty("org.apache.axis.message.addressing.REQUEST.HEADERS");
                To savedTo = headers.getTo();
                headers.setTo(new To(endpointAddress));
                SecureConversation authPort = locator.getSecureConversationPort(url);
                ((Stub)((Object)authPort))._setProperty("org.apache.axis.message.addressing.REQUEST.HEADERS", headers);
                GSSCredential gssCred = AuthUtil.getCredential(msgContext);
                if (gssCred == null && (subject = JaasSubject.getCurrentSubject()) != null) {
                    log.debug("Get credentials assocaited with thread");
                    gssCred = JaasGssUtil.getCredential(subject);
                }
                int lifetime = 0;
                if (contextLifetime != null) {
                    lifetime = contextLifetime;
                }
                log.debug("Lifetime is " + lifetime);
                GSSManager manager = ExtendedGSSManager.getInstance();
                boolean anonymous = false;
                Object anon = msgContext.getProperty("org.globus.gsi.anonymous");
                if (anon == null) {
                    anon = msgContext.getProperty("org.globus.security.secConv.anon");
                }
                if (anon != null && anon.equals(Boolean.TRUE)) {
                    log.debug("Anonymous is true");
                    anonymous = true;
                }
                GSSName name = null;
                if (anonymous) {
                    name = manager.createName((String)null, (Oid)null);
                    gssCred = manager.createCredential(name, 0, (Oid)null, 1);
                }
                if ((author = AuthUtil.getClientAuthorization(msgContext)) == null) {
                    author = HostAuthorization.getInstance();
                }
                log.debug("Authz is " + author.getClass().getName());
                if (author instanceof SelfAuthorization) {
                    if (!anonymous && gssCred == null) {
                        gssCred = manager.createCredential(1);
                    }
                    name = gssCred.getName();
                } else {
                    name = author.getName(msgContext);
                }
                ((Stub)((Object)authPort))._setProperty("org.globus.security.authorization", author);
                if (gssCred != null) {
                    ((Stub)((Object)authPort))._setProperty("org.globus.gsi.credentials", gssCred);
                }
                ExtendedGSSContext context = (ExtendedGSSContext)manager.createContext(name, GSSConstants.MECH_OID, gssCred, lifetime);
                context.requestConf(true);
                if (anonymous) {
                    log.debug("Setting anonyumous true");
                    context.requestAnonymity(true);
                }
                log.debug("Delegation mode: " + mode);
                if (mode.equalsIgnoreCase("gsilimited")) {
                    context.setOption(GSSConstants.DELEGATION_TYPE, GSIConstants.DELEGATION_TYPE_LIMITED);
                    context.requestCredDeleg(true);
                } else if (mode.equalsIgnoreCase("gsifull")) {
                    context.setOption(GSSConstants.DELEGATION_TYPE, GSIConstants.DELEGATION_TYPE_FULL);
                    context.requestCredDeleg(true);
                } else if (mode.equalsIgnoreCase("gsi")) {
                    context.requestCredDeleg(false);
                } else {
                    throw new Exception("Invalid GSI MODE: " + mode);
                }
                this.lastMode = mode;
                this.lastContextLifetime = contextLifetime;
                this.authInfo = new Authenticator(context);
                this.authInfo.authenticate(authPort);
                headers.setTo(savedTo);
                log.debug("Context established");
            }
            catch (Exception e) {
                this.authInfo = null;
                log.debug("Failed to establish security context", e);
                throw WSSecurityFault.makeFault(e);
            }
        } else {
            log.debug("Reusing existing context");
        }
        SecurityContext secContext = new SecurityContext(this.authInfo.getContext(), this.authInfo.getContextId());
        msgContext.setProperty("org.globus.security.secureconv.context", secContext);
        log.debug("Exit: invoke");
        return true;
    }

    public void init(HandlerInfo config) {
        if (config == null) {
            return;
        }
        Map options = config.getHandlerConfig();
        if (options == null) {
            return;
        }
        String type = (String)options.get("authService");
        this.auto = type != null && type.equals("auto");
    }

    public QName[] getHeaders() {
        return null;
    }
}

