/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.handlers;

import java.util.Calendar;
import javax.xml.soap.SOAPHeaderElement;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.SOAPPart;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.message.addressing.Address;
import org.apache.axis.message.addressing.AddressingHeaders;
import org.apache.axis.message.addressing.EndpointReference;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.axis.message.addressing.ReferencePropertiesType;
import org.apache.axis.message.addressing.To;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.util.I18n;
import org.globus.wsrf.ResourceContext;
import org.globus.wsrf.impl.ResourceContextImpl;
import org.globus.wsrf.utils.Resources;
import org.oasis.wsrf.faults.BaseFaultType;

public class FaultHandler
extends BasicHandler {
    private static Log logger = LogFactory.getLog(FaultHandler.class.getName());
    private static I18n i18n = I18n.getI18n(Resources.class.getName());

    public void invoke(MessageContext msgContext) throws AxisFault {
        AddressingHeaders headers = (AddressingHeaders)msgContext.getProperty("org.apache.axis.message.addressing.RESPONSE.HEADERS");
        if (headers == null) {
            headers = new AddressingHeaders();
            msgContext.setProperty("org.apache.axis.message.addressing.RESPONSE.HEADERS", headers);
        }
        if (headers.getFrom() != null) {
            return;
        }
        EndpointReference from = this.getFrom(msgContext);
        if (from != null) {
            headers.setFrom(from);
        }
    }

    public void onFault(MessageContext msgContext) {
        EndpointReferenceType originator;
        Message msg = msgContext.getCurrentMessage();
        if (msg == null) {
            return;
        }
        SOAPPart part = (SOAPPart)msg.getSOAPPart();
        if (part == null) {
            return;
        }
        Object obj = part.getCurrentMessage();
        if (!(obj instanceof BaseFaultType)) {
            return;
        }
        BaseFaultType fault = (BaseFaultType)obj;
        Calendar timestamp = fault.getTimestamp();
        if (timestamp == null) {
            fault.setTimestamp(Calendar.getInstance());
        }
        if ((originator = fault.getOriginator()) == null) {
            originator = this.getFrom(msgContext);
            fault.setOriginator(originator);
        }
    }

    private EndpointReference getFrom(MessageContext msgContext) {
        if (msgContext.getService() == null) {
            return null;
        }
        AddressingHeaders headers = (AddressingHeaders)msgContext.getProperty("org.apache.axis.message.addressing.REQUEST.HEADERS");
        if (headers == null) {
            return null;
        }
        To to = headers.getTo();
        if (to == null) {
            logger.warn(i18n.getMessage("noToHeader"));
            return null;
        }
        Address address = new Address(to);
        EndpointReference fromEPR = new EndpointReference(address);
        Message requestMsg = msgContext.getRequestMessage();
        try {
            ReferencePropertiesType props = this.getReferenceProperties(msgContext, requestMsg);
            if (props != null) {
                fromEPR.setProperties(props);
            }
        }
        catch (Exception e) {
            logger.debug("", e);
        }
        return fromEPR;
    }

    private ReferencePropertiesType getReferenceProperties(MessageContext ctx, Message msg) throws Exception {
        ReferencePropertiesType props = null;
        ResourceContextImpl resourceCtx = new ResourceContextImpl(ctx, msg);
        SOAPHeaderElement element = ((ResourceContext)resourceCtx).getResourceKeyHeader();
        if (element != null) {
            props = new ReferencePropertiesType();
            props.add(element);
        }
        return props;
    }
}

