/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.selectors;

import java.io.File;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.types.Resource;

public final class SelectorUtils {
    private static SelectorUtils instance = new SelectorUtils();

    private SelectorUtils() {
    }

    public static SelectorUtils getInstance() {
        return instance;
    }

    public static boolean matchPatternStart(String pattern, String str) {
        return SelectorUtils.matchPatternStart(pattern, str, true);
    }

    public static boolean matchPatternStart(String pattern, String str, boolean isCaseSensitive) {
        if (str.startsWith(File.separator) != pattern.startsWith(File.separator)) {
            return false;
        }
        String[] patDirs = SelectorUtils.tokenizePathAsArray(pattern);
        String[] strDirs = SelectorUtils.tokenizePathAsArray(str);
        int patIdxStart = 0;
        int patIdxEnd = patDirs.length - 1;
        int strIdxStart = 0;
        int strIdxEnd = strDirs.length - 1;
        while (patIdxStart <= patIdxEnd && strIdxStart <= strIdxEnd) {
            String patDir = patDirs[patIdxStart];
            if (patDir.equals("**")) break;
            if (!SelectorUtils.match(patDir, strDirs[strIdxStart], isCaseSensitive)) {
                return false;
            }
            ++patIdxStart;
            ++strIdxStart;
        }
        if (strIdxStart > strIdxEnd) {
            return true;
        }
        return patIdxStart <= patIdxEnd;
    }

    public static boolean matchPath(String pattern, String str) {
        return SelectorUtils.matchPath(pattern, str, true);
    }

    /*
     * Unable to fully structure code
     */
    public static boolean matchPath(String pattern, String str, boolean isCaseSensitive) {
        if (str.startsWith(File.separator) != pattern.startsWith(File.separator)) {
            return false;
        }
        patDirs = SelectorUtils.tokenizePathAsArray(pattern);
        strDirs = SelectorUtils.tokenizePathAsArray(str);
        patIdxStart = 0;
        patIdxEnd = patDirs.length - 1;
        strIdxStart = 0;
        strIdxEnd = strDirs.length - 1;
        while (patIdxStart <= patIdxEnd && strIdxStart <= strIdxEnd) {
            patDir = patDirs[patIdxStart];
            if (patDir.equals("**")) break;
            if (!SelectorUtils.match(patDir, strDirs[strIdxStart], isCaseSensitive)) {
                patDirs = null;
                strDirs = null;
                return false;
            }
            ++patIdxStart;
            ++strIdxStart;
        }
        if (strIdxStart > strIdxEnd) {
            i = patIdxStart;
            while (i <= patIdxEnd) {
                if (!patDirs[i].equals("**")) {
                    patDirs = null;
                    strDirs = null;
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (patIdxStart <= patIdxEnd) ** GOTO lbl40
        patDirs = null;
        strDirs = null;
        return false;
        while (!(patDir = patDirs[patIdxEnd]).equals("**")) {
            if (!SelectorUtils.match(patDir, strDirs[strIdxEnd], isCaseSensitive)) {
                patDirs = null;
                strDirs = null;
                return false;
            }
            --patIdxEnd;
            --strIdxEnd;
lbl40:
            // 2 sources

            if (patIdxStart <= patIdxEnd && strIdxStart <= strIdxEnd) continue;
        }
        if (strIdxStart <= strIdxEnd) ** GOTO lbl86
        i = patIdxStart;
        while (i <= patIdxEnd) {
            if (!patDirs[i].equals("**")) {
                patDirs = null;
                strDirs = null;
                return false;
            }
            ++i;
        }
        return true;
lbl-1000:
        // 1 sources

        {
            patIdxTmp = -1;
            i = patIdxStart + 1;
            while (i <= patIdxEnd) {
                if (patDirs[i].equals("**")) {
                    patIdxTmp = i;
                    break;
                }
                ++i;
            }
            if (patIdxTmp == patIdxStart + 1) {
                ++patIdxStart;
                continue;
            }
            patLength = patIdxTmp - patIdxStart - 1;
            strLength = strIdxEnd - strIdxStart + 1;
            foundIdx = -1;
            i = 0;
            while (i <= strLength - patLength) {
                block20: {
                    j = 0;
                    while (j < patLength) {
                        subPat = patDirs[patIdxStart + j + 1];
                        subStr = strDirs[strIdxStart + i + j];
                        if (SelectorUtils.match(subPat, subStr, isCaseSensitive)) {
                            ++j;
                            continue;
                        }
                        break block20;
                    }
                    foundIdx = strIdxStart + i;
                    break;
                }
                ++i;
            }
            if (foundIdx == -1) {
                patDirs = null;
                strDirs = null;
                return false;
            }
            patIdxStart = patIdxTmp;
            strIdxStart = foundIdx + patLength;
lbl86:
            // 3 sources

            ** while (patIdxStart != patIdxEnd && strIdxStart <= strIdxEnd)
        }
lbl87:
        // 1 sources

        i = patIdxStart;
        while (i <= patIdxEnd) {
            if (!patDirs[i].equals("**")) {
                patDirs = null;
                strDirs = null;
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean match(String pattern, String str) {
        return SelectorUtils.match(pattern, str, true);
    }

    /*
     * Unable to fully structure code
     */
    public static boolean match(String pattern, String str, boolean isCaseSensitive) {
        patArr = pattern.toCharArray();
        strArr = str.toCharArray();
        patIdxStart = 0;
        patIdxEnd = patArr.length - 1;
        strIdxStart = 0;
        strIdxEnd = strArr.length - 1;
        containsStar = false;
        i = 0;
        while (i < patArr.length) {
            if (patArr[i] == '*') {
                containsStar = true;
                break;
            }
            ++i;
        }
        if (!containsStar) {
            if (patIdxEnd != strIdxEnd) {
                return false;
            }
            i = 0;
            while (i <= patIdxEnd) {
                ch = patArr[i];
                if (ch != '?') {
                    if (isCaseSensitive && ch != strArr[i]) {
                        return false;
                    }
                    if (!isCaseSensitive && Character.toUpperCase(ch) != Character.toUpperCase(strArr[i])) {
                        return false;
                    }
                }
                ++i;
            }
            return true;
        }
        if (patIdxEnd != 0) ** GOTO lbl38
        return true;
lbl-1000:
        // 1 sources

        {
            if (ch != '?') {
                if (isCaseSensitive && ch != strArr[strIdxStart]) {
                    return false;
                }
                if (!isCaseSensitive && Character.toUpperCase(ch) != Character.toUpperCase(strArr[strIdxStart])) {
                    return false;
                }
            }
            ++patIdxStart;
            ++strIdxStart;
lbl38:
            // 2 sources

            ** while ((ch = patArr[patIdxStart]) != '*' && strIdxStart <= strIdxEnd)
        }
lbl39:
        // 1 sources

        if (strIdxStart <= strIdxEnd) ** GOTO lbl54
        i = patIdxStart;
        while (i <= patIdxEnd) {
            if (patArr[i] != '*') {
                return false;
            }
            ++i;
        }
        return true;
lbl-1000:
        // 1 sources

        {
            if (ch != '?') {
                if (isCaseSensitive && ch != strArr[strIdxEnd]) {
                    return false;
                }
                if (!isCaseSensitive && Character.toUpperCase(ch) != Character.toUpperCase(strArr[strIdxEnd])) {
                    return false;
                }
            }
            --patIdxEnd;
            --strIdxEnd;
lbl54:
            // 2 sources

            ** while ((ch = patArr[patIdxEnd]) != '*' && strIdxStart <= strIdxEnd)
        }
lbl55:
        // 1 sources

        if (strIdxStart <= strIdxEnd) ** GOTO lbl95
        i = patIdxStart;
        while (i <= patIdxEnd) {
            if (patArr[i] != '*') {
                return false;
            }
            ++i;
        }
        return true;
lbl-1000:
        // 1 sources

        {
            patIdxTmp = -1;
            i = patIdxStart + 1;
            while (i <= patIdxEnd) {
                if (patArr[i] == '*') {
                    patIdxTmp = i;
                    break;
                }
                ++i;
            }
            if (patIdxTmp == patIdxStart + 1) {
                ++patIdxStart;
                continue;
            }
            patLength = patIdxTmp - patIdxStart - 1;
            strLength = strIdxEnd - strIdxStart + 1;
            foundIdx = -1;
            i = 0;
            while (i <= strLength - patLength) {
                block30: {
                    j = 0;
                    while (j < patLength) {
                        ch = patArr[patIdxStart + j + 1];
                        if (ch == '?' || (!isCaseSensitive || ch == strArr[strIdxStart + i + j]) && (isCaseSensitive || Character.toUpperCase(ch) == Character.toUpperCase(strArr[strIdxStart + i + j]))) {
                            ++j;
                            continue;
                        }
                        break block30;
                    }
                    foundIdx = strIdxStart + i;
                    break;
                }
                ++i;
            }
            if (foundIdx == -1) {
                return false;
            }
            patIdxStart = patIdxTmp;
            strIdxStart = foundIdx + patLength;
lbl95:
            // 3 sources

            ** while (patIdxStart != patIdxEnd && strIdxStart <= strIdxEnd)
        }
lbl96:
        // 1 sources

        i = patIdxStart;
        while (i <= patIdxEnd) {
            if (patArr[i] != '*') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static Vector tokenizePath(String path) {
        return SelectorUtils.tokenizePath(path, File.separator);
    }

    public static Vector tokenizePath(String path, String separator) {
        Vector<String> ret = new Vector<String>();
        StringTokenizer st = new StringTokenizer(path, separator);
        while (st.hasMoreTokens()) {
            ret.addElement(st.nextToken());
        }
        return ret;
    }

    private static String[] tokenizePathAsArray(String path) {
        String tok;
        char sep = File.separatorChar;
        int start = 0;
        int len = path.length();
        int count = 0;
        int pos = 0;
        while (pos < len) {
            if (path.charAt(pos) == sep) {
                if (pos != start) {
                    ++count;
                }
                start = pos + 1;
            }
            ++pos;
        }
        if (len != start) {
            ++count;
        }
        String[] l = new String[count];
        count = 0;
        start = 0;
        int pos2 = 0;
        while (pos2 < len) {
            if (path.charAt(pos2) == sep) {
                if (pos2 != start) {
                    tok = path.substring(start, pos2);
                    l[count++] = tok;
                }
                start = pos2 + 1;
            }
            ++pos2;
        }
        if (len != start) {
            l[count] = tok = path.substring(start);
        }
        return l;
    }

    public static boolean isOutOfDate(File src, File target, int granularity) {
        if (!src.exists()) {
            return false;
        }
        if (!target.exists()) {
            return true;
        }
        return src.lastModified() - (long)granularity > target.lastModified();
    }

    public static boolean isOutOfDate(Resource src, Resource target, int granularity) {
        if (!src.isExists()) {
            return false;
        }
        if (!target.isExists()) {
            return true;
        }
        return src.getLastModified() - (long)granularity > target.getLastModified();
    }

    public static String removeWhitespace(String input) {
        StringBuffer result = new StringBuffer();
        if (input != null) {
            StringTokenizer st = new StringTokenizer(input);
            while (st.hasMoreTokens()) {
                result.append(st.nextToken());
            }
        }
        return result.toString();
    }

    public static boolean hasWildcards(String input) {
        return input.indexOf(42) != -1 || input.indexOf(63) != -1;
    }

    public static String rtrimWildcardTokens(String input) {
        Vector v = SelectorUtils.tokenizePath(input, File.separator);
        StringBuffer sb = new StringBuffer();
        int counter = 0;
        while (counter < v.size()) {
            if (SelectorUtils.hasWildcards((String)v.elementAt(counter))) break;
            if (counter > 0) {
                sb.append(File.separator);
            }
            sb.append((String)v.elementAt(counter));
            ++counter;
        }
        return sb.toString();
    }
}

