/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.messaging.common.producer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.messaging.common.messages.GCUBEMessage;
import org.gcube.messaging.common.producer.GCUBELocalProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveMQClient
implements Runnable {
    private static Logger logger = LoggerFactory.getLogger(ActiveMQClient.class);
    private static int ackMode;
    private static boolean transacted;
    private static ActiveMQClient singleton;
    private String selectorBase = "MessageType";
    private static Integer MAX_ACCOUNTING_QUEUE_SIZE;
    private static ConcurrentLinkedQueue<GCUBEMessage> messageForQueue;

    private ActiveMQClient() {
    }

    public void sendMessageToQueue(GCUBEMessage message) {
        ArrayList<QueueConnection> connections = GCUBELocalProducer.getQueueConnection(GCUBEScope.getScope((String)message.getScope()));
        if (connections != null) {
            for (QueueConnection connection : connections) {
                try {
                    QueueSession session = connection.createQueueSession(transacted, ackMode);
                    Queue queue = session.createQueue(message.getTopic());
                    QueueSender sender = session.createSender(queue);
                    sender.setDeliveryMode(2);
                    ObjectMessage objMsg = session.createObjectMessage();
                    objMsg.setObject((Serializable)message);
                    objMsg.setJMSMessageID(this.createRandomString());
                    sender.send((Message)objMsg);
                    logger.debug("Message " + message.toString() + " SENT");
                    return;
                }
                catch (JMSException e) {
                    logger.error("Exception sending message to the Broker", (Throwable)e);
                    this.enqueueMessageForQueue(message);
                }
                catch (Exception e) {
                    logger.error("Exception sending message to the Broker", (Throwable)e);
                    this.enqueueMessageForQueue(message);
                }
            }
        }
        GCUBELocalProducer.reloadConnection(GCUBEScope.getScope((String)message.getScope()));
    }

    private String createRandomString() {
        Random random = new Random(System.currentTimeMillis());
        long randomLong = random.nextLong();
        return Long.toHexString(randomLong);
    }

    public static ActiveMQClient getSingleton() {
        return singleton;
    }

    public void setSingleton(ActiveMQClient singleton) {
        ActiveMQClient.singleton = singleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueueMessageForQueue(GCUBEMessage message) {
        try {
            ConcurrentLinkedQueue<GCUBEMessage> concurrentLinkedQueue = messageForQueue;
            synchronized (concurrentLinkedQueue) {
                if (messageForQueue.size() >= MAX_ACCOUNTING_QUEUE_SIZE) {
                    logger.error("Reached Maximum queue size, message discarded");
                    logger.error(message.toString());
                } else {
                    messageForQueue.add(message);
                }
            }
        }
        catch (Exception e) {
            logger.error("Error enqueuing GCUBEMessage : " + message.toString(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int sizeQueue = 0;
        while (true) {
            ConcurrentLinkedQueue<GCUBEMessage> concurrentLinkedQueue = messageForQueue;
            synchronized (concurrentLinkedQueue) {
                sizeQueue = messageForQueue.size();
            }
            if (sizeQueue == 0) {
                try {
                    Thread.sleep(600000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (sizeQueue <= 0) continue;
            GCUBEMessage message = null;
            ConcurrentLinkedQueue<GCUBEMessage> concurrentLinkedQueue2 = messageForQueue;
            synchronized (concurrentLinkedQueue2) {
                message = messageForQueue.poll();
            }
            this.sendMessageToQueue(message);
            try {
                Thread.sleep(60000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    static {
        MAX_ACCOUNTING_QUEUE_SIZE = 1000;
        messageForQueue = null;
        ackMode = 1;
        transacted = false;
        singleton = new ActiveMQClient();
        messageForQueue = new ConcurrentLinkedQueue();
        Thread t = new Thread(singleton);
        t.start();
    }
}

